/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.java.workspace.entities.JavaResourceRootPropertiesEntity;
import com.intellij.java.workspace.entities.JavaRootsKt;
import com.intellij.java.workspace.entities.JavaSourceRootPropertiesEntity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.ide.legacyBridge.SourceRootTypeRegistry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/SourceRootFileIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/intellij/platform/workspace/jps/entities/SourceRootEntity;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PlatformInternalWorkspaceFileIndexContributor;", "<init>", "()V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerFileSets", "", "entity", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "dependenciesOnOtherEntities", "", "Lcom/intellij/workspaceModel/core/fileIndex/DependencyDescription;", "getDependenciesOnOtherEntities", "()Ljava/util/List;", "intellij.platform.projectModel.impl"})
public final class SourceRootFileIndexContributor
implements WorkspaceFileIndexContributor<SourceRootEntity>,
PlatformInternalWorkspaceFileIndexContributor {
    @Override
    @NotNull
    public Class<SourceRootEntity> getEntityClass() {
        return SourceRootEntity.class;
    }

    @Override
    public void registerFileSets(@NotNull SourceRootEntity entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        ModuleBridge module = ModuleEntityUtils.findModule(entity.getContentRoot().getModule(), storage);
        if (module != null) {
            VirtualFile contentRoot = VirtualFileUrls.getVirtualFile((VirtualFileUrl)entity.getContentRoot().getUrl());
            JpsModuleSourceRootType jpsModuleSourceRootType = SourceRootTypeRegistry.Companion.getInstance().findTypeById(entity.getRootTypeId());
            WorkspaceFileKind kind = (jpsModuleSourceRootType != null ? jpsModuleSourceRootType.isForTests() : false) ? WorkspaceFileKind.TEST_CONTENT : WorkspaceFileKind.CONTENT;
            JavaSourceRootPropertiesEntity javaProperties = JavaRootsKt.asJavaSourceRoot((SourceRootEntity)entity);
            JavaResourceRootPropertiesEntity resourceProperties = JavaRootsKt.asJavaResourceRoot((SourceRootEntity)entity);
            Object object = javaProperties;
            if (object == null || (object = object.getPackagePrefix()) == null) {
                Object object2 = resourceProperties;
                object = object2 != null && (object2 = object2.getRelativeOutputPath()) != null ? StringsKt.replace$default((String)object2, (char)'/', (char)'.', (boolean)false, (int)4, null) : "";
            }
            Object packagePrefix = object;
            boolean forGeneratedSources = javaProperties != null && javaProperties.getGenerated() || resourceProperties != null && resourceProperties.getGenerated();
            registrar.registerFileSet(entity.getUrl(), kind, (WorkspaceEntity)entity, (WorkspaceFileSetData)new ModuleSourceRootData(module, contentRoot, entity.getRootTypeId(), (String)packagePrefix, forGeneratedSources));
            registrar.registerExclusionPatterns(entity.getUrl(), entity.getContentRoot().getExcludedPatterns(), (WorkspaceEntity)entity);
        }
    }

    @Override
    @NotNull
    public List<DependencyDescription<SourceRootEntity>> getDependenciesOnOtherEntities() {
        Object[] objectArray = new DependencyDescription[]{new DependencyDescription.OnParent(ContentRootEntity.class, SourceRootFileIndexContributor::_get_dependenciesOnOtherEntities_$lambda$0), new DependencyDescription.OnChild(JavaSourceRootPropertiesEntity.class, SourceRootFileIndexContributor::_get_dependenciesOnOtherEntities_$lambda$1), new DependencyDescription.OnChild(JavaResourceRootPropertiesEntity.class, SourceRootFileIndexContributor::_get_dependenciesOnOtherEntities_$lambda$2)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Sequence _get_dependenciesOnOtherEntities_$lambda$0(ContentRootEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)it.getSourceRoots());
    }

    private static final SourceRootEntity _get_dependenciesOnOtherEntities_$lambda$1(JavaSourceRootPropertiesEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSourceRoot();
    }

    private static final SourceRootEntity _get_dependenciesOnOtherEntities_$lambda$2(JavaResourceRootPropertiesEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSourceRoot();
    }
}

