/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.platform.workspace.jps.JpsEntitySourceFactory;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.serialization.impl.FileInDirectorySourceNames;
import com.intellij.platform.workspace.storage.DummyParentEntitySource;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocationUtilKt;
import com.intellij.workspaceModel.ide.NonPersistentEntitySource;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeJpsEntitySourceFactoryInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J$\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0016\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0016\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeJpsEntitySourceFactoryImpl;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeJpsEntitySourceFactoryInternal;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createEntitySourceForModule", "Lcom/intellij/platform/workspace/storage/EntitySource;", "baseModuleDir", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "fileInDirectoryNames", "Lcom/intellij/platform/workspace/jps/serialization/impl/FileInDirectorySourceNames;", "moduleFileName", "", "createImportedEntitySource", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "createInternalEntitySourceForModule", "createEntitySourceForProjectLibrary", "fileName", "createEntitySourceForProjectSettings", "createInternalEntitySourceForProjectLibrary", "DummyParentEntitySourceForProjectSettings", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
public final class LegacyBridgeJpsEntitySourceFactoryImpl
implements LegacyBridgeJpsEntitySourceFactoryInternal {
    @NotNull
    private final Project project;

    public LegacyBridgeJpsEntitySourceFactoryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public EntitySource createEntitySourceForModule(@NotNull VirtualFileUrl baseModuleDir, @Nullable ProjectModelExternalSource externalSource, @Nullable FileInDirectorySourceNames fileInDirectoryNames, @Nullable String moduleFileName) {
        JpsFileEntitySource jpsFileEntitySource;
        Intrinsics.checkNotNullParameter((Object)baseModuleDir, (String)"baseModuleDir");
        if (fileInDirectoryNames != null && moduleFileName != null) {
            JpsProjectFileEntitySource.FileInDirectory fileInDirectory = fileInDirectoryNames.findSource(ModuleEntity.class, moduleFileName);
            jpsFileEntitySource = fileInDirectory != null ? (JpsFileEntitySource)fileInDirectory : this.createInternalEntitySourceForModule(this.project, baseModuleDir);
        } else {
            jpsFileEntitySource = this.createInternalEntitySourceForModule(this.project, baseModuleDir);
        }
        JpsFileEntitySource internalSource = jpsFileEntitySource;
        return this.createImportedEntitySource(this.project, externalSource, internalSource);
    }

    @Override
    @NotNull
    public EntitySource createEntitySourceForModule(@NotNull VirtualFileUrl baseModuleDir, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)baseModuleDir, (String)"baseModuleDir");
        return this.createEntitySourceForModule(baseModuleDir, externalSource, null, null);
    }

    private final EntitySource createImportedEntitySource(Project project, ProjectModelExternalSource externalSource, JpsFileEntitySource internalSource) {
        JpsFileEntitySource jpsFileEntitySource = internalSource;
        if (jpsFileEntitySource == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsFileEntitySource internalFile = jpsFileEntitySource;
        if (externalSource == null) {
            return (EntitySource)internalFile;
        }
        String string = externalSource.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return (EntitySource)new JpsImportedEntitySource(internalFile, string, ProjectUtilCore.isExternalStorageEnabled((Project)project));
    }

    private final JpsFileEntitySource createInternalEntitySourceForModule(Project project, VirtualFileUrl baseModuleDir) {
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation(project);
        if (jpsProjectConfigLocation == null) {
            return null;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        return (JpsFileEntitySource)new JpsProjectFileEntitySource.FileInDirectory(baseModuleDir, location);
    }

    @Override
    @NotNull
    public EntitySource createEntitySourceForProjectLibrary(@Nullable ProjectModelExternalSource externalSource, @Nullable FileInDirectorySourceNames fileInDirectoryNames, @Nullable String fileName) {
        JpsFileEntitySource jpsFileEntitySource;
        if (fileInDirectoryNames != null && fileName != null) {
            JpsProjectFileEntitySource.FileInDirectory fileInDirectory = fileInDirectoryNames.findSource(LibraryEntity.class, fileName);
            jpsFileEntitySource = fileInDirectory != null ? (JpsFileEntitySource)fileInDirectory : this.createInternalEntitySourceForProjectLibrary(this.project);
        } else {
            jpsFileEntitySource = this.createInternalEntitySourceForProjectLibrary(this.project);
        }
        JpsFileEntitySource internalEntitySource = jpsFileEntitySource;
        return this.createImportedEntitySource(this.project, externalSource, internalEntitySource);
    }

    @Override
    @NotNull
    public EntitySource createEntitySourceForProjectLibrary(@Nullable ProjectModelExternalSource externalSource) {
        return this.createEntitySourceForProjectLibrary(externalSource, null, null);
    }

    @Override
    @Nullable
    public EntitySource createEntitySourceForProjectSettings() {
        EntitySource entitySource;
        if (this.project.isDefault()) {
            return null;
        }
        JpsProjectConfigLocation configLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation(this.project);
        if (configLocation instanceof JpsProjectConfigLocation.FileBased) {
            entitySource = (EntitySource)new JpsProjectFileEntitySource.ExactFile(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile(), configLocation);
        } else if (configLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            VirtualFileUrl miscFile = ((JpsProjectConfigLocation.DirectoryBased)configLocation).getIdeaFolder().append("misc.xml");
            Intrinsics.checkNotNull((Object)miscFile);
            entitySource = (EntitySource)new JpsProjectFileEntitySource.ExactFile(miscFile, configLocation);
        } else {
            entitySource = (EntitySource)DummyParentEntitySourceForProjectSettings.INSTANCE;
        }
        return entitySource;
    }

    private final JpsFileEntitySource createInternalEntitySourceForProjectLibrary(Project project) {
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation(project);
        if (jpsProjectConfigLocation == null) {
            return null;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        return JpsEntitySourceFactory.INSTANCE.createJpsEntitySourceForProjectLibrary(location);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeJpsEntitySourceFactoryImpl$DummyParentEntitySourceForProjectSettings;", "Lcom/intellij/platform/workspace/storage/DummyParentEntitySource;", "<init>", "()V", "intellij.platform.projectModel.impl"})
    private static final class DummyParentEntitySourceForProjectSettings
    implements DummyParentEntitySource {
        @NotNull
        public static final DummyParentEntitySourceForProjectSettings INSTANCE = new DummyParentEntitySourceForProjectSettings();

        private DummyParentEntitySourceForProjectSettings() {
        }
    }
}

