/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.watcher;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.UtilKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.watcher.JarDirectoryDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u0018J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u0003J\u0011\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014\u00a2\u0006\u0002\u0010\u001fJ\u0011\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010!R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00160\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/FileContainerDescription;", "", "urls", "", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "jarDirectories", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/JarDirectoryDescription;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getUrls", "()Ljava/util/List;", "virtualFilePointersList", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "virtualFilePointerManager", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerManager;", "kotlin.jvm.PlatformType", "cachedFilesList", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "cachedUrlsList", "", "[Ljava/lang/String;", "isJarDirectory", "", "url", "findByUrl", "getList", "()[Ljava/lang/String;", "getFiles", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "cacheVirtualFilePointersData", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nFileContainerDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContainerDescription.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/FileContainerDescription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1915#2,2:123\n1915#2,2:125\n1807#2,3:127\n1586#2:131\n1661#2,3:132\n1#3:130\n*S KotlinDebug\n*F\n+ 1 FileContainerDescription.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/watcher/FileContainerDescription\n*L\n29#1:123,2\n30#1:125,2\n33#1:127,3\n38#1:131\n38#1:132,3\n*E\n"})
public final class FileContainerDescription {
    @NotNull
    private final List<VirtualFileUrl> urls;
    @NotNull
    private final List<JarDirectoryDescription> jarDirectories;
    @NotNull
    private final Set<VirtualFilePointer> virtualFilePointersList;
    private final VirtualFilePointerManager virtualFilePointerManager;
    @NotNull
    private final AtomicReference<Pair<VirtualFile[], Long>> cachedFilesList;
    @Nullable
    private volatile String[] cachedUrlsList;

    public FileContainerDescription(@NotNull List<? extends VirtualFileUrl> urls, @NotNull List<JarDirectoryDescription> jarDirectories) {
        Object it;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter(jarDirectories, (String)"jarDirectories");
        this.urls = urls;
        this.jarDirectories = jarDirectories;
        this.virtualFilePointersList = new LinkedHashSet();
        this.virtualFilePointerManager = VirtualFilePointerManager.getInstance();
        this.cachedFilesList = new AtomicReference<Pair>(new Pair((Object)new VirtualFile[0], (Object)-1L));
        Iterable $this$forEach$iv = this.urls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFileUrl)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.pointers.VirtualFilePointer");
            this.virtualFilePointersList.add((VirtualFilePointer)it);
        }
        $this$forEach$iv = this.jarDirectories;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JarDirectoryDescription)element$iv;
            boolean bl = false;
            VirtualFileUrl virtualFileUrl = ((JarDirectoryDescription)it).getDirectoryUrl();
            Intrinsics.checkNotNull((Object)virtualFileUrl, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.pointers.VirtualFilePointer");
            this.virtualFilePointersList.add((VirtualFilePointer)virtualFileUrl);
        }
    }

    @NotNull
    public final List<VirtualFileUrl> getUrls() {
        return this.urls;
    }

    public final boolean isJarDirectory(@NotNull String url) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Iterable $this$any$iv = this.jarDirectories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JarDirectoryDescription it = (JarDirectoryDescription)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getDirectoryUrl().getUrl(), (Object)url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final VirtualFilePointer findByUrl(@NotNull String url) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Iterable iterable = this.virtualFilePointersList;
            for (Object t : iterable) {
                VirtualFilePointer it = (VirtualFilePointer)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<VirtualFilePointer> getList() {
        List<VirtualFilePointer> list = Collections.unmodifiableList(CollectionsKt.toList((Iterable)this.virtualFilePointersList));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getUrls() {
        if (this.cachedUrlsList == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.virtualFilePointersList;
            FileContainerDescription fileContainerDescription = this;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFilePointer virtualFilePointer = (VirtualFilePointer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUrl());
            }
            Collection collection = (List)destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
            fileContainerDescription.cachedUrlsList = (String[])UtilKt.toArray((Collection)collection, (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
        }
        Intrinsics.checkNotNull((Object)this.cachedUrlsList);
        return this.cachedUrlsList;
    }

    @NotNull
    public final VirtualFile[] getFiles() {
        Pair<VirtualFile[], Long> cachedResults = this.cachedFilesList.get();
        return ((Number)cachedResults.getSecond()).longValue() == this.virtualFilePointerManager.getModificationCount() ? (VirtualFile[])cachedResults.getFirst() : this.cacheVirtualFilePointersData();
    }

    private final VirtualFile[] cacheVirtualFilePointersData() {
        long timestampBefore = this.virtualFilePointerManager.getModificationCount();
        List cachedFiles = new ArrayList(this.virtualFilePointersList.size());
        List cachedDirectories = new ArrayList(this.virtualFilePointersList.size() / 3);
        boolean allFilesAreDirs = true;
        for (VirtualFilePointer virtualFilePointer : this.virtualFilePointersList) {
            VirtualFile file;
            if (!virtualFilePointer.isValid() || (file = virtualFilePointer.getFile()) == null) continue;
            cachedFiles.add(file);
            if (file.isDirectory()) {
                cachedDirectories.add(file);
                continue;
            }
            allFilesAreDirs = false;
        }
        for (JarDirectoryDescription jarDirectoryDescription : this.jarDirectories) {
            VirtualFile directoryFile;
            VirtualFileUrl virtualFileUrl = jarDirectoryDescription.getDirectoryUrl();
            Intrinsics.checkNotNull((Object)virtualFileUrl, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.pointers.VirtualFilePointer");
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)virtualFileUrl;
            if (!virtualFilePointer.isValid() || (directoryFile = virtualFilePointer.getFile()) == null) continue;
            cachedDirectories.remove(directoryFile);
            if (jarDirectoryDescription.getRecursive()) {
                VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
                VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively((VirtualFile)directoryFile, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>((List<VirtualFile>)cachedFiles, (List<VirtualFile>)cachedDirectories, optionArray){
                    final /* synthetic */ List<VirtualFile> $cachedFiles;
                    final /* synthetic */ List<VirtualFile> $cachedDirectories;
                    {
                        this.$cachedFiles = $cachedFiles;
                        this.$cachedDirectories = $cachedDirectories;
                        super($super_call_param$1);
                    }

                    public boolean visitFile(VirtualFile file) {
                        VirtualFile jarRoot;
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file.getPath() + "!/")) != null) {
                            this.$cachedFiles.add(jarRoot);
                            this.$cachedDirectories.add(jarRoot);
                            return false;
                        }
                        return true;
                    }
                }));
                Intrinsics.checkNotNull((Object)result);
                continue;
            }
            if (!directoryFile.isValid()) continue;
            VirtualFile[] children = directoryFile.getChildren();
            Intrinsics.checkNotNull((Object)children);
            for (VirtualFileVisitor.Option option : children) {
                VirtualFile jarRoot;
                if (option.isDirectory() || FileTypeRegistry.getInstance().getFileTypeByFileName(option.getNameSequence()) != ArchiveFileType.INSTANCE || (jarRoot = StandardFileSystems.jar().findFileByPath(option.getPath() + "!/")) == null) continue;
                cachedFiles.add(jarRoot);
                cachedDirectories.add(jarRoot);
            }
        }
        VirtualFile[] virtualFileArray = allFilesAreDirs ? VfsUtilCore.toVirtualFileArray((Collection)cachedDirectories) : VfsUtilCore.toVirtualFileArray((Collection)cachedFiles);
        Intrinsics.checkNotNull((Object)virtualFileArray);
        VirtualFile[] files = virtualFileArray;
        long l = this.virtualFilePointerManager.getModificationCount();
        if (timestampBefore == l) {
            this.cachedFilesList.set((Pair<VirtualFile[], Long>)new Pair((Object)files, (Object)l));
        }
        return files;
    }
}

