/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysis;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/AssertProblemsViewCountCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nAssertProblemsViewCountCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertProblemsViewCountCommand.kt\ncom/jetbrains/performancePlugin/commands/AssertProblemsViewCountCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,37:1\n13#2:38\n*S KotlinDebug\n*F\n+ 1 AssertProblemsViewCountCommand.kt\ncom/jetbrains/performancePlugin/commands/AssertProblemsViewCountCommand\n*L\n14#1:38\n*E\n"})
public final class AssertProblemsViewCountCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%assertProblemsViewCount";
    @NotNull
    private static final Logger LOG;

    public AssertProblemsViewCountCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        boolean bl;
        String string = this.extractCommandArgument("assertProblemsViewCount");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(...)");
        String[] stringArray = new String[]{" "};
        int expectedNumberOfErrors = Integer.parseInt((String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1));
        Intrinsics.checkNotNull((Object)ProblemsView.getSelectedPanel((Project)context.getProject()));
        Editor editor = FileEditorManager.getInstance((Project)context.getProject()).getSelectedTextEditor();
        ProblemsViewPanel problemsViewPanel = ProblemsView.getSelectedPanel((Project)context.getProject());
        Intrinsics.checkNotNull((Object)problemsViewPanel);
        Root root = problemsViewPanel.getTreeModel().getRoot();
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        VirtualFile virtualFile = editor2.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        Collection actualProblems = root.getFileProblems(virtualFile);
        boolean bl2 = bl = expectedNumberOfErrors == actualProblems.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Expected number of errors " + expectedNumberOfErrors + ", actual " + actualProblems.size() + "\nList of problems:\n" + actualProblems;
            throw new AssertionError((Object)string2);
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    protected String getName() {
        return "assertProblemsViewCount";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WaitForFinishedCodeAnalysis.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/performancePlugin/commands/AssertProblemsViewCountCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

