/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.jetbrains.performancePlugin.commands.CodeAnalysisStateListener;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysisKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000e\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J0\u0010\u000f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J,\u0010\u0014\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "daemonStarting", "", "fileEditors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "daemonCanceled", "reason", "", "daemonFinished", "daemonFinishedOrCancelled", "isCancelled", "", "traceId", "Ljava/util/UUID;", "printFileEditors", "status", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nWaitForFinishedCodeAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,537:1\n30#2,2:538\n30#2,2:540\n1586#3:542\n1661#3,3:543\n1300#3,2:546\n1315#3,4:548\n*S KotlinDebug\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n*L\n432#1:538,2\n464#1:540,2\n469#1:542\n469#1:543,3\n456#1:546,2\n456#1:548,4\n*E\n"})
public final class WaitForFinishedCodeAnalysisListener
implements DaemonCodeAnalyzer.DaemonListener {
    @NotNull
    private final Project project;

    public WaitForFinishedCodeAnalysisListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!ApplicationManagerEx.isInIntegrationTest()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        CodeAnalysisStateListener.Companion.getLOG().info("Daemon starting with " + fileEditors.size() + " unfiltered editors: " + CollectionsKt.joinToString$default((Iterable)fileEditors, (CharSequence)"\n", null, null, (int)0, null, WaitForFinishedCodeAnalysisListener::daemonStarting$lambda$0, (int)30, null));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CodeAnalysisStateListener> serviceClass$iv = CodeAnalysisStateListener.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((CodeAnalysisStateListener)object).registerDaemonStarted(WaitForFinishedCodeAnalysisKt.access$getWorthy(fileEditors));
    }

    public void daemonCanceled(@NotNull String reason, @NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        UUID traceId = UUID.randomUUID();
        CodeAnalysisStateListener.Companion.getLOG().info("Daemon canceled by the reason of '" + reason + "', traceId = " + traceId);
        Intrinsics.checkNotNull((Object)traceId);
        this.daemonFinishedOrCancelled(fileEditors, true, traceId, reason);
    }

    public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        UUID traceId = UUID.randomUUID();
        CodeAnalysisStateListener.Companion.getLOG().info("Daemon finished, traceId = " + traceId);
        Intrinsics.checkNotNull((Object)traceId);
        WaitForFinishedCodeAnalysisListener.daemonFinishedOrCancelled$default(this, fileEditors, false, traceId, null, 8, null);
    }

    private final void daemonFinishedOrCancelled(Collection<? extends FileEditor> fileEditors, boolean isCancelled, UUID traceId, String reason) {
        String status = isCancelled ? "cancelled" : "stopped";
        this.printFileEditors(fileEditors, status, traceId, reason);
        List worthy = WaitForFinishedCodeAnalysisKt.access$getWorthy(fileEditors);
        if (worthy.isEmpty()) {
            return;
        }
        Map highlightedEditors = (Map)ActionsKt.runReadAction(() -> WaitForFinishedCodeAnalysisListener.daemonFinishedOrCancelled$lambda$0(this, worthy, isCancelled));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CodeAnalysisStateListener> serviceClass$iv = CodeAnalysisStateListener.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((CodeAnalysisStateListener)object).registerDaemonFinishedOrCancelled$intellij_performanceTesting(highlightedEditors, status, traceId);
    }

    static /* synthetic */ void daemonFinishedOrCancelled$default(WaitForFinishedCodeAnalysisListener waitForFinishedCodeAnalysisListener, Collection collection, boolean bl, UUID uUID, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = "";
        }
        waitForFinishedCodeAnalysisListener.daemonFinishedOrCancelled(collection, bl, uUID, string);
    }

    /*
     * WARNING - void declaration
     */
    public final void printFileEditors(@NotNull Collection<? extends FileEditor> fileEditors, @NotNull String status, @NotNull UUID traceId, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = fileEditors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void fileEditor;
                FileEditor fileEditor2 = (FileEditor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)fileEditor));
            }
            String editorsMessage = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            CodeAnalysisStateListener.Companion.getLOG().info("Daemon analyzer was " + status + ", editors size = " + fileEditors.size() + ", reason = " + reason + " ,traceId = " + traceId + ", editorsMessage = " + editorsMessage);
        }
        catch (Exception e) {
            CodeAnalysisStateListener.Companion.getLOG().warn((Throwable)e);
        }
    }

    private static final CharSequence daemonStarting$lambda$0(FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return WaitForFinishedCodeAnalysisKt.access$getDescription(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map daemonFinishedOrCancelled$lambda$0(WaitForFinishedCodeAnalysisListener this$0, List $worthy, boolean $isCancelled) {
        void $this$associateWithTo$iv$iv;
        boolean isFinishedInDumbMode = DumbService.Companion.isDumb(this$0.project);
        Iterable $this$associateWith$iv = $worthy;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            TextEditor textEditor = (TextEditor)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            CodeAnalysisStateListener.HighlightedEditor highlightedEditor = CodeAnalysisStateListener.HighlightedEditor.Companion.create((TextEditor)it, this$0.project, $isCancelled, isFinishedInDumbMode);
            map.put(t, highlightedEditor);
        }
        return destination$iv$iv;
    }
}

