/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.highlighting.JpaLineMarkerActionsKt;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.jpa.model.common.persistence.mapping.Entity;
import com.intellij.jpa.util.OrmDbElementsUtilKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.text.NameUtilCore;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J'\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jpa/highlighting/OpenInDatabaseViewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "classPointer", "Lcom/intellij/uast/UastSmartPointer;", "Lorg/jetbrains/uast/UDeclaration;", "<init>", "(Lcom/intellij/uast/UastSmartPointer;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getPsiClass", "Lcom/intellij/psi/PsiClass;", "getDbColumn", "Lcom/intellij/database/psi/DbColumn;", "entityClass", "roles", "", "Lcom/intellij/persistence/roles/PersistenceClassRole;", "(Lcom/intellij/psi/PsiClass;[Lcom/intellij/persistence/roles/PersistenceClassRole;)Lcom/intellij/database/psi/DbColumn;", "findTableCandidates", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/ResolveResult;", "psiClass", "suggestTableAndSchema", "Lcom/intellij/jpa/highlighting/OpenInDatabaseViewAction$TableCandidateInfo;", "entity", "Lcom/intellij/jpa/model/common/persistence/mapping/Entity;", "TableCandidateInfo", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nJpaLineMarkerActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaLineMarkerActions.kt\ncom/intellij/jpa/highlighting/OpenInDatabaseViewAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n18#2:248\n66#3,2:249\n1401#4,2:251\n13225#4,2:253\n296#5,2:255\n296#5,2:257\n777#5:259\n873#5,2:260\n*S KotlinDebug\n*F\n+ 1 JpaLineMarkerActions.kt\ncom/intellij/jpa/highlighting/OpenInDatabaseViewAction\n*L\n86#1:248\n103#1:249,2\n110#1:251,2\n112#1:253,2\n115#1:255,2\n124#1:257,2\n149#1:259\n149#1:260,2\n*E\n"})
public final class OpenInDatabaseViewAction
extends AnAction {
    @NotNull
    private final UastSmartPointer<? extends UDeclaration> classPointer;

    public OpenInDatabaseViewAction(@NotNull UastSmartPointer<? extends UDeclaration> classPointer) {
        Intrinsics.checkNotNullParameter(classPointer, (String)"classPointer");
        super(OpenInDatabaseViewAction::_init_$lambda$0, DatabaseIcons.Table);
        this.classPointer = classPointer;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            void psiClass2;
            PsiClass psiClass3 = psiClass;
            Presentation presentation2 = presentation;
            boolean bl2 = false;
            PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass2);
            Intrinsics.checkNotNullExpressionValue((Object)persistenceClassRoleArray, (String)"getPersistenceRoles(...)");
            PersistenceClassRole[] roles = persistenceClassRoleArray;
            boolean bl3 = !(roles.length == 0) && (this.classPointer.getElement() instanceof UClass && SequenceFun.isNotEmpty(this.findTableCandidates((PsiClass)psiClass2)) || this.getDbColumn((PsiClass)psiClass2, roles) != null);
            presentation = presentation2;
            bl = bl3;
        } else {
            bl = false;
        }
        presentation.setEnabledAndVisible(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        block3: {
            PsiClass psiClass;
            block2: {
                Navigatable navigatable;
                void $this$asSafely$iv;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PsiClass psiClass2 = this.getPsiClass();
                if (psiClass2 == null) {
                    return;
                }
                psiClass = psiClass2;
                if (!(this.classPointer.getElement() instanceof UClass)) break block2;
                ResolveResult resolveResult = (ResolveResult)SequencesKt.firstOrNull(this.findTableCandidates(psiClass));
                resolveResult = resolveResult != null && (psiElement = resolveResult.getElement()) != null ? psiElement.getNavigationElement() : null;
                boolean $i$f$asSafely = false;
                Object v1 = $this$asSafely$iv;
                if (!(v1 instanceof Navigatable)) {
                    v1 = null;
                }
                if ((navigatable = (Navigatable)v1) == null) break block3;
                navigatable.navigate(true);
                break block3;
            }
            PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
            Intrinsics.checkNotNullExpressionValue((Object)persistenceClassRoleArray, (String)"getPersistenceRoles(...)");
            DbColumn dbColumn = this.getDbColumn(psiClass, persistenceClassRoleArray);
            if (dbColumn == null) break block3;
            DbColumn it = dbColumn;
            boolean bl = false;
            DbNavigationUtils.navigateToDatabaseView((DbElement)((DbElement)it), (boolean)true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiClass getPsiClass() {
        UDeclaration uElement = (UDeclaration)this.classPointer.getElement();
        if (uElement instanceof UClass) {
            return ((UClass)uElement).getJavaPsi();
        }
        UDeclaration uDeclaration = uElement;
        if (uDeclaration != null) {
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)uDeclaration;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiClass.class, (boolean)true);
            uDeclaration = psiClass;
            if (psiClass != null) return uDeclaration;
        }
        UDeclaration uDeclaration2 = uElement;
        UDeclaration uDeclaration3 = uDeclaration2;
        if (uDeclaration2 == null) return null;
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)uDeclaration3;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        UClass uClass = (UClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, UClass.class, (boolean)true);
        uDeclaration3 = uClass;
        if (uClass == null) return null;
        uDeclaration = uDeclaration3.getJavaPsi();
        return uDeclaration;
    }

    /*
     * Unable to fully structure code
     */
    private final DbColumn getDbColumn(PsiClass entityClass, PersistenceClassRole[] roles) {
        block21: {
            block22: {
                block20: {
                    block19: {
                        v0 = (UDeclaration)this.classPointer.getElement();
                        if (v0 == null) {
                            return null;
                        }
                        uElement = v0;
                        if (uElement instanceof UClass) {
                            return null;
                        }
                        sourceElement = null;
                        sourceElement = uElement.getSourcePsi();
                        if (uElement instanceof UParameter) {
                            block18: {
                                v1 = SUastUtils.getContainingClass((PsiElement)sourceElement);
                                if (v1 != null && (v1 = v1.getFields()) != null) {
                                    $this$firstOrNull$iv = v1;
                                    $i$f$firstOrNull = 0;
                                    var10_13 = $this$firstOrNull$iv.length;
                                    for (var9_11 = 0; var9_11 < var10_13; ++var9_11) {
                                        it = element$iv = $this$firstOrNull$iv[var9_11];
                                        $i$a$-firstOrNull-OpenInDatabaseViewAction$getDbColumn$1 = false;
                                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)((UParameter)uElement).getName())) continue;
                                        v2 = element$iv;
                                        break block18;
                                    }
                                    v2 = null;
                                } else {
                                    v2 = null;
                                }
                            }
                            sourceElement = v2;
                        }
                        ormSearcher = OrmSearcher.Companion.getForFramework((OrmFramework)JpaOrmFramework.INSTANCE);
                        $this$any$iv = roles;
                        $i$f$any = false;
                        var9_11 = $this$any$iv.length;
                        for ($i$f$firstOrNull = 0; $i$f$firstOrNull < var9_11; ++$i$f$firstOrNull) {
                            it = element$iv = $this$any$iv[$i$f$firstOrNull];
                            $i$a$-any-OpenInDatabaseViewAction$getDbColumn$2 = false;
                            if (!(it.getType() == PersistenceClassRoleEnum.EMBEDDABLE)) continue;
                            v3 = true;
                            break block19;
                        }
                        v3 = false;
                    }
                    if (!v3) break block22;
                    v4 = ormSearcher.findOrCreateEmbeddedEntity(entityClass);
                    if (v4 == null) {
                        return null;
                    }
                    embeddableEntity = v4;
                    v5 = (Map.Entry)CollectionsKt.firstOrNull((Iterable)ormSearcher.findEmbeddedEntityOwner(embeddableEntity).entrySet());
                    if (v5 == null) {
                        return null;
                    }
                    embeddedOwner = v5;
                    $this$firstOrNull$iv = embeddableEntity.getAttributes();
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        block24: {
                            block23: {
                                it = (OrmEntityAttribute)element$iv;
                                $i$a$-firstOrNull-OpenInDatabaseViewAction$getDbColumn$ormAttribute$1 = false;
                                if (it.isValid()) break block23;
                                v6 = false;
                                break block24;
                            }
                            attrElement = it.getNavigationElement();
                            if (Intrinsics.areEqual((Object)sourceElement, (Object)attrElement)) ** GOTO lbl-1000
                            v7 = UastContextKt.toUElement((PsiElement)attrElement);
                            if (Intrinsics.areEqual((Object)sourceElement, (Object)(v7 != null ? v7.getSourcePsi() : null))) lbl-1000:
                            // 2 sources

                            {
                                v6 = true;
                            } else {
                                v6 = false;
                            }
                        }
                        if (!v6) continue;
                        v8 = element$iv;
                        break block20;
                    }
                    v8 = null;
                }
                v9 = v8;
                if (v9 == null) {
                    return null;
                }
                ormAttribute = v9;
                return OrmDbElementsUtilKt.getDbColumn((OrmEntity)embeddedOwner.getKey(), ormAttribute, embeddableEntity, ((OrmEntityAttribute)embeddedOwner.getValue()).getName());
            }
            v10 = ormSearcher.findEntityForClass(entityClass);
            if (v10 == null) {
                return null;
            }
            ormEntity = v10;
            $this$firstOrNull$iv = ormEntity.getAttributes();
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block26: {
                    block25: {
                        it = (OrmEntityAttribute)element$iv;
                        $i$a$-firstOrNull-OpenInDatabaseViewAction$getDbColumn$ormAttribute$2 = false;
                        if (it.isValid()) break block25;
                        v11 = false;
                        break block26;
                    }
                    attrElement = it.getNavigationElement();
                    if (Intrinsics.areEqual((Object)sourceElement, (Object)attrElement)) ** GOTO lbl-1000
                    v12 = UastContextKt.toUElement((PsiElement)attrElement);
                    if (Intrinsics.areEqual((Object)sourceElement, (Object)(v12 != null ? v12.getSourcePsi() : null))) lbl-1000:
                    // 2 sources

                    {
                        v11 = true;
                    } else {
                        v11 = false;
                    }
                }
                if (!v11) continue;
                v13 = element$iv;
                break block21;
            }
            v13 = null;
        }
        v14 = v13;
        if (v14 == null) {
            return null;
        }
        ormAttribute = v14;
        return OrmDbElementsUtilKt.getDbColumn$default(ormEntity, ormAttribute, null, null, 12, null);
    }

    private final Sequence<ResolveResult> findTableCandidates(PsiClass psiClass) {
        PersistenceClassRole persistenceClassRole = JpaLineMarkerActionsKt.findPersistenceRole(psiClass, PersistenceClassRoleEnum.ENTITY);
        Object object = persistenceClassRole != null ? persistenceClassRole.getPersistentObject() : null;
        Entity entity = object instanceof Entity ? (Entity)object : null;
        TableCandidateInfo tableCandidateInfo = this.suggestTableAndSchema(psiClass, entity);
        if (tableCandidateInfo.getTableNameCandidates().isEmpty()) {
            return SequencesKt.emptySequence();
        }
        Collection<DbTable> collection = ORMReferencesUtil.getTableVariants(ORMReferencesUtil.getDataSources(psiClass), tableCandidateInfo.getSchemaCandidate());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getTableVariants(...)");
        Collection<DbTable> tableVariants = collection;
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)tableCandidateInfo.getTableNameCandidates()), arg_0 -> OpenInDatabaseViewAction.findTableCandidates$lambda$0(tableVariants, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final TableCandidateInfo suggestTableAndSchema(PsiClass psiClass, Entity entity) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String defaultTableName;
        CommonModelElement commonModelElement = entity;
        String string = defaultTableName = commonModelElement != null && (commonModelElement = commonModelElement.getTable()) != null && (commonModelElement = commonModelElement.getTableName()) != null ? commonModelElement.getStringValue() : null;
        String originalClassName = psiClass.getName();
        String string2 = originalClassName;
        if (string2 == null) {
            string2 = "";
        }
        Iterable iterable = NameUtilCore.nameToWordList((String)string2);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0 && Character.isLetterOrDigit(StringsKt.first((CharSequence)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String classNameSnakeCase = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        CommonModelElement commonModelElement2 = entity;
        String schemaName = commonModelElement2 != null && (commonModelElement2 = commonModelElement2.getTable()) != null && (commonModelElement2 = commonModelElement2.getSchema()) != null ? (String)commonModelElement2.getValue() : null;
        Object[] objectArray = new String[]{defaultTableName, originalClassName, classNameSnakeCase};
        return new TableCandidateInfo(SetsKt.setOfNotNull((Object[])objectArray), schemaName);
    }

    private static final String _init_$lambda$0() {
        return JpaMessages.message("action.Jpa.OpenInDatabaseView", new Object[0]);
    }

    private static final Sequence findTableCandidates$lambda$0(Collection $tableVariants, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults($tableVariants, it);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"getDbElementResolveResults(...)");
        return ArraysKt.asSequence((Object[])resolveResultArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jpa/highlighting/OpenInDatabaseViewAction$TableCandidateInfo;", "", "tableNameCandidates", "", "", "schemaCandidate", "<init>", "(Ljava/util/Set;Ljava/lang/String;)V", "getTableNameCandidates", "()Ljava/util/Set;", "getSchemaCandidate", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javaee.jpa.impl"})
    private static final class TableCandidateInfo {
        @NotNull
        private final Set<String> tableNameCandidates;
        @Nullable
        private final String schemaCandidate;

        public TableCandidateInfo(@NotNull Set<String> tableNameCandidates, @Nullable String schemaCandidate) {
            Intrinsics.checkNotNullParameter(tableNameCandidates, (String)"tableNameCandidates");
            this.tableNameCandidates = tableNameCandidates;
            this.schemaCandidate = schemaCandidate;
        }

        @NotNull
        public final Set<String> getTableNameCandidates() {
            return this.tableNameCandidates;
        }

        @Nullable
        public final String getSchemaCandidate() {
            return this.schemaCandidate;
        }

        @NotNull
        public final Set<String> component1() {
            return this.tableNameCandidates;
        }

        @Nullable
        public final String component2() {
            return this.schemaCandidate;
        }

        @NotNull
        public final TableCandidateInfo copy(@NotNull Set<String> tableNameCandidates, @Nullable String schemaCandidate) {
            Intrinsics.checkNotNullParameter(tableNameCandidates, (String)"tableNameCandidates");
            return new TableCandidateInfo(tableNameCandidates, schemaCandidate);
        }

        public static /* synthetic */ TableCandidateInfo copy$default(TableCandidateInfo tableCandidateInfo, Set set, String string, int n, Object object) {
            if ((n & 1) != 0) {
                set = tableCandidateInfo.tableNameCandidates;
            }
            if ((n & 2) != 0) {
                string = tableCandidateInfo.schemaCandidate;
            }
            return tableCandidateInfo.copy(set, string);
        }

        @NotNull
        public String toString() {
            return "TableCandidateInfo(tableNameCandidates=" + this.tableNameCandidates + ", schemaCandidate=" + this.schemaCandidate + ")";
        }

        public int hashCode() {
            int result = ((Object)this.tableNameCandidates).hashCode();
            result = result * 31 + (this.schemaCandidate == null ? 0 : this.schemaCandidate.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TableCandidateInfo)) {
                return false;
            }
            TableCandidateInfo tableCandidateInfo = (TableCandidateInfo)other;
            if (!Intrinsics.areEqual(this.tableNameCandidates, tableCandidateInfo.tableNameCandidates)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.schemaCandidate, (Object)tableCandidateInfo.schemaCandidate);
        }
    }
}

