/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiShortNamesCache {
    public static final ExtensionPointName<PsiShortNamesCache> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.shortNamesCache");

    public static PsiShortNamesCache getInstance(Project project) {
        return (PsiShortNamesCache)project.getService(PsiShortNamesCache.class);
    }

    public PsiFile @NotNull [] getFilesByName(@NotNull String name) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(0);
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            PsiShortNamesCache.$$$reportNull$$$0(1);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    public String @NotNull [] getAllFileNames() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            PsiShortNamesCache.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public abstract @NotNull PsiClass @NotNull [] getClassesByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract @NotNull String @NotNull [] getAllClassNames();

    public boolean processAllClassNames(@NotNull Processor<? super String> processor) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(3);
        }
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(5);
        }
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    @NotNull
    public abstract @NotNull PsiMethod @NotNull [] getMethodsByName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract @NotNull PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    @NotNull
    public abstract @NotNull PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    public abstract boolean processMethodsWithName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<? super PsiMethod> var3);

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(8);
        }
        return this.processMethodsWithName(name, scope, processor);
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(10);
        }
        return ContainerUtil.process((Object[])this.getAllMethodNames(), processor);
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(12);
        }
        return ContainerUtil.process((Object[])this.getAllFieldNames(), processor);
    }

    @NotNull
    public abstract @NotNull String @NotNull [] getAllMethodNames();

    @NotNull
    public abstract @NotNull PsiField @NotNull [] getFieldsByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract @NotNull String @NotNull [] getAllFieldNames();

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(15);
        }
        return ContainerUtil.process((Object[])this.getFieldsByName(name, scope), processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(18);
        }
        return ContainerUtil.process((Object[])this.getClassesByName(name, scope), processor);
    }

    @ApiStatus.Internal
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            PsiShortNamesCache.$$$reportNull$$$0(19);
        }
        return language;
    }

    @ApiStatus.Internal
    @NotNull
    public PsiShortNamesCache withoutLanguages(Set<Language> languages) {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    @NotNull
    public PsiShortNamesCache withoutLanguages(Language ... languages) {
        PsiShortNamesCache psiShortNamesCache = this.withoutLanguages(Set.of(languages));
        if (psiShortNamesCache == null) {
            PsiShortNamesCache.$$$reportNull$$$0(20);
        }
        return psiShortNamesCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PsiShortNamesCache";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PsiShortNamesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 1: 
            case 2: 
            case 19: 
            case 20: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAllClassNames";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllMethodNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAllFieldNames";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 19, 20 -> new IllegalStateException(string);
        };
    }
}

