/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.db;

import com.intellij.clouds.kubernetes.db.KubernetesDBPortForwardingConfig;
import com.intellij.clouds.kubernetes.db.KubernetesPortForwardingDataSourceOptionProvider;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.kubernetes.database.DatabaseCredentials;
import com.intellij.kubernetes.database.KubernetesDatabaseIntegration;
import com.intellij.kubernetes.database.KubernetesDatabaseTypes;
import com.intellij.kubernetes.database.KubernetesPortForwardingDataSourceConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDatabaseIntegrationImpl;", "Lcom/intellij/kubernetes/database/KubernetesDatabaseIntegration;", "<init>", "()V", "isDatabaseImage", "", "image", "", "createDatabaseDataSource", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSourceConfig", "Lcom/intellij/kubernetes/database/KubernetesPortForwardingDataSourceConfig;", "generateUniqueName", "baseName", "existingNames", "", "intellij.clouds.kubernetes.db"})
@SourceDebugExtension(value={"SMAP\nKubernetesPortForwardingDatabaseIntegrationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPortForwardingDatabaseIntegrationImpl.kt\ncom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDatabaseIntegrationImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1642#2,10:94\n1915#2:104\n1916#2:106\n1652#2:107\n1#3:105\n1#3:108\n*S KotlinDebug\n*F\n+ 1 KubernetesPortForwardingDatabaseIntegrationImpl.kt\ncom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDatabaseIntegrationImpl\n*L\n45#1:94,10\n45#1:104\n45#1:106\n45#1:107\n45#1:105\n*E\n"})
public final class KubernetesPortForwardingDatabaseIntegrationImpl
implements KubernetesDatabaseIntegration {
    public boolean isDatabaseImage(@Nullable String image) {
        return KubernetesDatabaseTypes.INSTANCE.isDatabaseImage(image);
    }

    /*
     * WARNING - void declaration
     */
    public void createDatabaseDataSource(@NotNull Project project, @NotNull KubernetesPortForwardingDataSourceConfig dataSourceConfig) {
        com.intellij.database.access.DatabaseCredentials databaseCredentials;
        void $this$mapNotNullTo$iv$iv;
        Object v4;
        DbPsiFacade dbPsiFacade;
        block11: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSourceConfig, (String)"dataSourceConfig");
            DbPsiFacade dbPsiFacade2 = DbPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade2, (String)"getInstance(...)");
            dbPsiFacade = dbPsiFacade2;
            List list = dbPsiFacade.getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource ds = (DbDataSource)t;
                boolean bl = false;
                LocalDataSource localDs = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)((DasDataSource)ds));
                Object object = localDs;
                boolean bl2 = object != null && (object = object.getUrl()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)(dataSourceConfig.getAddress() + ":" + dataSourceConfig.getLocalPort()), (boolean)false, (int)2, null) : false;
                if (!bl2) continue;
                v4 = t;
                break block11;
            }
            v4 = null;
        }
        DbDataSource existingDataSource = v4;
        if (existingDataSource != null) {
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Database");
            if (toolWindow != null) {
                toolWindow.show();
            }
            DatabaseEditorHelper.openConsoleFile((DbElement)((DbElement)existingDataSource));
            DatabaseView.select((Project)project, (Collection)CollectionsKt.listOf((Object)existingDataSource), (boolean)true);
            ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(project).getToolWindow("Services");
            if (toolWindow2 != null) {
                toolWindow2.show();
            }
            return;
        }
        LocalDataSource dataSource = new LocalDataSource();
        String baseName = dataSourceConfig.getResourceName() + " " + dataSourceConfig.getDatabaseType().getDriverName();
        List list = dbPsiFacade.getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            DbDataSource it = (DbDataSource)element$iv$iv;
            boolean bl4 = false;
            if (it.getName() == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List existingNames = (List)destination$iv$iv;
        dataSource.setName(this.generateUniqueName(baseName, existingNames));
        dataSource.setUrl((String)dataSourceConfig.getDatabaseType().getUrlTemplate().invoke((Object)dataSourceConfig.getAddress(), (Object)dataSourceConfig.getLocalPort()));
        DatabaseDriver dbDriver = DatabaseDriverManager.getInstance().getDriver(dataSourceConfig.getDatabaseType().getDriverId());
        if (dbDriver != null) {
            dataSource.setDatabaseDriver(dbDriver);
        }
        KubernetesDBPortForwardingConfig optionProviderConfig = new KubernetesDBPortForwardingConfig(true, dataSourceConfig.getContextName(), dataSourceConfig.getNamespace(), dataSourceConfig.getResourceType(), dataSourceConfig.getResourceName(), String.valueOf(dataSourceConfig.getLocalPort()), String.valueOf(dataSourceConfig.getContainerPort()));
        new KubernetesPortForwardingDataSourceOptionProvider().store(dataSource, optionProviderConfig);
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Database");
        if (toolWindow != null) {
            toolWindow.show();
        }
        DbPsiFacade dbPsiFacade3 = dbPsiFacade;
        LocalDataSource localDataSource = dataSource;
        DatabaseCredentials databaseCredentials2 = dataSourceConfig.getCredentials();
        if (databaseCredentials2 != null) {
            void credentials;
            DatabaseCredentials $i$f$mapNotNullTo2 = databaseCredentials2;
            LocalDataSource localDataSource2 = localDataSource;
            DbPsiFacade dbPsiFacade4 = dbPsiFacade3;
            boolean bl6 = false;
            com.intellij.database.access.DatabaseCredentials databaseCredentials3 = DatabaseCredentialsUi.newUIInstance();
            String string = credentials.getUsername();
            if (string != null) {
                String it = string;
                boolean bl7 = false;
                dataSource.setUsername(it);
            }
            String string2 = credentials.getPassword();
            if (string2 != null) {
                String password = string2;
                boolean bl8 = false;
                OneTimeString oneTimePassword = new OneTimeString(password);
                databaseCredentials3.storePassword((DatabaseConnectionConfig)dataSource, oneTimePassword);
            }
            com.intellij.database.access.DatabaseCredentials databaseCredentials4 = databaseCredentials3;
            dbPsiFacade3 = dbPsiFacade4;
            localDataSource = localDataSource2;
            databaseCredentials = databaseCredentials4;
        } else {
            databaseCredentials = null;
        }
        DataSourceManagerDialog.showDialog((DbPsiFacade)dbPsiFacade3, (Object)localDataSource, databaseCredentials);
    }

    private final String generateUniqueName(String baseName, List<String> existingNames) {
        if (!existingNames.contains(baseName)) {
            return baseName;
        }
        int counter = 1;
        while (existingNames.contains(baseName + " [" + counter + "]")) {
            ++counter;
        }
        return baseName + " [" + counter + "]";
    }
}

