/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0096\u0080\u0004J\n\u0010\u0016\u001a\u00020\fH\u0096\u0080\u0004J\u0017\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0018\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0096\u0080\bJ\u0013\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\n\u0010 \u001a\u00020\u001eH\u0096\u0080\u0004J\u001d\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\"J\r\u0010$\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010%J\u001a\u0010'\u001a\u00020\f2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0)J\u0010\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0096\u0082\u0004J\u0018\u0010,\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0096\u0080\bJ\u0018\u0010-\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0096\u0080\bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\tj\b\u0012\u0004\u0012\u00028\u0000`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006."}, d2={"Lfleet/util/PriorityQueue;", "T", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Ljava/util/Comparator;)V", "heap", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "size", "", "getSize", "()I", "isEmpty", "add", "addAll", "indexOf", "elem", "(Ljava/lang/Object;)I", "remove", "removeAt", "", "index", "clear", "siftUp", "(ILjava/lang/Object;)V", "siftDown", "poll", "()Ljava/lang/Object;", "peek", "removeIf", "pred", "Lkotlin/Function1;", "iterator", "", "retainAll", "removeAll", "fleet.util.core"})
public final class PriorityQueue<T>
implements Collection<T>,
KMutableCollection {
    @NotNull
    private final Comparator<T> comparator;
    @NotNull
    private final ArrayList<T> heap;

    public PriorityQueue(@NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.comparator = comparator;
        this.heap = new ArrayList();
    }

    @Override
    public boolean contains(Object element) {
        return this.heap.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.heap.containsAll(elements);
    }

    public int getSize() {
        return this.heap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public boolean add(T element) {
        this.heap.add(element);
        this.siftUp(this.size() - 1, element);
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (T element : elements) {
            this.add(element);
        }
        return true;
    }

    public final int indexOf(T elem) {
        return this.heap.indexOf(elem);
    }

    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    private final void removeAt(int index) {
        if (!(0 <= index ? index < ((Collection)this).size() : false)) {
            throw new IndexOutOfBoundsException();
        }
        int s = this.size() - 1;
        if (s == index) {
            this.heap.removeLast();
            return;
        }
        T moved = this.heap.get(s);
        this.heap.removeLast();
        this.siftDown(index, moved);
        if (Intrinsics.areEqual(this.heap.get(index), moved)) {
            this.siftUp(index, moved);
            if (!Intrinsics.areEqual(this.heap.get(index), moved)) {
                return;
            }
        }
    }

    @Override
    public void clear() {
        this.heap.clear();
    }

    private final void siftUp(int index, T elem) {
        int parent;
        T parentElem;
        int i = index;
        while (i > 0 && this.comparator.compare(elem, parentElem = this.heap.get(parent = (i - 1) / 2)) < 0) {
            this.heap.set(i, parentElem);
            i = parent;
        }
        this.heap.set(i, elem);
    }

    private final void siftDown(int index, T elem) {
        int k = index;
        int half = this.size() / 2;
        while (k < half) {
            int left = 2 * k + 1;
            T oldElem = this.heap.get(left);
            int right = left + 1;
            if (right < this.size() && this.comparator.compare(oldElem, this.heap.get(right)) > 0) {
                oldElem = this.heap.get(right);
                left = right;
            }
            if (this.comparator.compare(elem, oldElem) <= 0) break;
            this.heap.set(k, oldElem);
            k = left;
        }
        this.heap.set(k, elem);
    }

    @Nullable
    public final T poll() {
        if (this.isEmpty()) {
            return null;
        }
        T res2 = this.peek();
        this.removeAt(0);
        return res2;
    }

    @Nullable
    public final T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.heap.get(0);
    }

    public final boolean removeIf(@NotNull Function1<? super T, Boolean> pred) {
        Object elem;
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        boolean removedElement = false;
        ArrayList<T> toBeRemoved = new ArrayList<T>();
        Iterator<T> iterator2 = this.heap.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            elem = iterator3.next();
            if (!((Boolean)pred.invoke(elem)).booleanValue()) continue;
            removedElement = true;
            toBeRemoved.add(elem);
        }
        Iterator iterator4 = toBeRemoved.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            elem = iterator3.next();
            this.remove(elem);
        }
        return removedElement;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator2 = this.heap.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.removeIf((Function1)new Function1<T, Boolean>(elements){
            final /* synthetic */ Collection<T> $elements;
            {
                this.$elements = $elements;
                super(1);
            }

            public final Boolean invoke(T elem) {
                return !this.$elements.contains(elem);
            }
        });
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.removeIf((Function1)new Function1<T, Boolean>(elements){
            final /* synthetic */ Collection<T> $elements;
            {
                this.$elements = $elements;
                super(1);
            }

            public final Boolean invoke(T elem) {
                return this.$elements.contains(elem);
            }
        });
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

