/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding;

import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import java.net.InetSocketAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0015\u001a\u00020\u0007H\u0096\u0080\u0004J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortBinding;", "", "port", "", "type", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "networkInterface", "", "bindings", "", "Ljava/net/InetSocketAddress;", "<init>", "(ILcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;Ljava/lang/String;Ljava/util/List;)V", "getPort", "()I", "getType", "()Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "getNetworkInterface", "()Ljava/lang/String;", "getBindings", "()Ljava/util/List;", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "intellij.platform.split"})
public final class PortBinding {
    private final int port;
    @NotNull
    private final PortType type;
    @NotNull
    private final String networkInterface;
    @NotNull
    private final List<InetSocketAddress> bindings;

    public PortBinding(int port, @NotNull PortType type, @NotNull String networkInterface, @NotNull List<? extends InetSocketAddress> bindings) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        this.port = port;
        this.type = type;
        this.networkInterface = networkInterface;
        this.bindings = bindings;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final PortType getType() {
        return this.type;
    }

    @NotNull
    public final String getNetworkInterface() {
        return this.networkInterface;
    }

    @NotNull
    public final List<InetSocketAddress> getBindings() {
        return this.bindings;
    }

    @NotNull
    public String toString() {
        String bindings = CollectionsKt.joinToString$default((Iterable)this.bindings, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, arg_0 -> PortBinding.toString$lambda$0(this, arg_0), (int)24, null);
        return "Bindings for port <" + this.port + ">: " + bindings;
    }

    public final int component1() {
        return this.port;
    }

    @NotNull
    public final PortType component2() {
        return this.type;
    }

    @NotNull
    public final String component3() {
        return this.networkInterface;
    }

    @NotNull
    public final List<InetSocketAddress> component4() {
        return this.bindings;
    }

    @NotNull
    public final PortBinding copy(int port, @NotNull PortType type, @NotNull String networkInterface, @NotNull List<? extends InetSocketAddress> bindings) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        return new PortBinding(port, type, networkInterface, bindings);
    }

    public static /* synthetic */ PortBinding copy$default(PortBinding portBinding, int n, PortType portType, String string, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = portBinding.port;
        }
        if ((n2 & 2) != 0) {
            portType = portBinding.type;
        }
        if ((n2 & 4) != 0) {
            string = portBinding.networkInterface;
        }
        if ((n2 & 8) != 0) {
            list = portBinding.bindings;
        }
        return portBinding.copy(n, portType, string, list);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.port);
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + this.networkInterface.hashCode();
        result2 = result2 * 31 + ((Object)this.bindings).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PortBinding)) {
            return false;
        }
        PortBinding portBinding = (PortBinding)other;
        if (this.port != portBinding.port) {
            return false;
        }
        if (this.type != portBinding.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.networkInterface, (Object)portBinding.networkInterface)) {
            return false;
        }
        return Intrinsics.areEqual(this.bindings, portBinding.bindings);
    }

    private static final CharSequence toString$lambda$0(PortBinding this$0, InetSocketAddress binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        return binding.getAddress() + ":" + binding.getPort() + " <-> " + this$0.networkInterface + ":" + this$0.port + "/" + this$0.type;
    }
}

