/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;

public final class DaemonTooltipsUtil {
    @NlsSafe
    @NotNull
    public static String getWrappedTooltip(String message, String shortName, boolean showToolDescription) {
        return DaemonTooltipsUtil.getWrappedTooltip(message, shortName, DaemonTooltipsUtil.getShortcutText(), showToolDescription);
    }

    @NlsSafe
    @NotNull
    public static String getWrappedTooltip(String message, String shortName, String shortcutText, boolean showToolDescription) {
        return DaemonTooltipsUtil.getWrappedTooltipWithCustomReference(message, "#inspection/" + shortName, shortcutText, showToolDescription);
    }

    @NlsSafe
    @NotNull
    public static String getWrappedTooltipWithCustomReference(String message, String reference, boolean showToolDescription) {
        return DaemonTooltipsUtil.getWrappedTooltipWithCustomReference(message, reference, DaemonTooltipsUtil.getShortcutText(), showToolDescription);
    }

    @NlsSafe
    @NotNull
    public static String getWrappedTooltipWithCustomReference(String message, String reference, String shortcutText, boolean showToolDescription) {
        Object link = "";
        if (showToolDescription) {
            link = " <a href=\"" + reference + "\"" + (StartupUiUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message("inspection.extended.description", new Object[0]) + "</a> " + shortcutText;
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)((message.startsWith("<html>") ? XmlStringUtil.stripHtml((String)message) : XmlStringUtil.escapeString((String)message)) + (String)link));
        if (string == null) {
            DaemonTooltipsUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getShortcutText() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null) {
            return "";
        }
        String string = "(" + KeymapUtil.getShortcutsText((Shortcut[])keymapManager.getActiveKeymap().getShortcuts("ShowErrorDescription")) + ")";
        if (string == null) {
            DaemonTooltipsUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/daemon/impl/analysis/DaemonTooltipsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappedTooltipWithCustomReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

