/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.util.containers.IntObjectMap;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestIconMapper
implements PoolOfTestIcons {
    private static final IntObjectMap<TestStateInfo.Magnitude> magnitudes = ConcurrentCollectionFactory.createConcurrentIntObjectMap();

    public static TestStateInfo.Magnitude getMagnitude(int value) {
        return (TestStateInfo.Magnitude)((Object)magnitudes.get(value));
    }

    @Nullable
    public static Icon getIcon(@NotNull TestStateInfo.Magnitude magnitude) {
        if (magnitude == null) {
            TestIconMapper.$$$reportNull$$$0(0);
        }
        return switch (magnitude) {
            default -> throw new MatchException(null, null);
            case TestStateInfo.Magnitude.SKIPPED_INDEX -> SKIPPED_ICON;
            case TestStateInfo.Magnitude.COMPLETE_INDEX, TestStateInfo.Magnitude.PASSED_INDEX -> PASSED_ICON;
            case TestStateInfo.Magnitude.NOT_RUN_INDEX -> NOT_RAN;
            case TestStateInfo.Magnitude.RUNNING_INDEX -> null;
            case TestStateInfo.Magnitude.TERMINATED_INDEX -> TERMINATED_ICON;
            case TestStateInfo.Magnitude.IGNORED_INDEX -> IGNORED_ICON;
            case TestStateInfo.Magnitude.FAILED_INDEX -> FAILED_ICON;
            case TestStateInfo.Magnitude.ERROR_INDEX -> ERROR_ICON;
        };
    }

    @Nullable
    public static Icon getToolbarIcon(@NotNull TestStateInfo.Magnitude magnitude, boolean hasErrors, BooleanSupplier hasPassedTest) {
        if (magnitude == null) {
            TestIconMapper.$$$reportNull$$$0(1);
        }
        return switch (magnitude) {
            case TestStateInfo.Magnitude.SKIPPED_INDEX -> AllIcons.RunConfigurations.ToolbarSkipped;
            case TestStateInfo.Magnitude.COMPLETE_INDEX, TestStateInfo.Magnitude.PASSED_INDEX -> AllIcons.RunConfigurations.ToolbarPassed;
            case TestStateInfo.Magnitude.NOT_RUN_INDEX -> AllIcons.RunConfigurations.TestNotRan;
            case TestStateInfo.Magnitude.TERMINATED_INDEX -> AllIcons.RunConfigurations.ToolbarTerminated;
            case TestStateInfo.Magnitude.IGNORED_INDEX -> {
                if (!hasErrors && hasPassedTest.getAsBoolean()) {
                    yield AllIcons.RunConfigurations.ToolbarPassedIgnored;
                }
                yield AllIcons.RunConfigurations.ShowIgnored;
            }
            case TestStateInfo.Magnitude.FAILED_INDEX -> AllIcons.RunConfigurations.ToolbarFailed;
            case TestStateInfo.Magnitude.ERROR_INDEX -> AllIcons.RunConfigurations.ToolbarError;
            default -> null;
        };
    }

    static {
        for (TestStateInfo.Magnitude value : TestStateInfo.Magnitude.values()) {
            magnitudes.put(value.getValue(), (Object)value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "magnitude";
        objectArray2[1] = "com/intellij/execution/testframework/TestIconMapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolbarIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

