/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.BookmarkTypeKt;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.util.ui.RegionPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u00020\u0006H\u0096\u0080\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0082\u0004J:\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/bookmark/MnemonicPainter;", "Lcom/intellij/util/ui/RegionPainter;", "Ljava/awt/Component;", "icon", "Ljavax/swing/Icon;", "mnemonic", "", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;)V", "getIcon", "()Ljavax/swing/Icon;", "getMnemonic", "()Ljava/lang/String;", "toString", "hashCode", "", "equals", "", "other", "", "paint", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "width", "height", "c", "intellij.platform.lang"})
final class MnemonicPainter
implements RegionPainter<Component> {
    @NotNull
    private final Icon icon;
    @NotNull
    private final String mnemonic;

    public MnemonicPainter(@NotNull Icon icon, @NotNull String mnemonic) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
        this.icon = icon;
        this.mnemonic = mnemonic;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final String getMnemonic() {
        return this.mnemonic;
    }

    @NotNull
    public String toString() {
        return "BookmarkMnemonicIcon:" + this.mnemonic;
    }

    public int hashCode() {
        return this.mnemonic.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        MnemonicPainter mnemonicPainter = other instanceof MnemonicPainter ? (MnemonicPainter)other : null;
        if (mnemonicPainter == null) {
            return false;
        }
        MnemonicPainter painter = mnemonicPainter;
        return Intrinsics.areEqual((Object)painter.mnemonic, (Object)this.mnemonic);
    }

    public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, @Nullable Component c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.icon.paintIcon(null, g, x, y);
        Color foreground = EditorColorsUtil.getColor(null, (ColorKey)BookmarkTypeKt.access$getMNEMONIC_ICON_FOREGROUND$p());
        g.setPaint(foreground);
        UISettings.Companion.setupAntialiasing((Graphics)g);
        FontRenderContext frc = g.getFontRenderContext();
        Font font = EditorFontType.PLAIN.getGlobalFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getGlobalFont(...)");
        Font font2 = font;
        float size1 = 0.75f * (float)height;
        GlyphVector vector1 = font2.deriveFont(size1).createGlyphVector(frc, this.mnemonic);
        Rectangle2D bounds1 = vector1.getVisualBounds();
        double dx = (double)x - bounds1.getX() + 0.5 * ((double)width - bounds1.getWidth());
        double dy = (double)y - bounds1.getY() + 0.5 * ((double)height - bounds1.getHeight());
        g.drawGlyphVector(vector1, (float)dx, (float)dy);
    }
}

