/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parameterInfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ParameterInfoUIContext {
    public String setupUIComponentPresentation(String var1, int var2, int var3, boolean var4, boolean var5, boolean var6, Color var7);

    public void setupRawUIComponentPresentation(@NlsContexts.Label String var1);

    @ApiStatus.Internal
    default public void setupSignatureHtmlPresentation(@NotNull @NotNull List<@NotNull ParameterHtmlPresentation> parameters, int currentParameterIndex, @NotNull String separator, boolean isDeprecated) {
        if (parameters == null) {
            ParameterInfoUIContext.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            ParameterInfoUIContext.$$$reportNull$$$0(1);
        }
        @NlsSafe StringBuilder sb = new StringBuilder();
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (isDeprecated) {
            sb.append("<strike>");
        }
        for (int i = 0; i < parameters.size(); ++i) {
            String defaultValue;
            if (i > 0) {
                sb.append(separator).append(" ");
            }
            ParameterHtmlPresentation parameter = parameters.get(i);
            if (isUnitTestMode && parameter.isMismatched()) {
                sb.append("<mismatched>");
            }
            String string = defaultValue = parameter.defaultValue != null ? parameter.defaultValue : "";
            if (i == currentParameterIndex) {
                sb.append("<b>").append(parameter.nameAndType).append(defaultValue).append("</b>");
            } else {
                sb.append(parameter.nameAndType).append(defaultValue);
            }
            if (!isUnitTestMode || !parameter.isMismatched()) continue;
            sb.append("</mismatched>");
        }
        if (isDeprecated) {
            sb.append("</strike>");
        }
        this.setupRawUIComponentPresentation(sb.toString());
    }

    public boolean isUIComponentEnabled();

    public void setUIComponentEnabled(boolean var1);

    default public void setUIComponentVisible(boolean visible) {
    }

    default public boolean isUIComponentVisible() {
        return true;
    }

    public int getCurrentParameterIndex();

    public PsiElement getParameterOwner();

    public boolean isSingleOverload();

    public boolean isSingleParameterInfo();

    public Color getDefaultParameterColor();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "separator";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/parameterInfo/ParameterInfoUIContext";
        objectArray[2] = "setupSignatureHtmlPresentation";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public record ParameterHtmlPresentation(@NotNull String nameAndType, @Nullable String defaultValue, boolean isMismatched) {
        @NotNull
        private final String nameAndType;

        public ParameterHtmlPresentation(@NotNull String nameAndType, @Nullable String defaultValue, boolean isMismatched) {
            if (nameAndType == null) {
                ParameterHtmlPresentation.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String nameAndType() {
            String string = this.nameAndType;
            if (string == null) {
                ParameterHtmlPresentation.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameAndType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/parameterInfo/ParameterInfoUIContext$ParameterHtmlPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/parameterInfo/ParameterInfoUIContext$ParameterHtmlPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nameAndType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

