/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.endpoints;

import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ6\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aJ6\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001d2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J'\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\"\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0083\u0004J\n\u0010%\u001a\u00020&H\u00d6\u0081\u0004J\n\u0010'\u001a\u00020(H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/intellij/microservices/endpoints/ModuleEndpointsFilter;", "Lcom/intellij/microservices/endpoints/SearchScopeEndpointsFilter;", "module", "Lcom/intellij/openapi/module/Module;", "fromLibraries", "", "fromTests", "<init>", "(Lcom/intellij/openapi/module/Module;ZZ)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getFromLibraries", "()Z", "getFromTests", "transitiveSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getTransitiveSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "contentSearchScope", "getContentSearchScope", "filterByScope", "", "T", "items", "", "containingFileGetter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiFile;", "sequence", "Lkotlin/sequences/Sequence;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.platform.lang"})
public final class ModuleEndpointsFilter
implements SearchScopeEndpointsFilter {
    @NotNull
    private final Module module;
    private final boolean fromLibraries;
    private final boolean fromTests;

    public ModuleEndpointsFilter(@NotNull Module module, boolean fromLibraries, boolean fromTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.fromLibraries = fromLibraries;
        this.fromTests = fromTests;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public final boolean getFromLibraries() {
        return this.fromLibraries;
    }

    public final boolean getFromTests() {
        return this.fromTests;
    }

    @Override
    @NotNull
    public GlobalSearchScope getTransitiveSearchScope() {
        if (this.fromLibraries) {
            GlobalSearchScope globalSearchScope = this.module.getModuleContentScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleContentScope(...)");
            GlobalSearchScope contentScope = globalSearchScope;
            GlobalSearchScope globalSearchScope2 = this.module.getModuleWithDependenciesAndLibrariesScope(true).union((SearchScope)contentScope);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"union(...)");
            GlobalSearchScope allModuleScope = globalSearchScope2;
            if (this.fromTests) {
                return allModuleScope;
            }
            GlobalSearchScope globalSearchScope3 = GlobalSearchScopesCore.projectTestScope((Project)this.module.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"projectTestScope(...)");
            GlobalSearchScope testScope = globalSearchScope3;
            GlobalSearchScope globalSearchScope4 = allModuleScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)testScope));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope4, (String)"intersectWith(...)");
            return globalSearchScope4;
        }
        if (this.fromTests) {
            GlobalSearchScope globalSearchScope = this.module.getModuleContentWithDependenciesScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleContentWithDependenciesScope(...)");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.projectTestScope((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectTestScope(...)");
        GlobalSearchScope testScope = globalSearchScope;
        GlobalSearchScope globalSearchScope5 = this.module.getModuleContentWithDependenciesScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)testScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope5, (String)"intersectWith(...)");
        return globalSearchScope5;
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentSearchScope() {
        if (this.fromTests) {
            GlobalSearchScope globalSearchScope = this.module.getModuleContentScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleContentScope(...)");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.projectTestScope((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectTestScope(...)");
        GlobalSearchScope testScope = globalSearchScope;
        GlobalSearchScope globalSearchScope2 = this.module.getModuleContentScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)testScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"intersectWith(...)");
        return globalSearchScope2;
    }

    @NotNull
    public final <T> Iterable<T> filterByScope(@NotNull Collection<? extends T> items, @NotNull Function1<? super T, ? extends PsiFile> containingFileGetter) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(containingFileGetter, (String)"containingFileGetter");
        if (this.fromTests && this.fromLibraries) {
            return items;
        }
        return this.filterByScope(CollectionsKt.asSequence((Iterable)items), containingFileGetter);
    }

    @NotNull
    public final <T> Iterable<T> filterByScope(@NotNull Sequence<? extends T> sequence, @NotNull Function1<? super T, ? extends PsiFile> containingFileGetter) {
        Intrinsics.checkNotNullParameter(sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter(containingFileGetter, (String)"containingFileGetter");
        if (this.fromTests && this.fromLibraries) {
            return SequencesKt.asIterable(sequence);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(...)");
        GlobalSearchScope librariesScope = globalSearchScope;
        return SequencesKt.asIterable((Sequence)SequencesKt.filter(sequence, arg_0 -> ModuleEndpointsFilter.filterByScope$lambda$0(containingFileGetter, this, librariesScope, arg_0)));
    }

    @NotNull
    public final Module component1() {
        return this.module;
    }

    public final boolean component2() {
        return this.fromLibraries;
    }

    public final boolean component3() {
        return this.fromTests;
    }

    @NotNull
    public final ModuleEndpointsFilter copy(@NotNull Module module, boolean fromLibraries, boolean fromTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new ModuleEndpointsFilter(module, fromLibraries, fromTests);
    }

    public static /* synthetic */ ModuleEndpointsFilter copy$default(ModuleEndpointsFilter moduleEndpointsFilter, Module module, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            module = moduleEndpointsFilter.module;
        }
        if ((n & 2) != 0) {
            bl = moduleEndpointsFilter.fromLibraries;
        }
        if ((n & 4) != 0) {
            bl2 = moduleEndpointsFilter.fromTests;
        }
        return moduleEndpointsFilter.copy(module, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "ModuleEndpointsFilter(module=" + this.module + ", fromLibraries=" + this.fromLibraries + ", fromTests=" + this.fromTests + ")";
    }

    public int hashCode() {
        int result = this.module.hashCode();
        result = result * 31 + Boolean.hashCode(this.fromLibraries);
        result = result * 31 + Boolean.hashCode(this.fromTests);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModuleEndpointsFilter)) {
            return false;
        }
        ModuleEndpointsFilter moduleEndpointsFilter = (ModuleEndpointsFilter)other;
        if (!Intrinsics.areEqual((Object)this.module, (Object)moduleEndpointsFilter.module)) {
            return false;
        }
        if (this.fromLibraries != moduleEndpointsFilter.fromLibraries) {
            return false;
        }
        return this.fromTests == moduleEndpointsFilter.fromTests;
    }

    private static final boolean filterByScope$lambda$0(Function1 $containingFileGetter, ModuleEndpointsFilter this$0, GlobalSearchScope $librariesScope, Object it) {
        PsiFile psiFile = (PsiFile)$containingFileGetter.invoke(it);
        VirtualFile file = psiFile != null ? psiFile.getVirtualFile() : null;
        return file == null || (this$0.fromLibraries || !$librariesScope.contains(file)) && (this$0.fromTests || !TestSourcesFilter.isTestSources((VirtualFile)file, (Project)this$0.module.getProject()));
    }
}

