/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.codeWithMe.ClientId;
import com.intellij.microservices.HttpReferenceService;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.DefaultExactPathSegmentHandler;
import com.intellij.microservices.url.references.PathSegmentHandler;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.microservices.url.references.UrlPathReferenceTarget;
import com.intellij.microservices.url.references.UrlSegmentReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003123BU\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\n\u0010\u001b\u001a\u00020\u001cH\u0096\u0080\u0004J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020+J\u0010\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001f\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u00064"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference;", "Lcom/intellij/psi/PsiReferenceBase$Poly;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/microservices/url/references/UrlSegmentReference;", "context", "Lcom/intellij/microservices/url/references/UrlPathContext;", "host", "range", "Lcom/intellij/openapi/util/TextRange;", "isAtEnd", "", "shouldHaveSlashBefore", "pathSegmentHandler", "Lcom/intellij/microservices/url/references/PathSegmentHandler;", "customNavigate", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/microservices/url/references/UrlPathContext;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;ZZLcom/intellij/microservices/url/references/PathSegmentHandler;Lkotlin/jvm/functions/Function1;)V", "getContext", "()Lcom/intellij/microservices/url/references/UrlPathContext;", "()Z", "getShouldHaveSlashBefore", "getPathSegmentHandler", "()Lcom/intellij/microservices/url/references/PathSegmentHandler;", "getCustomNavigate", "()Lkotlin/jvm/functions/Function1;", "toString", "", "unifiedPomTarget", "Lcom/intellij/microservices/url/references/UrlPathReferenceTarget;", "getUnifiedPomTarget", "()Lcom/intellij/microservices/url/references/UrlPathReferenceTarget;", "unifiedPomTarget$delegate", "Lkotlin/Lazy;", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "(Z)[Lcom/intellij/psi/ResolveResult;", "normalizedLength", "", "path", "Lcom/intellij/microservices/url/UrlPath;", "remainingPath", "currentPath", "variantPath", "isReferenceTo", "element", "Companion", "UrlTargetInfoWrapper", "UrlPathLookupObject", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nUrlPathReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathReference.kt\ncom/intellij/microservices/url/references/UrlPathReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,123:1\n1586#2:124\n1661#2,3:125\n1586#2:128\n1661#2,3:129\n952#2,15:133\n363#2,7:148\n1#3:132\n42#4,3:155\n42#4,3:158\n*S KotlinDebug\n*F\n+ 1 UrlPathReference.kt\ncom/intellij/microservices/url/references/UrlPathReference\n*L\n40#1:124\n40#1:125,3\n51#1:128\n51#1:129,3\n64#1:133,15\n72#1:148,7\n80#1:155,3\n46#1:158,3\n*E\n"})
public final class UrlPathReference
extends PsiReferenceBase.Poly<PsiElement>
implements UrlSegmentReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPathContext context;
    private final boolean isAtEnd;
    private final boolean shouldHaveSlashBefore;
    @NotNull
    private final PathSegmentHandler pathSegmentHandler;
    @Nullable
    private final Function1<UrlSegmentReference, Unit> customNavigate;
    @NotNull
    private final Lazy unifiedPomTarget$delegate;

    @JvmOverloads
    @ApiStatus.Internal
    public UrlPathReference(@NotNull UrlPathContext context, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd, boolean shouldHaveSlashBefore, @NotNull PathSegmentHandler pathSegmentHandler, @Nullable Function1<? super UrlSegmentReference, Unit> customNavigate) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)pathSegmentHandler, (String)"pathSegmentHandler");
        super(host, range, false);
        this.context = context;
        this.isAtEnd = isAtEnd;
        this.shouldHaveSlashBefore = shouldHaveSlashBefore;
        this.pathSegmentHandler = pathSegmentHandler;
        this.customNavigate = customNavigate;
        this.unifiedPomTarget$delegate = LazyKt.lazy(() -> UrlPathReference.unifiedPomTarget_delegate$lambda$0(this));
    }

    public /* synthetic */ UrlPathReference(UrlPathContext urlPathContext, PsiElement psiElement, TextRange textRange, boolean bl, boolean bl2, PathSegmentHandler pathSegmentHandler, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            pathSegmentHandler = DefaultExactPathSegmentHandler.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            function1 = null;
        }
        this(urlPathContext, psiElement, textRange, bl, bl2, pathSegmentHandler, (Function1<? super UrlSegmentReference, Unit>)function1);
    }

    @NotNull
    public final UrlPathContext getContext() {
        return this.context;
    }

    public final boolean isAtEnd() {
        return this.isAtEnd;
    }

    public final boolean getShouldHaveSlashBefore() {
        return this.shouldHaveSlashBefore;
    }

    @NotNull
    public final PathSegmentHandler getPathSegmentHandler() {
        return this.pathSegmentHandler;
    }

    @Nullable
    public final Function1<UrlSegmentReference, Unit> getCustomNavigate() {
        return this.customNavigate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Collection<UrlPath> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = (String)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> UrlPathReference.toString$lambda$0(this));
        if (string == null) {
            string = "<recursive-evaluation>";
        }
        String valueIfAvailable = string;
        Iterable iterable = CollectionsKt.toList(this.context.getResolveRequests());
        TextRange textRange = this.getRangeInElement();
        String string2 = valueIfAvailable;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UrlResolveRequest urlResolveRequest = (UrlResolveRequest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        collection = (List)destination$iv$iv;
        return "URLPathReference(" + string2 + ", " + textRange + ", contexts = " + CollectionsKt.distinct((Iterable)collection) + ")";
    }

    @Nullable
    public final UrlPathReferenceTarget getUnifiedPomTarget() {
        Lazy lazy = this.unifiedPomTarget$delegate;
        return (UrlPathReferenceTarget)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.listOfNotNull((Object)this.getUnifiedPomTarget());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UrlPathReferenceTarget urlPathReferenceTarget = (UrlPathReferenceTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toElement(this));
        }
        Collection p0 = (List)destination$iv$iv;
        boolean bl = false;
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)p0);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"let(...)");
        return resolveResultArray;
    }

    /*
     * WARNING - void declaration
     */
    private final int normalizedLength(UrlPath path) {
        int sub = 0;
        UrlPath.PathSegment it = (UrlPath.PathSegment)CollectionsKt.getOrNull(path.getSegments(), (int)sub);
        boolean bl = false;
        if (it instanceof UrlPath.PathSegment.Undefined) {
            ++sub;
        }
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.getOrNull(path.getSegments(), (int)sub);
        boolean bl2 = pathSegment != null ? pathSegment.isEmpty() : false;
        if (bl2) {
            ++sub;
        }
        if (path.getSegments().size() > 1) {
            List list;
            int n;
            block9: {
                void $this$takeLastWhile$iv;
                List<UrlPath.PathSegment> list2 = path.getSegments();
                n = sub;
                boolean $i$f$takeLastWhile = false;
                if ($this$takeLastWhile$iv.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else {
                    ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        UrlPath.PathSegment it2 = (UrlPath.PathSegment)iterator$iv.previous();
                        boolean bl3 = false;
                        if (it2.isEmpty()) continue;
                        iterator$iv.next();
                        int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                        if (expectedSize$iv == 0) {
                            list = CollectionsKt.emptyList();
                        } else {
                            ArrayList arrayList;
                            ArrayList $this$takeLastWhile_u24lambda_u240$iv = arrayList = new ArrayList(expectedSize$iv);
                            boolean bl4 = false;
                            while (iterator$iv.hasNext()) {
                                $this$takeLastWhile_u24lambda_u240$iv.add(iterator$iv.next());
                            }
                            list = arrayList;
                        }
                        break block9;
                    }
                    list = CollectionsKt.toList((Iterable)((Iterable)$this$takeLastWhile$iv));
                }
            }
            List list3 = list;
            sub = n + list3.size();
        }
        return path.getSegments().size() - sub;
    }

    @NotNull
    public final UrlPath remainingPath(@NotNull UrlPath currentPath, @NotNull UrlPath variantPath) {
        int indexOfFirstValue;
        List<UrlPath.PathSegment> segments;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)currentPath, (String)"currentPath");
            Intrinsics.checkNotNullParameter((Object)variantPath, (String)"variantPath");
            int chopPrefixAt = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)this.normalizedLength(currentPath), (int)0), (int)variantPath.getSegments().size());
            List<UrlPath.PathSegment> $this$indexOfFirst$iv = segments = variantPath.getSegments().subList(chopPrefixAt, variantPath.getSegments().size());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<UrlPath.PathSegment> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                UrlPath.PathSegment item$iv;
                UrlPath.PathSegment it = item$iv = iterator.next();
                boolean bl = false;
                if (!it.isEmpty()) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = indexOfFirstValue = -1;
        }
        if (indexOfFirstValue > 0) {
            return new UrlPath(segments.subList(indexOfFirstValue, segments.size()));
        }
        return new UrlPath(segments);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((HttpReferenceService)object).isReferenceToUrlPathTarget(element) && super.isReferenceTo(element);
    }

    @JvmOverloads
    @ApiStatus.Internal
    public UrlPathReference(@NotNull UrlPathContext context, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd, boolean shouldHaveSlashBefore, @NotNull PathSegmentHandler pathSegmentHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)pathSegmentHandler, (String)"pathSegmentHandler");
        this(context, host, range, isAtEnd, shouldHaveSlashBefore, pathSegmentHandler, null, 64, null);
    }

    @JvmOverloads
    @ApiStatus.Internal
    public UrlPathReference(@NotNull UrlPathContext context, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd, boolean shouldHaveSlashBefore) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(context, host, range, isAtEnd, shouldHaveSlashBefore, null, null, 96, null);
    }

    @JvmOverloads
    @ApiStatus.Internal
    public UrlPathReference(@NotNull UrlPathContext context, @NotNull PsiElement host, @NotNull TextRange range, boolean isAtEnd) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(context, host, range, isAtEnd, false, null, null, 112, null);
    }

    private static final String toString$lambda$0(UrlPathReference this$0) {
        return this$0.getValue();
    }

    private static final UrlPathReferenceTarget unifiedPomTarget_delegate$lambda$0(UrlPathReference this$0) {
        if (CollectionsKt.none(this$0.context.getResolveRequests())) {
            return null;
        }
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        HttpReferenceService httpReferenceService = (HttpReferenceService)object;
        UrlPathContext urlPathContext = this$0.context;
        boolean bl = this$0.isAtEnd;
        Project project = this$0.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return httpReferenceService.createUrlPathTarget(urlPathContext, bl, project);
    }

    @JvmStatic
    @NotNull
    public static final NavigatablePsiElement createSearchableElement(@NotNull Project project, @NotNull UrlPathContext urlPathContext) {
        return Companion.createSearchableElement(project, urlPathContext);
    }

    @JvmStatic
    @Nullable
    public static final NavigatablePsiElement createSearchableElement(@NotNull Project project, @NotNull UrlTargetInfo targetInfo) {
        return Companion.createSearchableElement(project, targetInfo);
    }

    @JvmStatic
    @Nullable
    public static final UrlPathReference getFromPomTargetPsiElement(@NotNull PsiElement psiElement) {
        return Companion.getFromPomTargetPsiElement(psiElement);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference$Companion;", "", "<init>", "()V", "createSearchableElement", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "getFromPomTargetPsiElement", "Lcom/intellij/microservices/url/references/UrlPathReference;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.platform.lang"})
    @SourceDebugExtension(value={"SMAP\nUrlPathReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathReference.kt\ncom/intellij/microservices/url/references/UrlPathReference$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,123:1\n42#2,3:124\n42#2,3:127\n*S KotlinDebug\n*F\n+ 1 UrlPathReference.kt\ncom/intellij/microservices/url/references/UrlPathReference$Companion\n*L\n87#1:124,3\n106#1:127,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NavigatablePsiElement createSearchableElement(@NotNull Project project, @NotNull UrlPathContext urlPathContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
            boolean $i$f$service = false;
            Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((HttpReferenceService)object).createSearchableUrlElement(project, urlPathContext);
        }

        @JvmStatic
        @Nullable
        public final NavigatablePsiElement createSearchableElement(@NotNull Project project, @NotNull UrlTargetInfo targetInfo) {
            UrlTargetInfo searchableInfo;
            UrlPathContext urlPathContext;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
            UrlPath urlPath = UrlPathContextKt.chopTrailingEmptyBlock(targetInfo.getPath());
            if (!Intrinsics.areEqual((Object)urlPath, (Object)UrlPath.Companion.getEMPTY()) && CollectionsKt.any((urlPathContext = new UrlPathContext(searchableInfo = Intrinsics.areEqual((Object)urlPath, (Object)targetInfo.getPath()) ? targetInfo : (UrlTargetInfo)new UrlTargetInfoWrapper(targetInfo, urlPath))).getResolveRequests())) {
                return this.createSearchableElement(project, urlPathContext);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final UrlPathReference getFromPomTargetPsiElement(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            boolean $i$f$service = false;
            Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((HttpReferenceService)object).getUrlFromPomTargetPsi(psiElement);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\f\u001a\u00020\rH\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference$UrlPathLookupObject;", "", "url", "", "<init>", "(Ljava/lang/String;)V", "toString", "component1", "copy", "equals", "", "other", "hashCode", "", "intellij.platform.lang"})
    public static final class UrlPathLookupObject {
        @NotNull
        private final String url;

        public UrlPathLookupObject(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @NotNull
        public String toString() {
            return this.url;
        }

        private final String component1() {
            return this.url;
        }

        @NotNull
        public final UrlPathLookupObject copy(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new UrlPathLookupObject(url);
        }

        public static /* synthetic */ UrlPathLookupObject copy$default(UrlPathLookupObject urlPathLookupObject, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = urlPathLookupObject.url;
            }
            return urlPathLookupObject.copy(string);
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlPathLookupObject)) {
                return false;
            }
            UrlPathLookupObject urlPathLookupObject = (UrlPathLookupObject)other;
            return Intrinsics.areEqual((Object)this.url, (Object)urlPathLookupObject.url);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010R\u0014\u0010)\u001a\u00020\u00138VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReference$UrlTargetInfoWrapper;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "original", "newPath", "Lcom/intellij/microservices/url/UrlPath;", "<init>", "(Lcom/intellij/microservices/url/UrlTargetInfo;Lcom/intellij/microservices/url/UrlPath;)V", "path", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "authorities", "", "Lcom/intellij/microservices/url/Authority;", "getAuthorities", "()Ljava/util/List;", "contentTypes", "", "", "getContentTypes", "()Ljava/util/Set;", "documentationPsiElement", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "methods", "getMethods", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "schemes", "getSchemes", "source", "getSource", "()Ljava/lang/String;", "intellij.platform.lang"})
    private static final class UrlTargetInfoWrapper
    implements UrlTargetInfo {
        @NotNull
        private final UrlTargetInfo original;
        @NotNull
        private final UrlPath newPath;

        public UrlTargetInfoWrapper(@NotNull UrlTargetInfo original, @NotNull UrlPath newPath) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            this.original = original;
            this.newPath = newPath;
        }

        @Override
        @NotNull
        public UrlPath getPath() {
            return this.newPath;
        }

        @Override
        @NotNull
        public List<String> getSchemes() {
            return this.original.getSchemes();
        }

        @Override
        @NotNull
        public List<Authority> getAuthorities() {
            return this.original.getAuthorities();
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.original.getIcon();
        }

        @Override
        public boolean isDeprecated() {
            return this.original.isDeprecated();
        }

        @Override
        @NotNull
        public Set<String> getMethods() {
            return this.original.getMethods();
        }

        @Override
        @NotNull
        public String getSource() {
            return this.original.getSource();
        }

        @Override
        @Nullable
        public PsiElement getDocumentationPsiElement() {
            return this.original.getDocumentationPsiElement();
        }

        @Override
        @Nullable
        public PsiElement resolveToPsiElement() {
            return this.original.resolveToPsiElement();
        }

        @Override
        @NotNull
        public Iterable<UrlQueryParameter> getQueryParameters() {
            return this.original.getQueryParameters();
        }

        @Override
        @NotNull
        public Set<String> getContentTypes() {
            return this.original.getContentTypes();
        }
    }
}

