/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search;

import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SearchContext {
    @Deprecated
    public static final SearchContext IN_CODE = new SearchContext("IN_CODE", 1);
    @Deprecated
    public static final SearchContext IN_CODE_HOSTS = new SearchContext("IN_CODE_HOSTS", 8);
    @Deprecated
    public static final SearchContext IN_COMMENTS = new SearchContext("IN_COMMENTS", 2);
    @Deprecated
    public static final SearchContext IN_STRINGS = new SearchContext("IN_STRINGS", 4);
    private static final SearchContext IN_PLAIN_TEXT = new SearchContext("IN_PLAIN_TEXT", 16);
    @NonNls
    @NotNull
    private final String debugName;
    private final short mask;

    private SearchContext(@NonNls @NotNull String debugName, short mask) {
        if (debugName == null) {
            SearchContext.$$$reportNull$$$0(0);
        }
        this.debugName = debugName;
        this.mask = mask;
    }

    public String toString() {
        return this.debugName;
    }

    @NotNull
    public static SearchContext inCode() {
        SearchContext searchContext = IN_CODE;
        if (searchContext == null) {
            SearchContext.$$$reportNull$$$0(1);
        }
        return searchContext;
    }

    @NotNull
    public static SearchContext inCodeHosts() {
        SearchContext searchContext = IN_CODE_HOSTS;
        if (searchContext == null) {
            SearchContext.$$$reportNull$$$0(2);
        }
        return searchContext;
    }

    @NotNull
    public static SearchContext inComments() {
        SearchContext searchContext = IN_COMMENTS;
        if (searchContext == null) {
            SearchContext.$$$reportNull$$$0(3);
        }
        return searchContext;
    }

    @NotNull
    public static SearchContext inStrings() {
        SearchContext searchContext = IN_STRINGS;
        if (searchContext == null) {
            SearchContext.$$$reportNull$$$0(4);
        }
        return searchContext;
    }

    @NotNull
    public static SearchContext inPlainText() {
        SearchContext searchContext = IN_PLAIN_TEXT;
        if (searchContext == null) {
            SearchContext.$$$reportNull$$$0(5);
        }
        return searchContext;
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public static short mask(@NotNull Collection<SearchContext> contexts) {
        if (contexts == null) {
            SearchContext.$$$reportNull$$$0(6);
        }
        short result = 0;
        for (SearchContext context : contexts) {
            result = (short)(result | context.mask);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/search/SearchContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/search/SearchContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "inCode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "inCodeHosts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inComments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "inStrings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "inPlainText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

