/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.WriteLockReacquisitionListener;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
final class ProgressIndicatorUtilService
implements Disposable {
    private final Logger LOG = Logger.getInstance(ProgressIndicatorUtilService.class);
    @NotNull
    private final ApplicationEx myApplication;
    private final List<Runnable> myWriteActionCancellations = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    static ProgressIndicatorUtilService getInstance(@NotNull Application application) {
        if (application == null) {
            ProgressIndicatorUtilService.$$$reportNull$$$0(0);
        }
        ProgressIndicatorUtilService progressIndicatorUtilService = (ProgressIndicatorUtilService)application.getService(ProgressIndicatorUtilService.class);
        if (progressIndicatorUtilService == null) {
            ProgressIndicatorUtilService.$$$reportNull$$$0(1);
        }
        return progressIndicatorUtilService;
    }

    private ProgressIndicatorUtilService() {
        this.myApplication = ApplicationManagerEx.getApplicationEx();
        this.myApplication.addApplicationListener(new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressIndicatorUtilService.this.cancelActionsToBeCancelledBeforeWrite();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtilService$1", "beforeWriteActionStart"));
            }
        }, (Disposable)this);
        this.myApplication.addSuspendingWriteActionListener(new WriteLockReacquisitionListener(){

            public void beforeWriteLockReacquired() {
                ProgressIndicatorUtilService.this.cancelActionsToBeCancelledBeforeWrite();
            }
        }, (Disposable)this);
    }

    public void dispose() {
        if (!this.myWriteActionCancellations.isEmpty()) {
            throw new AssertionError((Object)("Cancellations are not empty! " + String.valueOf(this.myWriteActionCancellations)));
        }
    }

    private void cancelActionsToBeCancelledBeforeWrite() {
        for (Runnable cancellation : this.myWriteActionCancellations) {
            cancellation.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runActionAndCancelBeforeWrite(@NotNull Runnable cancellation, @NotNull Runnable action) {
        if (cancellation == null) {
            ProgressIndicatorUtilService.$$$reportNull$$$0(2);
        }
        if (action == null) {
            ProgressIndicatorUtilService.$$$reportNull$$$0(3);
        }
        if (ProgressIndicatorUtils.isWriteActionRunningOrPending(this.myApplication)) {
            cancellation.run();
            return false;
        }
        this.myWriteActionCancellations.add(cancellation);
        try {
            if (ProgressIndicatorUtils.isWriteActionRunningOrPending(this.myApplication)) {
                cancellation.run();
                boolean bl = false;
                return bl;
            }
            action.run();
            boolean bl = true;
            return bl;
        }
        finally {
            this.myWriteActionCancellations.remove(cancellation);
        }
    }

    private static void throwCannotWriteException() {
        throw new IllegalStateException("Write actions are prohibited");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/ProgressIndicatorUtilService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/ProgressIndicatorUtilService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runActionAndCancelBeforeWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

