/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.LibrarySettingsProvider;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsService {
    public static ProjectSettingsService getInstance(Project project) {
        return (ProjectSettingsService)project.getService(ProjectSettingsService.class);
    }

    public void openProjectSettings() {
    }

    public void openGlobalLibraries() {
    }

    public void openLibrary(@NotNull Library library) {
        if (library == null) {
            ProjectSettingsService.$$$reportNull$$$0(0);
        }
    }

    public void openModuleSettings(Module module) {
    }

    public boolean canOpenModuleSettings() {
        return false;
    }

    public void openModuleLibrarySettings(Module module) {
    }

    public boolean canOpenModuleLibrarySettings() {
        return false;
    }

    public void openContentEntriesSettings(Module module) {
    }

    public boolean canOpenContentEntriesSettings() {
        return false;
    }

    public void openModuleDependenciesSettings(@NotNull Module module, @Nullable OrderEntry orderEntry) {
        if (module == null) {
            ProjectSettingsService.$$$reportNull$$$0(1);
        }
    }

    public boolean canOpenModuleDependenciesSettings() {
        return false;
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        Configurable additionalSettingsConfigurable;
        if (orderEntry == null) {
            ProjectSettingsService.$$$reportNull$$$0(2);
        }
        if ((additionalSettingsConfigurable = ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry)) != null) {
            ShowSettingsUtil.getInstance().showSettingsDialog(orderEntry.getOwnerModule().getProject(), additionalSettingsConfigurable.getDisplayName());
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        return ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry) != null;
    }

    @ApiStatus.Experimental
    public boolean canOpenLibrarySettings(LibraryEntity library) {
        return false;
    }

    @Nullable
    private static Configurable getLibrarySettingsConfigurable(OrderEntry orderEntry) {
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            return null;
        }
        LibraryOrderEntry libOrderEntry = (LibraryOrderEntry)orderEntry;
        Library lib = libOrderEntry.getLibrary();
        if (lib == null) {
            return null;
        }
        Project project = libOrderEntry.getOwnerModule().getProject();
        return ProjectSettingsService.getLibrarySettingsConfigurable(lib, project);
    }

    @ApiStatus.Internal
    @Nullable
    protected static Configurable getLibrarySettingsConfigurable(@NotNull Library lib, @NotNull Project project) {
        PersistentLibraryKind libKind;
        if (lib == null) {
            ProjectSettingsService.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ProjectSettingsService.$$$reportNull$$$0(4);
        }
        if (lib instanceof LibraryEx && (libKind = ((LibraryEx)lib).getKind()) != null) {
            return LibrarySettingsProvider.getAdditionalSettingsConfigurable(project, (LibraryKind)libKind);
        }
        return null;
    }

    public boolean processModulesMoved(Module[] modules, @Nullable String targetGroupName) {
        return false;
    }

    public void showModuleConfigurationDialog(@Nullable String moduleToSelect, @Nullable String editorNameToSelect) {
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public Sdk chooseAndSetSdk() {
        Logger.getInstance(this.getClass()).error("Call to the deprecated ProjectSettingsService#chooseAndSetSdk method. Please use new API instead");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ProjectSettingsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openModuleDependenciesSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibraryOrSdkSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibrarySettingsConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

