/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.multiverse.CodeInsightContextUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.application.ThreadingRuntimeFlagsKt;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThreadKt;
import com.intellij.psi.impl.PsiDocumentManagerEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.EDT;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\b\u0007\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0003@ABB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 *\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0015H\u0002J \u0010$\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0016J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010-\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010.\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010/\u001a\u000200H\u0096\u0080\u0004J\u0018\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0007JN\u00106\u001a\u0002072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002070=2\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u0018\u0010>\u001a\u0002072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010?\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u000209H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/psi/impl/DocumentCommitThread;", "Lcom/intellij/psi/impl/DocumentCommitProcessor;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "isDisposed", "", "()Z", "myExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "commitDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "commitDispatcherSuspender", "Lkotlinx/coroutines/sync/Semaphore;", "dispose", "", "commitAsynchronously", "project", "Lcom/intellij/openapi/project/Project;", "documentManager", "Lcom/intellij/psi/impl/PsiDocumentManagerEx;", "document", "Lcom/intellij/openapi/editor/Document;", "reason", "", "modality", "Lcom/intellij/openapi/application/ModalityState;", "commitDocumentWithCoroutines", "task", "Lcom/intellij/psi/impl/DocumentCommitThread$CommitTask;", "doCommitInReadAndWriteScope", "Lcom/intellij/openapi/application/ReadResult;", "Lcom/intellij/openapi/application/ReadAndWriteScope;", "isExpired", "docManager", "commitSynchronously", "psiFile", "Lcom/intellij/psi/PsiFile;", "commitUnderProgress", "Lkotlin/Function0;", "synchronously", "findViewProvidersForCommit", "", "Lcom/intellij/psi/FileViewProvider;", "newViewProvidersWereConcurrentlyAdded", "committedViewProviders", "toString", "", "waitForAllCommits", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "doCommit", "Lcom/intellij/psi/impl/BooleanRunnable;", "oldFileNode", "Lcom/intellij/lang/FileASTNode;", "changedPsiRange", "Lcom/intellij/openapi/util/ProperTextRange;", "outReparseInjectedProcessors", "", "handleCommitWithoutPsi", "assertAfterCommit", "Companion", "PerProjectDocumentCommitRegistry", "CommitTask", "intellij.platform.ide.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDocumentCommitThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentCommitThread.kt\ncom/intellij/psi/impl/DocumentCommitThread\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,525:1\n1#2:526\n30#3,2:527\n67#4,4:529\n67#4,4:539\n67#4,4:543\n67#4,4:547\n1391#5:533\n1480#5,5:534\n*S KotlinDebug\n*F\n+ 1 DocumentCommitThread.kt\ncom/intellij/psi/impl/DocumentCommitThread\n*L\n127#1:527,2\n202#1:529,4\n284#1:539,4\n293#1:543,4\n302#1:547,4\n215#1:533\n215#1:534,5\n*E\n"})
public final class DocumentCommitThread
implements DocumentCommitProcessor,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService myExecutor;
    @NotNull
    private final CoroutineDispatcher commitDispatcher;
    @NotNull
    private final Semaphore commitDispatcherSuspender;

    public DocumentCommitThread() {
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Document Commit Pool");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.myExecutor = executorService;
        this.commitDispatcher = Dispatchers.getDefault().limitedParallelism(1, "Document commit dispatcher");
        this.commitDispatcherSuspender = SemaphoreKt.Semaphore$default((int)1, (int)0, (int)2, null);
    }

    private final boolean isDisposed() {
        return this.myExecutor.isShutdown();
    }

    public void dispose() {
        this.myExecutor.shutdownNow();
    }

    public void commitAsynchronously(@NotNull Project project, @NotNull PsiDocumentManagerEx documentManager, @NotNull Document document, @NotNull Object reason, @NotNull ModalityState modality) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)documentManager, (String)"documentManager");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
        boolean bl2 = bl = !this.isDisposed();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DocumentCommitThread$commitAsynchronously$22 = false;
            String $i$a$-assert-DocumentCommitThread$commitAsynchronously$22 = "already disposed";
            throw new AssertionError((Object)$i$a$-assert-DocumentCommitThread$commitAsynchronously$22);
        }
        if (!project.isInitialized()) {
            return;
        }
        if (!(documentManager.getProject() == project)) {
            boolean bl3 = false;
            String string = "Wrong project: " + project + "; expected: " + documentManager.getProject();
            throw new IllegalArgumentException(string.toString());
        }
        TransactionGuard.getInstance().assertWriteSafeContext(modality);
        CommitTask task = new CommitTask(project, document, reason, modality);
        if (DocumentCommitThread.Companion.canUseCoroutinesForDocumentCommit()) {
            this.commitDocumentWithCoroutines(document, task, documentManager);
        } else {
            Object[] objectArray = new Object[]{task};
            CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> DocumentCommitThread.commitAsynchronously$lambda$2(this, task, documentManager)).expireWhen(() -> DocumentCommitThread.commitAsynchronously$lambda$3(this, task, documentManager)).coalesceBy(objectArray).finishOnUiThread(modality, arg_0 -> DocumentCommitThread.commitAsynchronously$lambda$5(DocumentCommitThread::commitAsynchronously$lambda$4, arg_0)).submit((Executor)this.myExecutor);
            Intrinsics.checkNotNull((Object)cancellablePromise);
        }
    }

    private final void commitDocumentWithCoroutines(Document document, CommitTask task, PsiDocumentManagerEx documentManager) {
        Job existingJob;
        ComponentManager $this$service$iv = (ComponentManager)task.getMyProject();
        boolean $i$f$service = false;
        Class<PerProjectDocumentCommitRegistry> serviceClass$iv = PerProjectDocumentCommitRegistry.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        PerProjectDocumentCommitRegistry service = (PerProjectDocumentCommitRegistry)object;
        Job job2 = BuildersKt.launch((CoroutineScope)service.getScope(), (CoroutineContext)((CoroutineContext)this.commitDispatcher), (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, task, documentManager, null){
            int label;
            final /* synthetic */ DocumentCommitThread this$0;
            final /* synthetic */ CommitTask $task;
            final /* synthetic */ PsiDocumentManagerEx $documentManager;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                this.$documentManager = $documentManager;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 6[CASE]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final ReadResult invokeSuspend$lambda$0(DocumentCommitThread this$0, CommitTask $task, PsiDocumentManagerEx $documentManager, ReadAndWriteScope $this$readAndBackgroundWriteActionUndispatched) {
                return DocumentCommitThread.access$doCommitInReadAndWriteScope(this$0, $this$readAndBackgroundWriteActionUndispatched, $task, $documentManager);
            }
        }));
        job2.invokeOnCompletion(arg_0 -> DocumentCommitThread.commitDocumentWithCoroutines$lambda$0(task, service, job2, arg_0));
        Job job3 = existingJob = service.getPublishedDocumentCommitRequests().put(document, job2);
        if (job3 != null) {
            Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
        }
        job2.start();
    }

    private final ReadResult<Unit> doCommitInReadAndWriteScope(ReadAndWriteScope $this$doCommitInReadAndWriteScope, CommitTask task, PsiDocumentManagerEx documentManager) {
        if (this.isExpired(task, documentManager)) {
            return $this$doCommitInReadAndWriteScope.value((Object)Unit.INSTANCE);
        }
        Function0<Unit> writeThreadCallback = this.commitUnderProgress(task, false, documentManager);
        if (this.isExpired(task, documentManager)) {
            return $this$doCommitInReadAndWriteScope.value((Object)Unit.INSTANCE);
        }
        return $this$doCommitInReadAndWriteScope.writeAction(() -> DocumentCommitThread.doCommitInReadAndWriteScope$lambda$0(writeThreadCallback));
    }

    private final boolean isExpired(CommitTask task, PsiDocumentManagerEx docManager) {
        return this.isDisposed() || task.isExpired(docManager);
    }

    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        boolean bl2 = bl = !this.isDisposed();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!(project.isInitialized() || project.isDefault())) {
            boolean $i$a$-require-DocumentCommitThread$commitSynchronously$22 = false;
            String $i$a$-require-DocumentCommitThread$commitSynchronously$22 = "Must not call sync commit with unopened project: " + project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            throw new IllegalArgumentException($i$a$-require-DocumentCommitThread$commitSynchronously$22.toString());
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)psiDocumentManager, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiDocumentManagerEx");
        PsiDocumentManagerEx documentManager = (PsiDocumentManagerEx)psiDocumentManager;
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        CommitTask task = new CommitTask(project, document, "Sync commit", modalityState);
        this.commitUnderProgress(task, true, documentManager).invoke();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final Function0<Unit> commitUnderProgress(CommitTask task, boolean synchronously, PsiDocumentManagerEx documentManager) {
        if (!synchronously) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = task.getMyDocumentRef().get();
        if (document == null) {
            return DocumentCommitThread::commitUnderProgress$lambda$0;
        }
        Document document2 = document;
        Project project = task.getMyProject();
        SmartList finishProcessors = new SmartList();
        SmartList reparseInjectedProcessors = new SmartList();
        Logger $this$trace$iv = DocumentCommitThreadKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("commitUnderProgress: " + task.getMyReason() + ", " + document2 + ", synchronously: " + synchronously + " ");
        }
        List<FileViewProvider> viewProviders = this.findViewProvidersForCommit(document2, project);
        if (viewProviders.isEmpty()) {
            finishProcessors.add((Object)this.handleCommitWithoutPsi(task, documentManager));
            task.setCachedViewProviders(CollectionsKt.emptyList());
        } else {
            void $this$flatMapTo$iv$iv;
            task.setCachedViewProviders(viewProviders);
            Iterable $this$flatMap$iv = viewProviders;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                FileViewProvider it = (FileViewProvider)element$iv$iv;
                boolean bl = false;
                List list = it.getAllFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            for (Object e : (List)destination$iv$iv) {
                FileASTNode oldFileNode;
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                PsiFile psiFile = (PsiFile)e;
                if (psiFile.getNode() == null) {
                    throw new AssertionError((Object)("No node for " + psiFile.getClass() + " in " + psiFile.getViewProvider().getClass() + " of size " + StringUtil.formatFileSize((long)document2.getTextLength()) + " (is too large = " + SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)psiFile.getViewProvider().getVirtualFile(), (Long)Long.valueOf(document2.getTextLength())) + ")"));
                }
                ProperTextRange changedPsiRange = ChangedPsiRangeUtil.getChangedPsiRange((PsiFile)psiFile, (Document)document2, (CharSequence)task.getMyLastCommittedText(), (CharSequence)document2.getImmutableCharSequence());
                if (changedPsiRange == null) continue;
                BooleanRunnable finishProcessor = this.doCommit(task, synchronously, document2, psiFile, oldFileNode, changedPsiRange, (List)reparseInjectedProcessors, documentManager);
                finishProcessors.add((Object)finishProcessor);
            }
        }
        return () -> DocumentCommitThread.commitUnderProgress$lambda$3(project, task, synchronously, this, documentManager, finishProcessors, reparseInjectedProcessors);
    }

    private final List<FileViewProvider> findViewProvidersForCommit(Document document, Project project) {
        PsiManagerEx psiManager = PsiManagerEx.getInstanceEx((Project)project);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project2 = psiManager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (CodeInsightContexts.isSharedSourceSupportEnabled((Project)project2)) {
            List list = psiManager.getFileManagerEx().findCachedViewProviders(virtualFile2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findCachedViewProviders(...)");
            List cached = list;
            if (!((Collection)cached).isEmpty()) {
                return cached;
            }
        }
        return CollectionsKt.listOfNotNull((Object)psiManager.findViewProvider(virtualFile2));
    }

    private final boolean newViewProvidersWereConcurrentlyAdded(Document document, List<? extends FileViewProvider> committedViewProviders, Project project) {
        List<FileViewProvider> currentProviders = this.findViewProvidersForCommit(document, project);
        if (committedViewProviders.size() != currentProviders.size()) {
            Logger $this$trace$iv = DocumentCommitThreadKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Concurrent view provider modification detected. Was: " + committedViewProviders.size() + ", Now: " + currentProviders.size() + ". Adding document back to the queue. " + document);
            }
            return true;
        }
        if (committedViewProviders.size() == 1) {
            if (Intrinsics.areEqual((Object)CollectionsKt.first(committedViewProviders), (Object)CollectionsKt.first(currentProviders))) {
                return false;
            }
            Logger $this$trace$iv = DocumentCommitThreadKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Concurrent view provider modification detected: view provider was changed to another one. Adding document back to the queue. " + document);
            }
            return true;
        }
        if (CollectionsKt.toSet((Iterable)committedViewProviders).containsAll((Collection)currentProviders)) {
            return false;
        }
        Logger $this$trace$iv = DocumentCommitThreadKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Concurrent view provider modification detected. Adding document back to the queue. " + document);
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "Document commit thread; application: " + ApplicationManager.getApplication() + "; isDisposed: " + this.isDisposed();
    }

    @TestOnly
    public final void waitForAllCommits(long timeout, @NotNull TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        ExecutorService executorService = this.myExecutor;
        Intrinsics.checkNotNull((Object)executorService, (String)"null cannot be cast to non-null type com.intellij.util.concurrency.BoundedTaskExecutor");
        BoundedTaskExecutor boundedTaskExecutor = (BoundedTaskExecutor)executorService;
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            boundedTaskExecutor.waitAllTasksExecuted(timeout, timeUnit);
            while (this.commitDispatcherSuspender.getAvailablePermits() == 0) {
                Thread.sleep(10L);
            }
            return;
        }
        boolean bl2 = bl = !ApplicationManager.getApplication().isWriteAccessAllowed();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        EDT.dispatchAllInvocationEvents();
        long deadLine = System.nanoTime() + timeUnit.toNanos(timeout);
        while (!boundedTaskExecutor.isEmpty() || this.commitDispatcherSuspender.getAvailablePermits() == 0) {
            block6: {
                try {
                    boundedTaskExecutor.waitAllTasksExecuted(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (System.nanoTime() <= deadLine) break block6;
                    throw e;
                }
            }
            EDT.dispatchAllInvocationEvents();
        }
    }

    @RequiresReadLock
    private final BooleanRunnable doCommit(CommitTask task, boolean synchronously, Document document, PsiFile psiFile, FileASTNode oldFileNode, ProperTextRange changedPsiRange, List<BooleanRunnable> outReparseInjectedProcessors, PsiDocumentManagerEx documentManager) {
        if (!synchronously) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CharSequence charSequence = document.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence newDocumentText = charSequence;
        Boolean data = (Boolean)document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            psiFile.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)data);
        }
        DiffLog diffLog = null;
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        try {
            BlockSupportImpl.ReparseResult reparseResult = BlockSupportImpl.reparse((PsiFile)psiFile, (FileASTNode)oldFileNode, (TextRange)((TextRange)changedPsiRange), (CharSequence)newDocumentText, (ProgressIndicator)indicator, (CharSequence)task.getMyLastCommittedText());
            Intrinsics.checkNotNullExpressionValue((Object)reparseResult, (String)"reparse(...)");
            BlockSupportImpl.ReparseResult result = reparseResult;
            DiffLog diffLog2 = result.log;
            Intrinsics.checkNotNullExpressionValue((Object)diffLog2, (String)"log");
            diffLog = diffLog2;
            List list = documentManager.reparseChangedInjectedFragments(document, psiFile, (TextRange)changedPsiRange, indicator, result.oldRoot, result.newRoot);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"reparseChangedInjectedFragments(...)");
            List injectedRunnables = list;
            outReparseInjectedProcessors.addAll(injectedRunnables);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            DocumentCommitThreadKt.access$getLOG$p().error(e);
            return () -> DocumentCommitThread.doCommit$lambda$0(documentManager, psiFile);
        }
        return () -> DocumentCommitThread.doCommit$lambda$1(task, psiFile, documentManager, diffLog, this, oldFileNode);
    }

    private final BooleanRunnable handleCommitWithoutPsi(CommitTask task, PsiDocumentManagerEx documentManager) {
        return () -> DocumentCommitThread.handleCommitWithoutPsi$lambda$0(task, documentManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void assertAfterCommit(Document document, PsiFile psiFile, FileASTNode oldFileNode) {
        if (oldFileNode.getTextLength() == document.getTextLength()) {
            return;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String documentText = string;
        String fileText = psiFile.getText();
        boolean sameText = Intrinsics.areEqual((Object)fileText, (Object)documentText);
        String errorMessage = "commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)((PsiElement)psiFile), (Document)document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + psiFile.getName() + "; type:" + psiFile.getFileType() + "; lang:" + psiFile.getLanguage();
        PluginException.logPluginError((Logger)DocumentCommitThreadKt.access$getLOG$p(), (String)errorMessage, null, psiFile.getLanguage().getClass());
        psiFile.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)true);
        try {
            BlockSupport blockSupport = BlockSupport.getInstance((Project)psiFile.getProject());
            DiffLog diffLog = blockSupport.reparseRange(psiFile, psiFile.getNode(), new TextRange(0, documentText.length()), (CharSequence)documentText, (ProgressIndicator)new StandardProgressIndicatorBase(), (CharSequence)oldFileNode.getText());
            Intrinsics.checkNotNullExpressionValue((Object)diffLog, (String)"reparseRange(...)");
            DiffLog diffLog2 = diffLog;
            diffLog2.doActualPsiChange(psiFile);
            if (oldFileNode.getTextLength() != document.getTextLength()) {
                PluginException.logPluginError((Logger)DocumentCommitThreadKt.access$getLOG$p(), (String)("PSI is broken beyond repair in: " + psiFile), null, psiFile.getLanguage().getClass());
            }
        }
        finally {
            psiFile.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
        }
    }

    private static final Function0 commitAsynchronously$lambda$2(DocumentCommitThread this$0, CommitTask $task, PsiDocumentManagerEx $documentManager) {
        return this$0.commitUnderProgress($task, false, $documentManager);
    }

    private static final boolean commitAsynchronously$lambda$3(DocumentCommitThread this$0, CommitTask $task, PsiDocumentManagerEx $documentManager) {
        return this$0.isExpired($task, $documentManager);
    }

    private static final Unit commitAsynchronously$lambda$4(Function0 it) {
        it.invoke();
        return Unit.INSTANCE;
    }

    private static final void commitAsynchronously$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit commitDocumentWithCoroutines$lambda$0(CommitTask $task, PerProjectDocumentCommitRegistry $service, Job $job, Throwable it) {
        block0: {
            Document document = $task.getMyDocumentRef().get();
            if (document == null) break block0;
            Document it2 = document;
            boolean bl = false;
            $service.getPublishedDocumentCommitRequests().remove(it2, $job);
        }
        return Unit.INSTANCE;
    }

    private static final Unit doCommitInReadAndWriteScope$lambda$0(Function0 $writeThreadCallback) {
        $writeThreadCallback.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit commitUnderProgress$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit commitUnderProgress$lambda$3(Project $project, CommitTask $task, boolean $synchronously, DocumentCommitThread this$0, PsiDocumentManagerEx $documentManager, SmartList $finishProcessors, SmartList $reparseInjectedProcessors) {
        if ($project.isDisposed()) {
            return Unit.INSTANCE;
        }
        Document document = $task.getMyDocumentRef().get();
        if (document == null) {
            return Unit.INSTANCE;
        }
        Document document2 = document;
        if (!$synchronously && this$0.newViewProvidersWereConcurrentlyAdded(document2, $task.getCachedViewProviders(), $project)) {
            this$0.commitAsynchronously($project, $documentManager, document2, "Re-added back because of new view providers", $task.getMyCreationModality());
            return Unit.INSTANCE;
        }
        boolean success = $documentManager.finishCommit(document2, (List)$finishProcessors, (List)$reparseInjectedProcessors, $synchronously, $task.getMyReason());
        if ($synchronously && _Assertions.ENABLED && !success) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if ($synchronously || success) {
            boolean bl;
            boolean bl2 = bl = !$documentManager.isInUncommittedSet(document2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        if (!success && CodeInsightContextUtil.isEventSystemEnabled($task.getCachedViewProviders())) {
            this$0.commitAsynchronously($project, $documentManager, document2, "Re-added back", $task.getMyCreationModality());
        }
        return Unit.INSTANCE;
    }

    private static final boolean doCommit$lambda$0(PsiDocumentManagerEx $documentManager, PsiFile $psiFile) {
        $documentManager.forceReload($psiFile.getViewProvider().getVirtualFile(), CollectionsKt.listOf((Object)$psiFile.getViewProvider()));
        return true;
    }

    private static final boolean doCommit$lambda$1(CommitTask $task, PsiFile $psiFile, PsiDocumentManagerEx $documentManager, DiffLog $diffLog, DocumentCommitThread this$0, FileASTNode $oldFileNode) {
        Document document = $task.getMyDocumentRef().get();
        if (document == null) {
            return false;
        }
        Document document2 = document;
        FileViewProvider fileViewProvider = $psiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider viewProvider = fileViewProvider;
        if ($task.stillValidDocument() == null || !$documentManager.getCachedViewProviders(document2).contains(viewProvider)) {
            return false;
        }
        if (!ApplicationManager.getApplication().isWriteAccessAllowed() && $documentManager.isEventSystemEnabled(document2)) {
            VirtualFile virtualFile = viewProvider.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            VirtualFile vFile = virtualFile;
            DocumentCommitThreadKt.access$getLOG$p().error("Write action expected; document=" + document2 + "; file=" + $psiFile + " of " + $psiFile.getClass() + "; file.valid=" + $psiFile.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + $psiFile.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + AbstractFileViewProvider.isFreeThreaded((FileViewProvider)viewProvider));
        }
        $diffLog.doActualPsiChange($psiFile);
        this$0.assertAfterCommit(document2, $psiFile, $oldFileNode);
        Reference.reachabilityFence($task.getCachedViewProviders());
        return true;
    }

    private static final boolean handleCommitWithoutPsi$lambda$0(CommitTask $task, PsiDocumentManagerEx $documentManager) {
        boolean bl;
        Document document = $task.getMyDocumentRef().get();
        if (document == null) {
            return false;
        }
        Document document2 = document;
        if ($task.stillValidDocument() != null && $documentManager.getCachedViewProviders(document2).isEmpty()) {
            $documentManager.handleCommitWithoutPsi(document2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final DocumentCommitThread getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Semaphore access$getCommitDispatcherSuspender$p(DocumentCommitThread $this) {
        return $this.commitDispatcherSuspender;
    }

    public static final /* synthetic */ ReadResult access$doCommitInReadAndWriteScope(DocumentCommitThread $this, ReadAndWriteScope $receiver, CommitTask task, PsiDocumentManagerEx documentManager) {
        return $this.doCommitInReadAndWriteScope($receiver, task, documentManager);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B.\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010&\u001a\u00070'\u00a2\u0006\u0002\b\u0007H\u0096\u0080\u0004J\u0014\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010+\u001a\u00020\u001eH\u0096\u0080\u0004J\b\u0010,\u001a\u0004\u0018\u00010\u0005J\u000e\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00060"}, d2={"Lcom/intellij/psi/impl/DocumentCommitThread$CommitTask;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "reason", "Lorg/jetbrains/annotations/NonNls;", "creationModality", "Lcom/intellij/openapi/application/ModalityState;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Ljava/lang/Object;Lcom/intellij/openapi/application/ModalityState;)V", "myProject", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "myReason", "getMyReason", "()Ljava/lang/Object;", "myCreationModality", "getMyCreationModality", "()Lcom/intellij/openapi/application/ModalityState;", "myDocumentRef", "Ljava/lang/ref/Reference;", "getMyDocumentRef", "()Ljava/lang/ref/Reference;", "myLastCommittedText", "", "getMyLastCommittedText", "()Ljava/lang/CharSequence;", "myModificationSequence", "", "cachedViewProviders", "", "Lcom/intellij/psi/FileViewProvider;", "getCachedViewProviders", "()Ljava/util/List;", "setCachedViewProviders", "(Ljava/util/List;)V", "toString", "", "equals", "", "other", "hashCode", "stillValidDocument", "isExpired", "documentManager", "Lcom/intellij/psi/impl/PsiDocumentManagerEx;", "intellij.platform.ide.core.impl"})
    private static final class CommitTask {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Object myReason;
        @NotNull
        private final ModalityState myCreationModality;
        @NotNull
        private final Reference<Document> myDocumentRef;
        @NotNull
        private final CharSequence myLastCommittedText;
        private final int myModificationSequence;
        public volatile List<? extends FileViewProvider> cachedViewProviders;

        @NotNull
        public final Project getMyProject() {
            return this.myProject;
        }

        @NotNull
        public final Object getMyReason() {
            return this.myReason;
        }

        @NotNull
        public final ModalityState getMyCreationModality() {
            return this.myCreationModality;
        }

        @NotNull
        public final Reference<Document> getMyDocumentRef() {
            return this.myDocumentRef;
        }

        @NotNull
        public final CharSequence getMyLastCommittedText() {
            return this.myLastCommittedText;
        }

        @NotNull
        public final List<FileViewProvider> getCachedViewProviders() {
            List<FileViewProvider> list = this.cachedViewProviders;
            if (list != null) {
                return list;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedViewProviders");
            return null;
        }

        public final void setCachedViewProviders(@NotNull List<? extends FileViewProvider> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.cachedViewProviders = list;
        }

        public CommitTask(@NotNull Project project, @NotNull Document document, @NotNull Object reason, @NotNull ModalityState creationModality) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)creationModality, (String)"creationModality");
            this.myProject = project;
            this.myReason = reason.toString();
            this.myCreationModality = creationModality;
            this.myDocumentRef = new WeakReference<Document>(document);
            CharSequence charSequence = PsiDocumentManager.getInstance((Project)project).getLastCommittedText(document);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getLastCommittedText(...)");
            this.myLastCommittedText = charSequence;
            this.myModificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NotNull
        public String toString() {
            Document document = this.stillValidDocument();
            DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
            String reasonInfo = " task reason: " + StringUtil.first((String)this.myReason.toString(), (int)180, (boolean)true) + document + "; changed: old seq=" + this.myModificationSequence + ", new seq=" + (documentEx != null ? Integer.valueOf(documentEx.getModificationSequence()) : null);
            String contextInfo = " modality: " + this.myCreationModality;
            return System.identityHashCode(this) + "; " + contextInfo + reasonInfo;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitTask)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.myDocumentRef.get(), (Object)((CommitTask)other).myDocumentRef.get()) && Intrinsics.areEqual((Object)this.myProject, (Object)((CommitTask)other).myProject);
        }

        public int hashCode() {
            return 31 * Objects.hashCode(this.myDocumentRef.get()) + this.myProject.hashCode();
        }

        @Nullable
        public final Document stillValidDocument() {
            Document document = this.myDocumentRef.get();
            return document instanceof DocumentEx && ((DocumentEx)document).getModificationSequence() == this.myModificationSequence ? document : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isExpired(@NotNull PsiDocumentManagerEx documentManager) {
            Intrinsics.checkNotNullParameter((Object)documentManager, (String)"documentManager");
            Document document = this.stillValidDocument();
            if (this.myProject.isDisposed()) return true;
            if (document == null) return true;
            if (!documentManager.isInUncommittedSet(document)) return true;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) return true;
            if (!virtualFile.isValid()) return true;
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/psi/impl/DocumentCommitThread$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/psi/impl/DocumentCommitThread;", "canUseCoroutinesForDocumentCommit", "", "intellij.platform.ide.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDocumentCommitThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentCommitThread.kt\ncom/intellij/psi/impl/DocumentCommitThread$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,525:1\n42#2,3:526\n*S KotlinDebug\n*F\n+ 1 DocumentCommitThread.kt\ncom/intellij/psi/impl/DocumentCommitThread$Companion\n*L\n73#1:526,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DocumentCommitThread getInstance() {
            boolean $i$f$service = false;
            Class<DocumentCommitProcessor> serviceClass$iv = DocumentCommitProcessor.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.impl.DocumentCommitThread");
            return (DocumentCommitThread)object;
        }

        private final boolean canUseCoroutinesForDocumentCommit() {
            return ThreadingRuntimeFlagsKt.getUseBackgroundWriteAction() && Registry.Companion.is("document.async.commit.with.coroutines");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/psi/impl/DocumentCommitThread$PerProjectDocumentCommitRegistry;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "publishedDocumentCommitRequests", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Document;", "Lkotlinx/coroutines/Job;", "getPublishedDocumentCommitRequests", "()Ljava/util/concurrent/ConcurrentMap;", "intellij.platform.ide.core.impl"})
    public static final class PerProjectDocumentCommitRegistry {
        @NotNull
        private final CoroutineScope scope;
        @NotNull
        private final ConcurrentMap<Document, Job> publishedDocumentCommitRequests;

        public PerProjectDocumentCommitRegistry(@NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.scope = scope;
            ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
            this.publishedDocumentCommitRequests = concurrentMap;
        }

        @NotNull
        public final CoroutineScope getScope() {
            return this.scope;
        }

        @NotNull
        public final ConcurrentMap<Document, Job> getPublishedDocumentCommitRequests() {
            return this.publishedDocumentCommitRequests;
        }
    }
}

