/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Java11Shim;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.ProcessorWithThrottledCancellationCheck;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FilenameIndex {
    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");

    private FilenameIndex() {
    }

    @NotNull
    public static @NotNull String @NotNull [] getAllFilenames(@NotNull Project project) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(0);
        }
        Set names = CollectionFactory.createSmallMemoryFootprintSet();
        FilenameIndex.processAllFileNames((Processor<? super String>)((Processor)s -> {
            names.add(s);
            return true;
        }), GlobalSearchScope.allScope((Project)project), null);
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)names);
        if (stringArray == null) {
            FilenameIndex.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    public static void processAllFileNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(3);
        }
        ProcessorWithThrottledCancellationCheck withThrottledCancellationCheck = new ProcessorWithThrottledCancellationCheck(s -> processor.process((Object)s.toString()));
        FilenameIndex.processAllFileNameCharSequences(withThrottledCancellationCheck, scope, filter);
    }

    private static void processAllFileNameCharSequences(@NotNull Processor<? super CharSequence> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(5);
        }
        FileBasedIndex.getInstance().processAllKeys(NAME, processor, scope, filter);
    }

    @Deprecated
    @NotNull
    public static @Unmodifiable Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(7);
        }
        return FilenameIndex.getVirtualFilesByName(name, scope);
    }

    @NotNull
    public static @Unmodifiable Collection<VirtualFile> getVirtualFilesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(9);
        }
        return FilenameIndex.getVirtualFilesByNames(Set.of(name), scope, null);
    }

    @Deprecated
    @NotNull
    public static @Unmodifiable Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(11);
        }
        return FilenameIndex.getVirtualFilesByName(name, caseSensitively, scope);
    }

    @NotNull
    public static @Unmodifiable Collection<VirtualFile> getVirtualFilesByName(@NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(13);
        }
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(name, scope);
        }
        return FilenameIndex.getVirtualFilesByNamesIgnoringCase(Set.of(name), scope, null);
    }

    @Deprecated
    @NotNull
    public static @NotNull PsiFile @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(14);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(16);
        }
        return (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
    }

    @Deprecated(forRemoval=true)
    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(19);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(20);
        }
        return FilenameIndex.processFilesByName(name, directories, processor, scope, project, null);
    }

    @Deprecated
    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(23);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(24);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        boolean[] result = new boolean[]{false};
        FilenameIndex.processFilesByNames(Set.of(name), true, scope, idFilter, (Processor<? super VirtualFile>)((Processor)file -> {
            PsiDirectory psi;
            if (!file.isValid()) {
                return true;
            }
            if (directories != file.isDirectory()) {
                return true;
            }
            Object object = psi = directories ? psiManager.findDirectory(file) : psiManager.findFile(file);
            if (psi == null) {
                return true;
            }
            result[0] = true;
            return processor.process((Object)psi);
        }));
        return result[0];
    }

    public static boolean processFilesByName(@NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(27);
        }
        return FilenameIndex.processFilesByNames(Set.of(name), caseSensitively, scope, null, processor);
    }

    public static boolean processFilesByNames(@NotNull Set<String> names, boolean caseSensitively, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Processor<? super VirtualFile> processor) {
        if (names == null) {
            FilenameIndex.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(30);
        }
        if (names.isEmpty()) {
            return true;
        }
        if (caseSensitively) {
            return FileBasedIndex.getInstance().processFilesContainingAnyKey(NAME, names, scope, idFilter, null, new ProcessorWithThrottledCancellationCheck<VirtualFile>(processor));
        }
        Set<VirtualFile> files = FilenameIndex.getVirtualFilesByNamesIgnoringCase(names, scope, idFilter);
        return ContainerUtil.process(files, processor);
    }

    @NotNull
    private static @Unmodifiable Set<VirtualFile> getVirtualFilesByNamesIgnoringCase(@NotNull Set<String> names, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (names == null) {
            FilenameIndex.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(32);
        }
        Set nameSet = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)HashingStrategy.caseInsensitive());
        nameSet.addAll(names);
        Set keys = CollectionFactory.createSmallMemoryFootprintSet();
        FilenameIndex.processAllFileNames((Processor<? super String>)((Processor)value -> {
            if (nameSet.contains(value)) {
                keys.add(value);
            }
            return true;
        }), scope, idFilter);
        return FilenameIndex.getVirtualFilesByNames(keys, scope, idFilter);
    }

    @Deprecated
    @NotNull
    public static @NotNull PsiFileSystemItem @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope, boolean directories) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(33);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(35);
        }
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result);
        FilenameIndex.processFilesByName(name, directories, (Processor<? super PsiFileSystemItem>)processor, scope, project);
        if (directories) {
            PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])result.toArray((Object[])new PsiFileSystemItem[0]);
            if (psiFileSystemItemArray == null) {
                FilenameIndex.$$$reportNull$$$0(36);
            }
            return psiFileSystemItemArray;
        }
        PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])result.toArray((Object[])PsiFile.EMPTY_ARRAY);
        if (psiFileSystemItemArray == null) {
            FilenameIndex.$$$reportNull$$$0(37);
        }
        return psiFileSystemItemArray;
    }

    @NotNull
    public static @Unmodifiable Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(38);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(39);
        }
        return FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    public static @Unmodifiable Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(40);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(41);
        }
        if (searchScope == null) {
            FilenameIndex.$$$reportNull$$$0(42);
        }
        if (ext.isEmpty()) {
            List list = Java11Shim.INSTANCE.listOf();
            if (list == null) {
                FilenameIndex.$$$reportNull$$$0(43);
            }
            return list;
        }
        String dotExt = "." + ext;
        int len = ext.length() + 1;
        HashSet<String> names = new HashSet<String>();
        FilenameIndex.processAllFileNames((Processor<? super String>)((Processor)name -> {
            int length = name.length();
            if (length > len && name.regionMatches(true, length - len, dotExt, 0, len)) {
                names.add((String)name);
            }
            return true;
        }), GlobalSearchScope.allScope((Project)project), null);
        return FilenameIndex.getVirtualFilesByNames(names, searchScope, null);
    }

    @NotNull
    private static @Unmodifiable Set<VirtualFile> getVirtualFilesByNames(@NotNull Set<String> names, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (names == null) {
            FilenameIndex.$$$reportNull$$$0(44);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(45);
        }
        Set files = CollectionFactory.createSmallMemoryFootprintSet();
        FileBasedIndex.getInstance().processFilesContainingAnyKey(NAME, names, scope, filter, null, new ProcessorWithThrottledCancellationCheck(file -> {
            files.add(file);
            return true;
        }));
        Set set = files;
        if (set == null) {
            FilenameIndex.$$$reportNull$$$0(46);
        }
        return set;
    }

    @ApiStatus.Experimental
    public static boolean hasVirtualFileWithName(@NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(47);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(48);
        }
        return !FilenameIndex.processFilesByNames(Set.of(name), caseSensitively, scope, filter, (Processor<? super VirtualFile>)((Processor)file -> false));
    }

    @ApiStatus.Experimental
    @Nullable
    public static VirtualFile firstVirtualFileWithName(@NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(49);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(50);
        }
        Ref found = new Ref(null);
        FilenameIndex.processFilesByNames(Set.of(name), caseSensitively, scope, filter, (Processor<? super VirtualFile>)((Processor)file -> {
            found.set(file);
            return false;
        }));
        return (VirtualFile)found.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 36, 37, 43, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 36: 
            case 37: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 2: 
            case 4: 
            case 18: 
            case 22: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 45: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 21: 
            case 25: 
            case 34: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: 
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilenames";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilesByExt";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesByNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilenames";
                break;
            }
            case 1: 
            case 36: 
            case 37: 
            case 43: 
            case 46: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllFileNames";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAllFileNameCharSequences";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processFilesByName";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processFilesByNames";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByNamesIgnoringCase";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilesByExt";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByNames";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasVirtualFileWithName";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "firstVirtualFileWithName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 36, 37, 43, 46 -> new IllegalStateException(string);
        };
    }
}

