/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.IndexPatternOptimizer;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexPattern {
    public static final IndexPattern[] EMPTY_ARRAY = new IndexPattern[0];
    @NotNull
    private String myPatternString;
    private Pattern myOptimizedIndexingPattern;
    private boolean myCaseSensitive;
    private Pattern myPattern;
    @NotNull
    private List<String> myStringsToFindFirst;

    public IndexPattern(@NotNull String patternString, boolean caseSensitive) {
        if (patternString == null) {
            IndexPattern.$$$reportNull$$$0(0);
        }
        this.myStringsToFindFirst = Collections.emptyList();
        this.myPatternString = patternString;
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    @NotNull
    @NlsSafe
    public String getPatternString() {
        String string = this.myPatternString;
        if (string == null) {
            IndexPattern.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public Pattern getPattern() {
        return this.myPattern;
    }

    @Nullable
    public Pattern getOptimizedIndexingPattern() {
        return this.myOptimizedIndexingPattern;
    }

    @NotNull
    public List<String> getWordsToFindFirst() {
        List<String> list = this.myStringsToFindFirst;
        if (list == null) {
            IndexPattern.$$$reportNull$$$0(2);
        }
        return list;
    }

    @ApiStatus.Experimental
    @Nullable
    public String getWordToHighlight() {
        List<String> words = this.getWordsToFindFirst();
        return words.isEmpty() ? null : words.get(0);
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public void setPatternString(@NotNull String patternString) {
        if (patternString == null) {
            IndexPattern.$$$reportNull$$$0(3);
        }
        this.myPatternString = patternString;
        this.compilePattern();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    private void compilePattern() {
        try {
            int flags = 0;
            if (!this.myCaseSensitive) {
                flags = 2;
                if (StringUtil.findFirst((CharSequence)this.myPatternString, c -> c >= '\u0080') >= 0) {
                    flags |= 0x40;
                }
            }
            this.myPattern = Pattern.compile(this.myPatternString, flags);
            String optimizedPattern = this.myPatternString;
            optimizedPattern = StringUtil.trimStart((String)optimizedPattern, (String)".*");
            this.myOptimizedIndexingPattern = Pattern.compile(optimizedPattern, flags);
            this.myStringsToFindFirst = IndexPatternOptimizer.getInstance().extractStringsToFind(this.myPatternString);
        }
        catch (PatternSyntaxException e) {
            this.myPattern = null;
            this.myOptimizedIndexingPattern = null;
            this.myStringsToFindFirst = Collections.emptyList();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof IndexPattern)) return false;
        IndexPattern ip = (IndexPattern)o;
        if (this.myCaseSensitive != ip.myCaseSensitive) return false;
        if (!this.myPatternString.equals(ip.myPatternString)) return false;
        return true;
    }

    public int hashCode() {
        return 29 * this.myPatternString.hashCode() + (this.myCaseSensitive ? 1 : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternString";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/IndexPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/IndexPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsToFindFirst";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPatternString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

