/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.RefactoringUiService;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameRefactoringDialog;
import com.intellij.refactoring.rename.RenameRefactoringDialogProvider;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.RenameUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class RenamePsiElementProcessorBase {
    public static final ExtensionPointName<RenamePsiElementProcessorBase> EP_NAME = ExtensionPointName.create((String)"com.intellij.renamePsiElementProcessor");
    public static final RenamePsiElementProcessorBase DEFAULT = new MyRenamePsiElementProcessorBase();

    public abstract boolean canProcessElement(@NotNull PsiElement var1);

    public RenameRefactoringDialog createDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(1);
        }
        for (RenameRefactoringDialogProvider dialogProvider : RenameRefactoringDialogProvider.EP_NAME.getExtensionList()) {
            if (!dialogProvider.isApplicable(this)) continue;
            return dialogProvider.createDialog(project, element, nameSuggestionContext, editor);
        }
        return RefactoringUiService.getInstance().createRenameRefactoringDialog(project, element, nameSuggestionContext, editor);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(4);
        }
        RenameUtil.doRenameGenericNamedElement(element, newName, usages, listener);
    }

    @Deprecated
    @NotNull
    public @Unmodifiable Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(5);
        }
        Collection<PsiReference> collection = this.findReferences(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), searchInCommentsAndStrings);
        if (collection == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Deprecated
    @NotNull
    public @Unmodifiable Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(7);
        }
        Collection<PsiReference> collection = this.findReferences(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), false);
        if (collection == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public @Unmodifiable Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(10);
        }
        Collection collection = ReferencesSearch.search(element, searchScope).findAll();
        if (collection == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(15);
        }
        return null;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(16);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(17);
        }
        if (allRenames == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(18);
        }
        this.prepareRenaming(element, newName, allRenames, PsiSearchHelper.getInstance(element.getProject()).getUseScope(element));
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(19);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(20);
        }
        if (allRenames == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(22);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(23);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(24);
        }
        if (conflicts == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(25);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(26);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(27);
        }
        if (conflicts == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(28);
        }
        if (allRenames == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(29);
        }
        this.findExistingNameConflicts(element, newName, conflicts);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    @NotNull
    public static RenamePsiElementProcessorBase forPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(30);
        }
        for (RenamePsiElementProcessorBase processor : EP_NAME.getExtensionList()) {
            if (!processor.canProcessElement(element)) continue;
            RenamePsiElementProcessorBase renamePsiElementProcessorBase = processor;
            if (renamePsiElementProcessorBase == null) {
                RenamePsiElementProcessorBase.$$$reportNull$$$0(31);
            }
            return renamePsiElementProcessorBase;
        }
        RenamePsiElementProcessorBase renamePsiElementProcessorBase = DEFAULT;
        if (renamePsiElementProcessorBase == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(32);
        }
        return renamePsiElementProcessorBase;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(33);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(34);
        }
        if (elementListener == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(35);
        }
        return null;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull Collection<UsageInfo> usages, @NotNull Map<PsiElement, String> allRenames, @NotNull RefactoringElementListener elementListener) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(36);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(37);
        }
        if (usages == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(38);
        }
        if (allRenames == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(39);
        }
        if (elementListener == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(40);
        }
        return this.getPostRenameCallback(element, newName, elementListener);
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        if (element instanceof PsiFile) {
            return "refactoring.renameFile";
        }
        return "refactoring.renameDialogs";
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(41);
        }
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(42);
        }
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(43);
        }
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(44);
        }
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
        }
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(45);
        }
        return true;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(46);
        }
        return element;
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        PsiElement psiElement;
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(47);
        }
        if (editor == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(48);
        }
        if (renameCallback == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(49);
        }
        if ((psiElement = this.substituteElementToRename(element, editor)) == null) {
            return;
        }
        if (!PsiElementRenameHandler.canRename(psiElement.getProject(), editor, psiElement)) {
            return;
        }
        renameCallback.accept((Object)psiElement);
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(50);
        }
        if (newName == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(51);
        }
        if (allRenames == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(52);
        }
        if (result == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(53);
        }
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(54);
        }
        return element;
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(55);
        }
        if (ref == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(56);
        }
        if (referenceElement == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(57);
        }
        UsageInfo usageInfo = RenameUtilBase.createMoveRenameUsageInfo((PsiElement)element, (PsiReference)ref, (PsiElement)referenceElement);
        if (usageInfo == null) {
            RenamePsiElementProcessorBase.$$$reportNull$$$0(58);
        }
        return usageInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 11, 31, 32, 58 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 24: 
            case 27: 
            case 34: 
            case 37: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 31: 
            case 32: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiElementProcessorBase";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 18: 
            case 21: 
            case 29: 
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementListener";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiElementProcessorBase";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "forPsiElement";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 31: 
            case 32: 
            case 58: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrenceSearchStrings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "forPsiElement";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "showRenamePreviewButton";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getElementToSearchInStringsAndComments";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 11, 31, 32, 58 -> new IllegalStateException(string);
        };
    }

    private static class MyRenamePsiElementProcessorBase
    extends RenamePsiElementProcessorBase
    implements DefaultRenamePsiElementProcessor {
        private MyRenamePsiElementProcessorBase() {
        }

        @Override
        public boolean canProcessElement(@NotNull PsiElement element) {
            if (element == null) {
                MyRenamePsiElementProcessorBase.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessorBase$MyRenamePsiElementProcessorBase", "canProcessElement"));
        }
    }

    public static interface DefaultRenamePsiElementProcessor {
    }
}

