/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.MathUtil;
import com.intellij.util.progress.SubTaskProgressIndicator;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConcurrentTasksProgressManager {
    private final ProgressIndicator myParent;
    private final int myTotalWeight;
    private final AtomicLong myTotalFraction;
    private final Object myLock = new Object();
    private final Object2ObjectLinkedOpenHashMap<SubTaskProgressIndicator, @NlsContexts.ProgressDetails String> myText2Stack = new Object2ObjectLinkedOpenHashMap();
    private final AtomicInteger myRemainingTotalWeight;

    public ConcurrentTasksProgressManager(ProgressIndicator parent, int totalWeight) {
        if (totalWeight < 0) {
            throw new IllegalArgumentException("Total weight must not be negative: " + totalWeight);
        }
        this.myParent = parent;
        this.myTotalWeight = totalWeight;
        this.myTotalFraction = new AtomicLong();
        this.myRemainingTotalWeight = new AtomicInteger(totalWeight);
    }

    @NotNull
    public SubTaskProgressIndicator createSubTaskIndicator(int taskWeight) {
        if (taskWeight < 0) {
            throw new IllegalArgumentException("Task weight must not be negative: " + taskWeight);
        }
        if (this.myRemainingTotalWeight.addAndGet(-taskWeight) < 0) {
            throw new IllegalStateException("Attempted to create more task indicators than registered in constructor");
        }
        return new SubTaskProgressIndicator(this, taskWeight);
    }

    @NotNull
    ProgressIndicator getParent() {
        ProgressIndicator progressIndicator = this.myParent;
        if (progressIndicator == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(0);
        }
        return progressIndicator;
    }

    void updateTaskFraction(double taskDeltaFraction, int taskWeight) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        double delta;
        double d = delta = this.myTotalWeight == 0 ? 0.0 : taskDeltaFraction * (double)taskWeight / (double)this.myTotalWeight;
        while (!this.myTotalFraction.compareAndSet(current = this.myTotalFraction.get(), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current)) + delta))) {
        }
        nextVal = MathUtil.clamp((double)nextVal, (double)0.0, (double)1.0);
        this.myParent.setFraction(nextVal);
    }

    public void setText(@NlsContexts.ProgressText @NotNull String text) {
        if (text == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(1);
        }
        this.myParent.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText2(@NotNull SubTaskProgressIndicator subTask, @NlsContexts.ProgressDetails @Nullable String text) {
        if (subTask == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(2);
        }
        if (text != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.put((Object)subTask, (Object)text);
            }
            this.myParent.setText2(text);
        } else {
            String prev;
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.remove((Object)subTask);
                prev = this.myText2Stack.isEmpty() ? null : (String)this.myText2Stack.get(this.myText2Stack.lastKey());
            }
            if (prev != null) {
                this.myParent.setText2(prev);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/progress/ConcurrentTasksProgressManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/progress/ConcurrentTasksProgressManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setText2";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

