/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chat.completion.feedback;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ml.llm.chat.completion.ChatInputCloudCompletionKit;
import com.intellij.ml.llm.chat.completion.feedback.ChatCompletionOnDisableInIdeFeedbackSurvey;
import com.intellij.ml.llm.chat.completion.feedback.ChatCompletionOptInSurveyConfig;
import com.intellij.ml.llm.chat.completion.feedback.ChatCompletionSurveyStateComponent;
import com.intellij.ml.llm.completion.cloud.kit.CloudCompletionLanguageKit;
import com.intellij.ml.llm.completion.cloud.settings.CompletionFeaturesOnChangeSettingsListener;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.FeedbackSurvey;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u001a\u0010\u0006\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u00072\u001a\u0010\u000b\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/chat/completion/feedback/ChatCompletionOnChangeSettingsListener;", "Lcom/intellij/ml/llm/completion/cloud/settings/CompletionFeaturesOnChangeSettingsListener;", "<init>", "()V", "onChanged", "", "prev", "", "Lkotlin/reflect/KClass;", "Lcom/intellij/ml/llm/completion/cloud/kit/CloudCompletionLanguageKit;", "", "current", "handleDisable", "getCurrentProject", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.chat.completion"})
public final class ChatCompletionOnChangeSettingsListener
implements CompletionFeaturesOnChangeSettingsListener {
    public void onChanged(@NotNull Map<KClass<? extends CloudCompletionLanguageKit>, Boolean> prev, @NotNull Map<KClass<? extends CloudCompletionLanguageKit>, Boolean> current) {
        Intrinsics.checkNotNullParameter(prev, (String)"prev");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        if (!ChatCompletionOptInSurveyConfig.INSTANCE.isIDESupported()) {
            return;
        }
        if (!prev.keySet().contains(Reflection.getOrCreateKotlinClass(ChatInputCloudCompletionKit.class)) || !current.keySet().contains(Reflection.getOrCreateKotlinClass(ChatInputCloudCompletionKit.class))) {
            return;
        }
        if (!ChatCompletionSurveyStateComponent.Companion.getInstance().isOnDisableTrackActive()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)prev.get(Reflection.getOrCreateKotlinClass(ChatInputCloudCompletionKit.class)), (Object)true) || !Intrinsics.areEqual((Object)current.get(Reflection.getOrCreateKotlinClass(ChatInputCloudCompletionKit.class)), (Object)false)) {
            return;
        }
        this.handleDisable();
    }

    private final void handleDisable() {
        Project project = this.getCurrentProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ChatCompletionSurveyStateComponent.Companion.getInstance().fireDisabled();
        if (ChatCompletionSurveyStateComponent.Companion.getInstance().isOnDisableTrackActive()) {
            FeedbackSurvey.showNotification$default((FeedbackSurvey)new ChatCompletionOnDisableInIdeFeedbackSurvey(), (Project)project2, (boolean)false, (int)2, null);
            ChatCompletionSurveyStateComponent.Companion.getInstance().fireOnDisableNotificationShown();
        }
    }

    private final Project getCurrentProject() {
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Project project = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            project = ProjectUtil.getActiveProject();
        }
        return project;
    }
}

