/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chat.completion.feedback;

import com.intellij.ml.llm.chat.completion.feedback.ChatCompletionFeedbackSystemData;
import com.intellij.ml.llm.chat.completion.feedback.ChatCompletionOnDisableSurveyDialog;
import com.intellij.ml.llm.chat.completion.feedback.ChatCompletionSurveyStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/chat/completion/feedback/ChatCompletionOnDisableSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/ml/llm/chat/completion/feedback/ChatCompletionFeedbackSystemData;", "forTest", "updateStateAfterDialogClosedOk", "", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterNotificationShowed", "intellij.ml.llm.chat.completion"})
public final class ChatCompletionOnDisableSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    public static final ChatCompletionOnDisableSurveyConfig INSTANCE = new ChatCompletionOnDisableSurveyConfig();
    @NotNull
    private static final String surveyId = "completion_chat_ondisable_survey";
    @NotNull
    private static final LocalDate lastDayOfFeedbackCollection = new LocalDate(2026, 1, 25);
    private static final boolean requireIdeEAP;

    private ChatCompletionOnDisableSurveyConfig() {
    }

    @NotNull
    public String getSurveyId() {
        return surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return !ChatCompletionSurveyStateComponent.Companion.getInstance().isOptInTrackActive();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.checkIdeIsSuitable()) {
            return false;
        }
        boolean isOnDisableTrackActive = ChatCompletionSurveyStateComponent.Companion.getInstance().isOnDisableTrackActive();
        return isOnDisableTrackActive && ChatCompletionSurveyStateComponent.Companion.getInstance().getState().getExplicitlyDisabled();
    }

    @NotNull
    public BlockBasedFeedbackDialog<ChatCompletionFeedbackSystemData> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ChatCompletionOnDisableSurveyDialog(project, forTest);
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChatCompletionSurveyStateComponent.Companion.getInstance().fireOnDisableNotificationShown();
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new RequestFeedbackNotification("Full Line Completion Plugin", "Thank you for trying the Chat Completion!", "To help us improve the product, please share your feedback with us.");
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ChatCompletionSurveyStateComponent.Companion.getInstance().fireOnDisableNotificationShown();
    }
}

