/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrencyUtils;
import com.intellij.concurrency.Job;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.util.Processor;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class JobLauncher {
    public static JobLauncher getInstance() {
        return (JobLauncher)ApplicationManager.getApplication().getService(JobLauncher.class);
    }

    public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress, @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        if (things == null) {
            JobLauncher.$$$reportNull$$$0(0);
        }
        if (thingProcessor == null) {
            JobLauncher.$$$reportNull$$$0(1);
        }
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        return this.invokeConcurrentlyUnderProgress(things, progress, app.isReadAccessAllowed(), app.isInImpatientReader(), thingProcessor);
    }

    public <T> boolean invokeConcurrentlyUnderContextProgress(@NotNull List<? extends T> things, @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        if (things == null) {
            JobLauncher.$$$reportNull$$$0(2);
        }
        if (thingProcessor == null) {
            JobLauncher.$$$reportNull$$$0(3);
        }
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        return ConcurrencyUtils.runWithIndicatorOrContextCancellation(indicator -> this.invokeConcurrentlyUnderProgress(things, ProgressIndicatorProvider.getGlobalProgressIndicator(), app.isReadAccessAllowed(), app.isInImpatientReader(), thingProcessor));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        if (things == null) {
            JobLauncher.$$$reportNull$$$0(4);
        }
        if (thingProcessor == null) {
            JobLauncher.$$$reportNull$$$0(5);
        }
        PluginException.reportDeprecatedUsage((String)"invokeConcurrentlyUnderProgress", (String)"do not use");
        return this.invokeConcurrentlyUnderProgress(things, progress, ApplicationManager.getApplication().isReadAccessAllowed(), failFastOnAcquireReadAction, thingProcessor);
    }

    public abstract <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> var1, ProgressIndicator var2, boolean var3, boolean var4, @NotNull Processor<? super T> var5) throws ProcessCanceledException;

    @ApiStatus.Internal
    @NotNull
    public abstract Job submitToJobThread(@NotNull Runnable var1, @Nullable Consumer<? super Future<?>> var2);

    @ApiStatus.Internal
    public <T> boolean processConcurrentlyAsync(@NotNull ProgressIndicator progress, @NotNull List<? extends T> items, @NotNull Processor<? super T> thingProcessor, @NotNull Runnable runnable) throws ProcessCanceledException {
        if (progress == null) {
            JobLauncher.$$$reportNull$$$0(6);
        }
        if (items == null) {
            JobLauncher.$$$reportNull$$$0(7);
        }
        if (thingProcessor == null) {
            JobLauncher.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            JobLauncher.$$$reportNull$$$0(9);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "things";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thingProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/concurrency/JobLauncher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeConcurrentlyUnderProgress";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeConcurrentlyUnderContextProgress";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processConcurrentlyAsync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

