/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.openapi.extensions.PluginId;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/plugins/PluginDependencyAnalysis;", "", "<init>", "()V", "BFS", "DependencyRef", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginDependencyAnalysis {
    @NotNull
    public static final PluginDependencyAnalysis INSTANCE = new PluginDependencyAnalysis();

    private PluginDependencyAnalysis() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\u0013\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0014R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/plugins/PluginDependencyAnalysis$BFS;", "V", "", "<init>", "()V", "visited", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "queue", "Lkotlin/collections/ArrayDeque;", "isVisited", "", "node", "(Ljava/lang/Object;)Z", "getVisitedSet", "", "schedule", "run", "", "visit", "(Ljava/lang/Object;)V", "intellij.platform.core.impl"})
    @VisibleForTesting
    public static abstract class BFS<V> {
        @NotNull
        private final LinkedHashSet<V> visited = new LinkedHashSet();
        @NotNull
        private final ArrayDeque<V> queue = new ArrayDeque();

        public final boolean isVisited(V node) {
            return this.visited.contains(node);
        }

        @NotNull
        public final Set<V> getVisitedSet() {
            return this.visited;
        }

        public final boolean schedule(V node) {
            if (!this.visited.contains(node)) {
                this.queue.addLast(node);
                return true;
            }
            return false;
        }

        public final void run() {
            while (!((Collection)this.queue).isEmpty()) {
                Object node = this.queue.removeFirst();
                if (this.visited.contains(node)) continue;
                this.visited.add(node);
                this.visit(node);
            }
        }

        public abstract void visit(V var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/plugins/PluginDependencyAnalysis$DependencyRef;", "", "<init>", "()V", "Plugin", "ContentModule", "Lcom/intellij/ide/plugins/PluginDependencyAnalysis$DependencyRef$ContentModule;", "Lcom/intellij/ide/plugins/PluginDependencyAnalysis$DependencyRef$Plugin;", "intellij.platform.core.impl"})
    @ApiStatus.Internal
    public static abstract class DependencyRef {
        private DependencyRef() {
        }

        public /* synthetic */ DependencyRef(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/plugins/PluginDependencyAnalysis$DependencyRef$ContentModule;", "Lcom/intellij/ide/plugins/PluginDependencyAnalysis$DependencyRef;", "moduleId", "Lcom/intellij/ide/plugins/PluginModuleId;", "<init>", "(Lcom/intellij/ide/plugins/PluginModuleId;)V", "getModuleId", "()Lcom/intellij/ide/plugins/PluginModuleId;", "intellij.platform.core.impl"})
        public static final class ContentModule
        extends DependencyRef {
            @NotNull
            private final PluginModuleId moduleId;

            public ContentModule(@NotNull PluginModuleId moduleId) {
                Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
                super(null);
                this.moduleId = moduleId;
            }

            @NotNull
            public final PluginModuleId getModuleId() {
                return this.moduleId;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/plugins/PluginDependencyAnalysis$DependencyRef$Plugin;", "Lcom/intellij/ide/plugins/PluginDependencyAnalysis$DependencyRef;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "<init>", "(Lcom/intellij/openapi/extensions/PluginId;)V", "getPluginId", "()Lcom/intellij/openapi/extensions/PluginId;", "intellij.platform.core.impl"})
        public static final class Plugin
        extends DependencyRef {
            @NotNull
            private final PluginId pluginId;

            public Plugin(@NotNull PluginId pluginId) {
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                super(null);
                this.pluginId = pluginId;
            }

            @NotNull
            public final PluginId getPluginId() {
                return this.pluginId;
            }
        }
    }
}

