/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.DispatchedRunnable;
import com.intellij.openapi.application.impl.EdtCoroutineDispatcherKt;
import com.intellij.openapi.application.impl.EdtDispatcherKind;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.MainCoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000eH\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0017\u001a\u00060\u0010j\u0002`\u0011H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u0082\u0001\u0005\u001f !\"#\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher;", "Lkotlinx/coroutines/MainCoroutineDispatcher;", "type", "Lcom/intellij/openapi/application/impl/EdtDispatcherKind;", "<init>", "(Lcom/intellij/openapi/application/impl/EdtDispatcherKind;)V", "getType", "()Lcom/intellij/openapi/application/impl/EdtDispatcherKind;", "immediate", "getImmediate", "()Lkotlinx/coroutines/MainCoroutineDispatcher;", "dispatch", "", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "effectiveContextModality", "Lcom/intellij/openapi/application/ModalityState;", "toString", "", "wrapWithLocking", "runnable", "lockAccessViolationMessage", "getLockAccessViolationMessage", "()Ljava/lang/String;", "LockWrapping", "NonLocking", "LockForbidden", "Main", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$LockForbidden;", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$LockWrapping;", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$Main;", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$NonLocking;", "Lcom/intellij/openapi/application/impl/ImmediateEdtCoroutineDispatcher;", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nEdtCoroutineDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EdtCoroutineDispatcher.kt\ncom/intellij/openapi/application/impl/EdtCoroutineDispatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n13#2:190\n*S KotlinDebug\n*F\n+ 1 EdtCoroutineDispatcher.kt\ncom/intellij/openapi/application/impl/EdtCoroutineDispatcher\n*L\n54#1:190\n*E\n"})
public abstract class EdtCoroutineDispatcher
extends MainCoroutineDispatcher {
    @NotNull
    private final EdtDispatcherKind type;
    @NotNull
    private final String lockAccessViolationMessage;

    private EdtCoroutineDispatcher(EdtDispatcherKind type) {
        this.type = type;
        this.lockAccessViolationMessage = "The use of the RW lock is forbidden by `" + (Object)((Object)this) + "`. This dispatcher is intended for pure UI operations, which do not interact with the IntelliJ Platform model (PSI, VFS, etc.).\nThe following solutions are available:\n1. Consider moving the model access outside `" + (Object)((Object)this) + "`. This would help to ensure that the UI is responsive.\n2. Consider using legacy `Dispatchers.EDT` that permits usage of the RW lock.\n";
    }

    @NotNull
    protected final EdtDispatcherKind getType() {
        return this.type;
    }

    @NotNull
    public MainCoroutineDispatcher getImmediate() {
        MainCoroutineDispatcher mainCoroutineDispatcher;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                mainCoroutineDispatcher = EdtCoroutineDispatcherKt.access$getImmediateEdtDispatcher$p();
                break;
            }
            case 2: {
                mainCoroutineDispatcher = EdtCoroutineDispatcherKt.access$getImmediateLaxUiDispatcher$p();
                break;
            }
            case 3: {
                mainCoroutineDispatcher = EdtCoroutineDispatcherKt.access$getImmediateUiDispatcher$p();
                break;
            }
            case 4: {
                mainCoroutineDispatcher = EdtCoroutineDispatcherKt.access$getImmediateMainDispatcher$p();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mainCoroutineDispatcher;
    }

    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        try {
            if (!(!CoroutinesKt.isRunBlockingUnderReadAction((CoroutineContext)context))) {
                boolean $i$a$-check-EdtCoroutineDispatcher$dispatch$22 = false;
                String $i$a$-check-EdtCoroutineDispatcher$dispatch$22 = "Switching to `" + (Object)((Object)this) + "` from `runBlockingCancellable` inside in a read-action leads to possible deadlock.";
                throw new IllegalStateException($i$a$-check-EdtCoroutineDispatcher$dispatch$22.toString());
            }
            Runnable lockingAwareBlock = this.wrapWithLocking(block);
            ModalityState state2 = this.effectiveContextModality(context);
            ContextAwareRunnable runnable = state2 == ModalityState.any() ? lockingAwareBlock::run : (ContextAwareRunnable)new DispatchedRunnable(JobKt.getJob((CoroutineContext)context), lockingAwareBlock);
            boolean useWeakWriteIntent = this.type.getLockBehavior() == EdtDispatcherKind.LockBehavior.LOCKS_ALLOWED_MANDATORY_WRAPPING;
            ApplicationManagerEx.getApplicationEx().dispatchCoroutineOnEDT((Runnable)runnable, state2, useWeakWriteIntent);
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(EdtCoroutineDispatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Critical error during `dispatch` of EDT coroutine. Some coroutines may be lost.", e);
            throw e;
        }
    }

    @NotNull
    protected final ModalityState effectiveContextModality(@NotNull CoroutineContext $this$effectiveContextModality) {
        Intrinsics.checkNotNullParameter((Object)$this$effectiveContextModality, (String)"<this>");
        ModalityState modalityState = ModalityKt.contextModality((CoroutineContext)$this$effectiveContextModality);
        if (modalityState == null) {
            modalityState = this.type.getFallbackModality().toModalityState();
        }
        return modalityState;
    }

    @NotNull
    public String toString() {
        return this.type.presentableName();
    }

    private final Runnable wrapWithLocking(Runnable runnable) {
        Runnable runnable2;
        switch (WhenMappings.$EnumSwitchMapping$1[this.type.getLockBehavior().ordinal()]) {
            case 1: {
                runnable2 = () -> EdtCoroutineDispatcher.wrapWithLocking$lambda$0(runnable, this);
                break;
            }
            case 2: 
            case 3: {
                runnable2 = runnable;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return runnable2;
    }

    @NotNull
    public final String getLockAccessViolationMessage() {
        return this.lockAccessViolationMessage;
    }

    private static final void wrapWithLocking$lambda$0(Runnable $runnable, EdtCoroutineDispatcher this$0) {
        ApplicationManagerEx.getApplicationEx().prohibitTakingLocksInsideAndRun($runnable, this$0.lockAccessViolationMessage);
    }

    public /* synthetic */ EdtCoroutineDispatcher(EdtDispatcherKind type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$LockForbidden;", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher;", "<init>", "()V", "intellij.platform.core.impl"})
    public static final class LockForbidden
    extends EdtCoroutineDispatcher {
        @NotNull
        public static final LockForbidden INSTANCE = new LockForbidden();

        private LockForbidden() {
            super(EdtDispatcherKind.UI, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$LockWrapping;", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher;", "<init>", "()V", "intellij.platform.core.impl"})
    public static final class LockWrapping
    extends EdtCoroutineDispatcher {
        @NotNull
        public static final LockWrapping INSTANCE = new LockWrapping();

        private LockWrapping() {
            super(EdtDispatcherKind.EDT, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$Main;", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher;", "<init>", "()V", "intellij.platform.core.impl"})
    public static final class Main
    extends EdtCoroutineDispatcher {
        @NotNull
        public static final Main INSTANCE = new Main();

        private Main() {
            super(EdtDispatcherKind.MAIN, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher$NonLocking;", "Lcom/intellij/openapi/application/impl/EdtCoroutineDispatcher;", "<init>", "()V", "intellij.platform.core.impl"})
    public static final class NonLocking
    extends EdtCoroutineDispatcher {
        @NotNull
        public static final NonLocking INSTANCE = new NonLocking();

        private NonLocking() {
            super(EdtDispatcherKind.LAX_UI, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[EdtDispatcherKind.values().length];
            try {
                nArray[EdtDispatcherKind.EDT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EdtDispatcherKind.LAX_UI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EdtDispatcherKind.UI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EdtDispatcherKind.MAIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EdtDispatcherKind.LockBehavior.values().length];
            try {
                nArray[EdtDispatcherKind.LockBehavior.LOCKS_DISALLOWED_FAIL_HARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EdtDispatcherKind.LockBehavior.LOCKS_ALLOWED_NO_WRAPPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EdtDispatcherKind.LockBehavior.LOCKS_ALLOWED_MANDATORY_WRAPPING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

