/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentFullUpdateListener;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface DocumentEx
extends Document {
    default public void setStripTrailingSpacesEnabled(boolean isEnabled) {
    }

    @NotNull
    public LineIterator createLineIterator();

    public void setModificationStamp(long var1);

    default public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            DocumentEx.$$$reportNull$$$0(0);
        }
    }

    default public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            DocumentEx.$$$reportNull$$$0(1);
        }
    }

    @ApiStatus.Internal
    default public void addFullUpdateListener(DocumentFullUpdateListener listener) {
    }

    @ApiStatus.Internal
    default public void removeFullUpdateListener(DocumentFullUpdateListener listener) {
    }

    public void replaceText(@NotNull CharSequence var1, long var2);

    default public void moveText(int srcStart, int srcEnd, int dstOffset) {
        if (!1.$assertionsDisabled && (srcStart > srcEnd || dstOffset > srcStart && dstOffset < srcEnd)) {
            throw new AssertionError();
        }
        if (srcStart < srcEnd && (dstOffset < srcStart || dstOffset > srcEnd)) {
            String fragment = this.getText(new TextRange(srcStart, srcEnd));
            this.insertString(dstOffset, fragment);
            int shift = dstOffset < srcStart ? srcEnd - srcStart : 0;
            this.deleteString(srcStart + shift, srcEnd + shift);
        }
    }

    default public void suppressGuardedExceptions() {
    }

    default public void unSuppressGuardedExceptions() {
    }

    default public boolean isInEventsHandling() {
        return false;
    }

    default public void clearLineModificationFlags() {
    }

    public boolean removeRangeMarker(@NotNull RangeMarkerEx var1);

    public void registerRangeMarker(@NotNull RangeMarkerEx var1, int var2, int var3, boolean var4, boolean var5, int var6);

    @NotNull
    default public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = Collections.emptyList();
        if (list == null) {
            DocumentEx.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> var1);

    public boolean processRangeMarkersOverlappingWith(int var1, int var2, @NotNull Processor<? super RangeMarker> var3);

    default public int getModificationSequence() {
        return 0;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/DocumentEx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/DocumentEx";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuardedBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addEditReadOnlyListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

