/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTree;
import com.intellij.openapi.editor.impl.MutableInterval;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.VarHandleWrapper;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class IntervalTreeImpl<T extends RangeMarkerEx>
extends RedBlackTree<T>
implements IntervalTree<T> {
    static final Logger LOG = Logger.getInstance(IntervalTreeImpl.class);
    static final boolean DEBUG = LOG.isDebugEnabled() || ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    private int keySize;
    private final ReentrantReadWriteLock l = new ReentrantReadWriteLock();
    private final ReferenceQueue<T> myReferenceQueue = new ReferenceQueue();
    private int deadReferenceCount;
    private boolean firingRemove;
    private static final AtomicInteger occupiedTasteFlags = new AtomicInteger();

    protected abstract int compareEqualStartIntervals(@NotNull IntervalNode<T> var1, @NotNull IntervalNode<T> var2);

    <E> E runUnderWriteLock(@NotNull Supplier<? extends E> runnable) {
        if (runnable == null) {
            IntervalTreeImpl.$$$reportNull$$$0(0);
        }
        if (this.l.getReadHoldCount() > 0) {
            throw new IllegalStateException("Must not perform modifications while holding read lock/iterating");
        }
        this.l.writeLock().lock();
        try {
            E e = runnable.get();
            return e;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    @ApiStatus.Internal
    protected void runUnderWriteLock(@NotNull Runnable runnable) {
        if (runnable == null) {
            IntervalTreeImpl.$$$reportNull$$$0(1);
        }
        this.runUnderWriteLock(() -> {
            runnable.run();
            return null;
        });
    }

    @NotNull
    private Supplier<? extends T> createGetter(@NotNull T interval) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(2);
        }
        Supplier supplier = this.keepIntervalOnWeakReference(interval) ? new WeakReferencedGetter(interval, this.myReferenceQueue) : (Supplier)interval;
        if (supplier == null) {
            IntervalTreeImpl.$$$reportNull$$$0(3);
        }
        return supplier;
    }

    void assertUnderWriteLock() {
        assert (this.l.isWriteLockedByCurrentThread()) : this.l.writeLock();
    }

    protected void assertMayModify() throws IllegalStateException {
        if (this.l.getReadHoldCount() != 0) {
            throw new IllegalStateException("Must not perform modifications while holding read lock/iterating");
        }
    }

    private void pushDeltaFromRoot(@Nullable IntervalNode<T> node) {
        if (node != null) {
            long packedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
            if (IntervalNode.allDeltasUpAreNull(packedOffsets) && node.isValid() && IntervalNode.modCount(packedOffsets) == this.getModCount()) {
                return;
            }
            this.pushDeltaFromRoot((IntervalNode<T>)node.getParent());
            this.pushDelta(node);
        }
    }

    protected boolean keepIntervalOnWeakReference(@NotNull T interval) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    protected abstract IntervalNode<T> createNewNode(@NotNull T var1, int var2, int var3, boolean var4, boolean var5, boolean var6, int var7);

    protected abstract IntervalNode<T> lookupNode(@NotNull T var1);

    protected abstract void setNode(@NotNull T var1, @Nullable IntervalNode<T> var2);

    private int compareNodes(@NotNull IntervalNode<T> i1, int delta1, @NotNull IntervalNode<T> i2, int delta2, @NotNull List<? super IntervalNode<T>> invalid) {
        int start2;
        int start1;
        if (i1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(5);
        }
        if (i2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(6);
        }
        if (invalid == null) {
            IntervalTreeImpl.$$$reportNull$$$0(7);
        }
        if (!i2.hasAliveKey(false)) {
            invalid.add(i2);
        }
        if ((start1 = i1.intervalStart() + delta1) != (start2 = i2.intervalStart() + delta2)) {
            return start1 - start2;
        }
        return this.compareEqualStartIntervals(i1, i2);
    }

    protected IntervalNode<T> getRoot() {
        return (IntervalNode)this.root;
    }

    @Override
    public boolean processAll(@NotNull Processor<? super T> processor) {
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(8);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.process(this.getRoot(), this.getModCount(), processor);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean process(@Nullable IntervalNode<T> root, int modCountBefore, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(9);
        }
        if (root == null) {
            return true;
        }
        WalkingState.TreeGuide guide = IntervalTreeGuide.getGuide();
        return WalkingState.processAll(root, (WalkingState.TreeGuide)guide, node -> {
            if (!node.processAliveKeys(processor)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processOverlappingWith(int start, int end, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(10);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWith(this.getRoot(), start, end, this.getModCount(), 0, processor);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWith(@Nullable IntervalNode<T> root, int start, int end, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor) {
        boolean overlaps;
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(11);
        }
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (start > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processOverlappingWith((IntervalNode<T>)root.getLeft(), start, end, modCountBefore, delta, processor)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, start) <= Math.min(myEndOffset, end);
        if (overlaps) {
            if (!root.processAliveKeys((Processor<T>)processor)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (end < myStartOffset) {
            return true;
        }
        return this.processOverlappingWith((IntervalNode<T>)root.getRight(), start, end, modCountBefore, delta, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processOverlappingWithOutside(int start, int end, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(12);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWithOutside(this.getRoot(), start, end, this.getModCount(), 0, processor);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWithOutside(@Nullable IntervalNode<T> root, int start, int end, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor) {
        boolean toProcess;
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(13);
        }
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        int rootMaxEnd = this.maxEndOf(root, deltaUpToRootExclusive);
        int rootStartOffset = root.intervalStart() + delta;
        int rootEndOffset = root.intervalEnd() + delta;
        if (!this.processOverlappingWithOutside((IntervalNode<T>)root.getLeft(), start, end, modCountBefore, delta, processor)) {
            return false;
        }
        boolean bl = toProcess = rootStartOffset < start || rootEndOffset > end;
        if (toProcess) {
            if (!root.processAliveKeys((Processor<T>)processor)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (rootStartOffset >= start && rootMaxEnd <= end) {
            return true;
        }
        return this.processOverlappingWithOutside((IntervalNode<T>)root.getRight(), start, end, modCountBefore, delta, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processContaining(int offset, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(14);
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processContaining(this.getRoot(), offset, this.getModCount(), 0, processor);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processContaining(@Nullable IntervalNode<T> root, int offset, int modCountBefore, int deltaUpToRootExclusive, @NotNull Processor<? super T> processor) {
        boolean overlaps;
        if (processor == null) {
            IntervalTreeImpl.$$$reportNull$$$0(15);
        }
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (offset > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processContaining((IntervalNode<T>)root.getLeft(), offset, modCountBefore, delta, processor)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = myStartOffset <= offset && offset < myEndOffset;
        if (overlaps) {
            if (!root.processAliveKeys((Processor<T>)processor)) {
                return false;
            }
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (offset < myStartOffset) {
            return true;
        }
        return this.processContaining((IntervalNode<T>)root.getRight(), offset, modCountBefore, delta, processor);
    }

    @NotNull
    @ApiStatus.Internal
    protected MarkupIterator<T> overlappingIterator(@NotNull TextRange rangeInterval) {
        if (rangeInterval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(16);
        }
        return this.overlappingIterator(rangeInterval, (byte)0);
    }

    @NotNull
    private MarkupIterator<T> overlappingIterator(final @NotNull TextRange rangeInterval, final byte tastePreference) {
        IntervalNode<T> firstOverlap;
        int modCountBefore;
        int endOffset;
        int startOffset;
        block6: {
            if (rangeInterval == null) {
                IntervalTreeImpl.$$$reportNull$$$0(17);
            }
            this.l.readLock().lock();
            startOffset = rangeInterval.getStartOffset();
            endOffset = rangeInterval.getEndOffset();
            modCountBefore = this.getModCount();
            firstOverlap = this.findMinOverlappingWith(this.getRoot(), rangeInterval, 0, tastePreference);
            if (this.getModCount() != modCountBefore) {
                throw new ConcurrentModificationException();
            }
            if (firstOverlap != null) break block6;
            this.l.readLock().unlock();
            MarkupIterator markupIterator = MarkupIterator.emptyIterator();
            if (markupIterator == null) {
                IntervalTreeImpl.$$$reportNull$$$0(18);
            }
            return markupIterator;
        }
        try {
            final int firstOverlapDelta = firstOverlap.computeDeltaUpToRoot();
            final int firstOverlapStart = firstOverlap.intervalStart() + firstOverlapDelta;
            return new MarkupIterator<T>(){
                private IntervalNode<T> currentNode;
                private int deltaUpToRootExclusive;
                private int indexInCurrentList;
                private T current;
                {
                    this.currentNode = firstOverlap;
                    this.deltaUpToRootExclusive = firstOverlapDelta - firstOverlap.delta;
                }

                public boolean hasNext() {
                    if (this.current != null) {
                        return true;
                    }
                    if (this.currentNode == null) {
                        return false;
                    }
                    if (IntervalTreeImpl.this.getModCount() != modCountBefore) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.nextIntervalInNode()) {
                        return true;
                    }
                    while (true) {
                        this.currentNode = this.nextNode(this.currentNode);
                        if (this.currentNode == null) {
                            return false;
                        }
                        if (!IntervalTreeImpl.this.overlaps(this.currentNode, rangeInterval, this.deltaUpToRootExclusive)) continue;
                        assert (this.currentNode.intervalStart() + this.deltaUpToRootExclusive + this.currentNode.delta >= firstOverlapStart);
                        this.indexInCurrentList = 0;
                        if (this.nextIntervalInNode()) break;
                    }
                    return true;
                }

                private boolean nextIntervalInNode() {
                    if (!this.currentNode.hasDeliciousIntervalsInside(tastePreference)) {
                        return false;
                    }
                    List intervals = this.currentNode.intervals;
                    while (this.indexInCurrentList < intervals.size()) {
                        RangeMarkerEx t = (RangeMarkerEx)intervals.get(this.indexInCurrentList).get();
                        ++this.indexInCurrentList;
                        if (t == null || !IntervalTreeImpl.this.isDeliciousInterval(t, tastePreference)) continue;
                        this.current = t;
                        return true;
                    }
                    this.indexInCurrentList = 0;
                    return false;
                }

                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object t = this.current;
                    this.current = null;
                    return t;
                }

                public T peek() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.current;
                }

                public void remove() {
                    throw new IncorrectOperationException();
                }

                @Override
                public void dispose() {
                    IntervalTreeImpl.this.l.readLock().unlock();
                }

                private IntervalNode<T> nextNode(@NotNull IntervalNode<T> root) {
                    int rightMaxEnd;
                    if (root == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    assert (root.isValid()) : root;
                    int delta = this.deltaUpToRootExclusive + root.delta;
                    int myMaxEnd = IntervalTreeImpl.this.maxEndOf(root, this.deltaUpToRootExclusive);
                    if (startOffset > myMaxEnd) {
                        return null;
                    }
                    RedBlackTree.Node right = root.getRight();
                    if (right != null && ((IntervalNode)right).hasDeliciousIntervalsBeneath(tastePreference) && startOffset <= (rightMaxEnd = IntervalTreeImpl.this.maxEndOf((IntervalNode)right, delta))) {
                        RedBlackTree.Node left;
                        int rightDelta = delta + ((IntervalNode)right).delta;
                        while ((left = ((IntervalNode)right).getLeft()) != null && startOffset <= IntervalTreeImpl.this.maxEndOf((IntervalNode)left, rightDelta) && ((IntervalNode)left).hasDeliciousIntervalsBeneath(tastePreference)) {
                            right = left;
                            rightDelta += ((IntervalNode)right).delta;
                        }
                        this.deltaUpToRootExclusive = rightDelta - ((IntervalNode)right).delta;
                        return right;
                    }
                    RedBlackTree.Node parent;
                    while ((parent = root.getParent()) != null) {
                        if (((IntervalNode)parent).intervalStart() + this.deltaUpToRootExclusive > endOffset) {
                            return null;
                        }
                        this.deltaUpToRootExclusive -= ((IntervalNode)parent).delta;
                        if (((IntervalNode)parent).getLeft() == root) {
                            return parent;
                        }
                        root = parent;
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/editor/impl/IntervalTreeImpl$1", "nextNode"));
                }
            };
        }
        catch (Error | RuntimeException e) {
            this.l.readLock().unlock();
            throw e;
        }
    }

    @ApiStatus.Internal
    protected MarkupIterator<T> overlappingDeliciousIterator(@NotNull TextRange range, byte tastePreference) {
        if (range == null) {
            IntervalTreeImpl.$$$reportNull$$$0(19);
        }
        return this.overlappingIterator(range, tastePreference);
    }

    private boolean overlaps(@Nullable IntervalNode<T> root, @NotNull TextRange rangeInterval, int deltaUpToRootExclusive) {
        if (rangeInterval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(20);
        }
        if (root == null) {
            return false;
        }
        int delta = root.delta + deltaUpToRootExclusive;
        int start = root.intervalStart() + delta;
        int end = root.intervalEnd() + delta;
        return rangeInterval.intersects(start, end);
    }

    @NotNull
    IntervalNode<T> findOrInsert(@NotNull IntervalNode<T> node) {
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(21);
        }
        this.assertUnderWriteLock();
        node.setRed();
        node.setParent(null);
        node.setValid(true);
        node.maxEnd = 0;
        node.clearDelta();
        node.setLeft(null);
        node.setRight(null);
        SmartList gced = new SmartList();
        if (this.root == null) {
            this.root = node;
        } else {
            RedBlackTree.Node current = this.getRoot();
            while (true) {
                this.pushDelta((IntervalNode<T>)current);
                int compResult = this.compareNodes(node, 0, (IntervalNode<T>)current, 0, (List<? super IntervalNode<T>>)gced);
                if (compResult == 0) {
                    IntervalNode<T> intervalNode = current;
                    if (intervalNode == null) {
                        IntervalTreeImpl.$$$reportNull$$$0(22);
                    }
                    return intervalNode;
                }
                if (compResult < 0) {
                    if (current.getLeft() == null) {
                        current.setLeft(node);
                        break;
                    }
                    current = current.getLeft();
                    continue;
                }
                if (current.getRight() == null) {
                    current.setRight(node);
                    break;
                }
                current = current.getRight();
            }
            node.setParent(current);
        }
        ((IntervalNode)node).setCachedValues(0, true, this.getModCount());
        this.correctMaxUp(node);
        this.onInsertNode();
        this.keySize += node.intervals.size();
        this.insertCase1(node);
        ((IntervalNode)node).setAttachedToTree(true);
        ((IntervalNode)node).updateTaste();
        ((IntervalNode)node).updateTasteFromChildrenUp();
        this.verifyProperties();
        this.deleteNodes((List<? extends IntervalNode<T>>)gced);
        IntervalNode<T> intervalNode = node;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(23);
        }
        return intervalNode;
    }

    private void deleteNodes(@NotNull List<? extends IntervalNode<T>> collectedAway) {
        if (collectedAway == null) {
            IntervalTreeImpl.$$$reportNull$$$0(24);
        }
        if (collectedAway.isEmpty()) {
            return;
        }
        this.runUnderWriteLock(() -> {
            for (IntervalNode node : collectedAway) {
                this.removeNode(node);
            }
        });
    }

    protected byte getTasteFlags(@NotNull T interval) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(25);
        }
        return 0;
    }

    @NotNull
    protected IntervalNode<T> addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(26);
        }
        IntervalNode intervalNode = this.runUnderWriteLock(() -> {
            if (this.firingRemove) {
                throw new IncorrectOperationException("Must not add range marker from within removed() listener");
            }
            this.checkMax(true);
            this.processReferenceQueue();
            this.incModCount();
            IntervalNode<RangeMarkerEx> newNode = this.createNewNode(interval, start, end, greedyToLeft, greedyToRight, stickingToRight, layer);
            IntervalNode<RangeMarkerEx> insertedNode = this.findOrInsert(newNode);
            if (insertedNode == newNode) {
                this.setNode(interval, insertedNode);
            } else {
                insertedNode.addInterval((RangeMarkerEx)interval);
            }
            byte taste = this.getTasteFlags(interval);
            ((IntervalNode)insertedNode).taste = (byte)(((IntervalNode)insertedNode).taste | taste);
            ((IntervalNode)insertedNode).updateTasteFromChildrenUp();
            this.checkMax(true);
            this.checkBelongsToTheTree(interval, true);
            return insertedNode;
        });
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(27);
        }
        return intervalNode;
    }

    void checkMax(boolean assertInvalid) {
        if (VERIFY) {
            this.doCheckMax(assertInvalid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckMax(boolean assertInvalid) {
        try {
            this.l.readLock().lock();
            AtomicBoolean allValid = new AtomicBoolean(true);
            int[] keyCounter = new int[1];
            int[] nodeCounter = new int[1];
            LongOpenHashSet ids = new LongOpenHashSet(this.keySize);
            this.checkMax(this.getRoot(), 0, assertInvalid, allValid, keyCounter, nodeCounter, (LongSet)ids, true);
            if (assertInvalid) {
                assert (this.nodeSize() == nodeCounter[0]) : "node size: " + this.nodeSize() + "; actual: " + nodeCounter[0];
                assert (this.keySize == keyCounter[0]) : "key size: " + this.keySize + "; actual: " + keyCounter[0];
                assert (this.keySize >= this.nodeSize()) : this.keySize + "; " + this.nodeSize();
            }
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    @NotNull
    private IntTrinity checkMax(@Nullable IntervalNode<T> root, int deltaUpToRootExclusive, boolean assertInvalid, @NotNull AtomicBoolean allValid, int @NotNull [] keyCounter, int @NotNull [] nodeCounter, @NotNull LongSet ids, boolean allDeltasUpAreNull) {
        if (allValid == null) {
            IntervalTreeImpl.$$$reportNull$$$0(28);
        }
        if (ids == null) {
            IntervalTreeImpl.$$$reportNull$$$0(29);
        }
        if (keyCounter == null) {
            IntervalTreeImpl.$$$reportNull$$$0(30);
        }
        if (nodeCounter == null) {
            IntervalTreeImpl.$$$reportNull$$$0(31);
        }
        if (root == null) {
            return new IntTrinity(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        long packedOffsets = ((IntervalNode)root).cachedDeltaUpToRoot;
        if (IntervalNode.modCount(packedOffsets) == this.getModCount()) {
            assert (IntervalNode.allDeltasUpAreNull(packedOffsets) == (root.delta == 0 && allDeltasUpAreNull));
            assert (IntervalNode.deltaUpToRoot(packedOffsets) == root.delta + deltaUpToRootExclusive);
        }
        RangeMarkerEx liveInterval = null;
        List intervals = root.intervals;
        for (int i = intervals.size() - 1; i >= 0; --i) {
            RangeMarkerEx t = (RangeMarkerEx)intervals.get(i).get();
            if (t == null) continue;
            liveInterval = t;
            this.checkBelongsToTheTree(t, false);
            if (!t.isValid()) continue;
            long id = t.getId();
            boolean added = ids.add(id);
            assert (added) : t + "\nids:" + ids + "; id=" + id + "\n; root.intervals=" + intervals;
        }
        if (assertInvalid && liveInterval != null) {
            this.checkBelongsToTheTree(liveInterval, true);
        }
        keyCounter[0] = keyCounter[0] + intervals.size();
        nodeCounter[0] = nodeCounter[0] + 1;
        int delta = deltaUpToRootExclusive + (root.isValid() ? root.delta : 0);
        IntTrinity l = this.checkMax((IntervalNode<T>)root.getLeft(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int minLeftStart = l.minStart;
        int maxLeftStart = l.maxStart;
        int maxLeftEnd = l.maxEnd;
        IntTrinity r = this.checkMax((IntervalNode<T>)root.getRight(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int maxRightEnd = r.maxEnd;
        int minRightStart = r.minStart;
        int maxRightStart = r.maxStart;
        if (!root.isValid()) {
            allValid.set(false);
            if (assertInvalid) assert (false) : root;
            return new IntTrinity(Math.min(minLeftStart, minRightStart), Math.max(maxLeftStart, maxRightStart), Math.max(maxRightEnd, maxLeftEnd));
        }
        RedBlackTree.Node parent = root.getParent();
        if (parent != null && assertInvalid && root.hasAliveKey(false)) {
            int c = this.compareNodes(root, delta, (IntervalNode<T>)parent, delta - root.delta, (List<? super IntervalNode<T>>)new SmartList());
            assert (c != 0);
            assert (c < 0 && ((IntervalNode)parent).getLeft() == root || c > 0 && ((IntervalNode)parent).getRight() == root);
        }
        assert (delta + root.maxEnd == Math.max(maxLeftEnd, Math.max(maxRightEnd, delta + root.intervalEnd())));
        int myStartOffset = delta + root.intervalStart();
        assert (maxLeftStart <= myStartOffset);
        assert (minRightStart >= myStartOffset);
        assert (myStartOffset >= 0);
        assert (minLeftStart == Integer.MAX_VALUE || minLeftStart <= myStartOffset);
        assert (maxRightStart == Integer.MIN_VALUE || maxRightStart >= myStartOffset);
        int minStart = Math.min(minLeftStart, myStartOffset);
        int maxStart = Math.max(myStartOffset, Math.max(maxLeftStart, maxRightStart));
        return new IntTrinity(minStart, maxStart, root.maxEnd + delta);
    }

    @Override
    @NotNull
    protected RedBlackTree.Node<T> maximumNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(32);
        }
        RedBlackTree.Node root = (IntervalNode)n;
        this.pushDelta((IntervalNode<T>)root.getParent());
        this.pushDelta((IntervalNode<T>)root);
        while (root.getRight() != null) {
            root = root.getRight();
            this.pushDelta((IntervalNode<T>)root);
        }
        IntervalNode intervalNode = root;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(33);
        }
        return intervalNode;
    }

    private void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        IntervalNode<T> root;
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(34);
        }
        if ((root = this.lookupNode(interval)) == null) {
            return;
        }
        assert (root.getTree() == this) : root.getTree() + " (" + root.getTree().getClass() + "); this: " + this + "(" + this.getClass() + ")";
        if (VERIFY) {
            if (assertInvalid) {
                List intervals = root.intervals;
                assert (!intervals.isEmpty());
                boolean contains = false;
                for (int i = intervals.size() - 1; i >= 0; --i) {
                    RangeMarkerEx key = (RangeMarkerEx)intervals.get(i).get();
                    if (key == null) continue;
                    contains |= key == interval;
                    IntervalNode<RangeMarkerEx> node = this.lookupNode(key);
                    assert (node == root) : node;
                    assert (node.getTree() == this) : node;
                }
                assert (contains) : intervals + "; " + interval;
            }
            RedBlackTree.Node e = root;
            while (e.getParent() != null) {
                e = e.getParent();
            }
            assert (e == this.getRoot());
        }
    }

    @Override
    public boolean removeInterval(@NotNull T interval) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(35);
        }
        if (!interval.isValid()) {
            return false;
        }
        try {
            boolean bl = this.runUnderWriteLock(() -> {
                try {
                    this.incModCount();
                    boolean ret = false;
                    if (interval.isValid()) {
                        this.checkBelongsToTheTree(interval, true);
                        this.checkMax(true);
                        this.processReferenceQueue();
                        IntervalNode<RangeMarkerEx> node = this.lookupNode(interval);
                        if (node != null) {
                            this.beforeRemove(interval, node);
                            ((IntervalNode)node).removeInterval(interval);
                            ret = true;
                        }
                    }
                    Boolean bl = ret;
                    return bl;
                }
                finally {
                    this.setNode(interval, null);
                }
            });
            return bl;
        }
        finally {
            this.fireAfterRemoved(interval);
        }
    }

    void removeNode(@NotNull IntervalNode<T> node) {
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(36);
        }
        this.deleteNode((RedBlackTree.Node<T>)node);
        RedBlackTree.Node parent = node.getParent();
        this.correctMaxUp((IntervalNode<T>)parent);
    }

    @Override
    protected void deleteNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(37);
        }
        this.assertUnderWriteLock();
        IntervalNode node = (IntervalNode)n;
        this.pushDeltaFromRoot(node);
        this.assertAllDeltasAreNull(node);
        super.deleteNode(n);
        this.keySize -= node.intervals.size();
        assert (this.keySize >= 0) : this.keySize;
        node.setAttachedToTree(false);
    }

    @Override
    protected int size() {
        return this.keySize;
    }

    void pushDelta(@Nullable IntervalNode<T> root) {
        if (root == null || !root.isValid()) {
            return;
        }
        RedBlackTree.Node parent = root.getParent();
        this.assertAllDeltasAreNull((IntervalNode<T>)parent);
        int delta = root.delta;
        ((IntervalNode)root).setCachedValues(0, true, 0);
        if (delta == 0) {
            ((IntervalNode)root).setCachedValues(0, true, this.getModCount());
        } else {
            root.setRange(TextRangeScalarUtil.shift((long)root.toScalarRange(), (int)delta, (int)delta));
            root.maxEnd += delta;
            root.delta = 0;
            this.incDelta((IntervalNode<T>)root.getLeft(), delta);
            this.incDelta((IntervalNode<T>)root.getRight(), delta);
        }
    }

    private void incDelta(@Nullable IntervalNode<T> root, int delta) {
        if (root == null) {
            return;
        }
        if (root.isValid()) {
            root.changeDelta(delta);
        } else {
            this.incDelta((IntervalNode<T>)root.getLeft(), delta);
            this.incDelta((IntervalNode<T>)root.getRight(), delta);
        }
    }

    @Override
    @NotNull
    protected IntervalNode<T> swapWithMaxPred(@NotNull RedBlackTree.Node<T> root, @NotNull RedBlackTree.Node<T> maxPred) {
        if (root == null) {
            IntervalTreeImpl.$$$reportNull$$$0(38);
        }
        if (maxPred == null) {
            IntervalTreeImpl.$$$reportNull$$$0(39);
        }
        this.checkMax(false);
        IntervalNode a = (IntervalNode)root;
        IntervalNode d = (IntervalNode)maxPred;
        boolean aColor = a.isBlack();
        boolean dColor = d.isBlack();
        assert (!a.isValid() || a.delta == 0) : a.delta;
        for (RedBlackTree.Node n = a.getLeft(); n != null; n = ((IntervalNode)n).getRight()) {
            assert (!((IntervalNode)n).isValid() || ((IntervalNode)n).delta == 0) : ((IntervalNode)n).delta;
        }
        this.swapNodes(a, d);
        a.setValid(false);
        a.setColor(dColor);
        d.setColor(aColor);
        this.correctMaxUp(a);
        this.checkMax(false);
        assert (a.delta == 0) : a.delta;
        assert (d.delta == 0) : d.delta;
        IntervalNode intervalNode = a;
        if (intervalNode == null) {
            IntervalTreeImpl.$$$reportNull$$$0(40);
        }
        return intervalNode;
    }

    private void swapNodes(@NotNull IntervalNode<T> n1, @NotNull IntervalNode<T> n2) {
        if (n1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(41);
        }
        if (n2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(42);
        }
        RedBlackTree.Node l1 = n1.getLeft();
        RedBlackTree.Node r1 = n1.getRight();
        IntervalNode<T> p1 = n1.getParent();
        IntervalNode<T> l2 = n2.getLeft();
        IntervalNode<T> r2 = n2.getRight();
        RedBlackTree.Node p2 = n2.getParent();
        if (p1 != null) {
            if (p1.getLeft() == n1) {
                p1.setLeft(n2);
            } else {
                p1.setRight(n2);
            }
        } else {
            this.root = n2;
        }
        if (p2 != null) {
            if (((IntervalNode)p2).getLeft() == n2) {
                p2.setLeft(p2 == n1 ? l2 : n1);
            } else {
                p2.setRight(p2 == n1 ? r2 : n1);
            }
        } else {
            this.root = n1;
        }
        n1.setParent(p2 == n1 ? n2 : p2);
        n2.setParent(p1);
        n1.setLeft(l2);
        n2.setLeft(l1 == n2 ? n1 : l1);
        if (l1 != null) {
            l1.setParent(n2 == l1 ? p1 : n2);
            ((IntervalNode)l1).updateTasteBeneathFromChildren();
        }
        if (r1 != null) {
            r1.setParent(n2);
            ((IntervalNode)r1).updateTasteBeneathFromChildren();
        }
        n1.setRight(r2);
        n2.setRight(r1);
        if (l2 != null) {
            l2.setParent(n1);
            ((IntervalNode)l2).updateTasteBeneathFromChildren();
        }
        if (r2 != null) {
            r2.setParent(n1);
            ((IntervalNode)r2).updateTasteBeneathFromChildren();
        }
        ((IntervalNode)n1).updateTasteFromChildrenUp();
        ((IntervalNode)n2).updateTasteFromChildrenUp();
    }

    private int maxEndOf(@Nullable IntervalNode<T> node, int deltaUpToRootExclusive) {
        if (node == null) {
            return 0;
        }
        if (node.isValid()) {
            return node.maxEnd + node.delta + deltaUpToRootExclusive;
        }
        return Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRootExclusive), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRootExclusive));
    }

    @ApiStatus.Internal
    protected void correctMax(@NotNull IntervalNode<T> node, int deltaUpToRoot) {
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(43);
        }
        if (!node.isValid()) {
            return;
        }
        int realMax = Math.max(Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRoot), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRoot)), deltaUpToRoot + node.intervalEnd());
        node.maxEnd = realMax - deltaUpToRoot;
    }

    private void correctMaxUp(@Nullable IntervalNode<T> node) {
        int delta;
        int n = delta = node == null ? 0 : node.computeDeltaUpToRoot();
        assert (delta == 0) : delta;
        while (node != null) {
            if (node.isValid()) {
                int d = node.delta;
                this.correctMax((IntervalNode<T>)node, delta);
                delta -= d;
            }
            node = node.getParent();
        }
        assert (delta == 0) : delta;
    }

    private static byte tasteBeneath(@Nullable IntervalNode<?> node) {
        return node == null ? (byte)0 : ((IntervalNode)node).tasteBeneath;
    }

    @Override
    protected void rotateRight(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(44);
        }
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        super.rotateRight(node1);
        if (node3 != null) {
            this.correctMax((IntervalNode<T>)node3, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node2, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        node1.updateTasteBeneathFromChildren();
        ((IntervalNode)node2).updateTasteBeneathFromChildren();
        this.checkMax(false);
    }

    @Override
    protected void rotateLeft(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            IntervalTreeImpl.$$$reportNull$$$0(45);
        }
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot();
        this.pushDelta(node1);
        this.pushDelta((IntervalNode<T>)node2);
        this.pushDelta((IntervalNode<T>)node3);
        this.checkMax(false);
        super.rotateLeft(node1);
        if (node2 != null) {
            this.correctMax((IntervalNode<T>)node2, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node3, deltaUp);
        this.assertAllDeltasAreNull(node1);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3);
        node1.updateTasteBeneathFromChildren();
        ((IntervalNode)node3).updateTasteBeneathFromChildren();
        this.checkMax(false);
    }

    @Override
    protected void replaceNode(@NotNull RedBlackTree.Node<T> oldN, RedBlackTree.Node<T> newN) {
        if (oldN == null) {
            IntervalTreeImpl.$$$reportNull$$$0(46);
        }
        IntervalNode myNode = (IntervalNode)oldN;
        IntervalNode myChild = (IntervalNode)newN;
        this.pushDelta(myNode);
        this.pushDelta(myChild);
        super.replaceNode(oldN, newN);
        if (newN != null && myNode.isValid()) {
            myChild.changeDelta(myNode.delta);
            myChild.updateTasteFromChildrenUp();
        }
        myNode.updateTasteFromChildrenUp();
    }

    private void assertAllDeltasAreNull(@Nullable IntervalNode<T> node) {
        if (node == null) {
            return;
        }
        if (!node.isValid()) {
            return;
        }
        assert (node.delta == 0);
        long packedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
        assert (IntervalNode.modCount(packedOffsets) != this.getModCount() || IntervalNode.allDeltasUpAreNull(packedOffsets));
    }

    private IntervalNode<T> findMinOverlappingWith(@Nullable IntervalNode<T> root, @NotNull TextRange interval, int deltaUpToRootExclusive, byte tastePreference) {
        boolean overlaps;
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(47);
        }
        if (root == null) {
            return null;
        }
        assert (root.isValid());
        if (!((IntervalNode)root).hasDeliciousIntervalsBeneath(tastePreference)) {
            return null;
        }
        int delta = deltaUpToRootExclusive + root.delta;
        if (interval.getStartOffset() > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return null;
        }
        IntervalNode<T> inLeft = this.findMinOverlappingWith((IntervalNode<T>)root.getLeft(), interval, delta, tastePreference);
        if (inLeft != null) {
            return inLeft;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, interval.getStartOffset()) <= Math.min(myEndOffset, interval.getEndOffset());
        if (overlaps && ((IntervalNode)root).hasDeliciousIntervalsInside(tastePreference)) {
            return root;
        }
        if (interval.getEndOffset() < myStartOffset) {
            return null;
        }
        return this.findMinOverlappingWith((IntervalNode<T>)root.getRight(), interval, delta, tastePreference);
    }

    private boolean isDeliciousInterval(@NotNull T t, byte tastePreference) {
        if (t == null) {
            IntervalTreeImpl.$$$reportNull$$$0(48);
        }
        return tastePreference == 0 || (tastePreference & this.getTasteFlags(t)) == tastePreference;
    }

    void changeData(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (interval == null) {
            IntervalTreeImpl.$$$reportNull$$$0(49);
        }
        this.runUnderWriteLock(() -> {
            IntervalNode<RangeMarkerEx> node = this.lookupNode(interval);
            if (node == null) {
                return;
            }
            int before = this.size();
            boolean nodeRemoved = ((IntervalNode)node).removeInterval(interval);
            assert (nodeRemoved || !node.intervals.isEmpty());
            IntervalNode<RangeMarkerEx> insertedNode = this.addInterval(interval, start, end, greedyToLeft, greedyToRight, stickingToRight, layer);
            assert (node != insertedNode);
            int after = this.size();
            assert (before >= after) : before + ";" + after;
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
        });
    }

    private void processReferenceQueue() {
        int dead = 0;
        while (this.myReferenceQueue.poll() != null) {
            ++dead;
        }
        this.deadReferenceCount += dead;
        if (this.deadReferenceCount > Math.max(1, this.size() / 3)) {
            this.purgeDeadNodes();
            this.deadReferenceCount = 0;
        }
    }

    private void purgeDeadNodes() {
        this.assertUnderWriteLock();
        SmartList gced = new SmartList();
        this.collectGced(this.getRoot(), (List<? super IntervalNode<T>>)gced);
        this.deleteNodes((List<? extends IntervalNode<T>>)gced);
        this.checkMax(true);
    }

    @Override
    protected void clear() {
        ArrayList toRemove = new ArrayList();
        this.processAll(t -> toRemove.add(t));
        for (RangeMarkerEx t2 : toRemove) {
            this.removeInterval((T)t2);
        }
        this.runUnderWriteLock(() -> {
            if (this.nodeSize() == 0) {
                super.clear();
                this.keySize = 0;
            }
        });
    }

    private void collectGced(@Nullable IntervalNode<T> root, @NotNull List<? super IntervalNode<T>> gced) {
        if (gced == null) {
            IntervalTreeImpl.$$$reportNull$$$0(50);
        }
        if (root == null) {
            return;
        }
        if (!root.hasAliveKey(true)) {
            gced.add(root);
        }
        this.collectGced((IntervalNode<T>)root.getLeft(), (List<? super IntervalNode<T>>)gced);
        this.collectGced((IntervalNode<T>)root.getRight(), (List<? super IntervalNode<T>>)gced);
    }

    protected void fireBeforeRemoved(@NotNull T marker) {
        if (marker == null) {
            IntervalTreeImpl.$$$reportNull$$$0(51);
        }
    }

    protected void fireAfterRemoved(@NotNull T marker) {
        if (marker == null) {
            IntervalTreeImpl.$$$reportNull$$$0(52);
        }
    }

    void fireAfterRemoved(@NotNull List<? extends T> markers) {
        if (markers == null) {
            IntervalTreeImpl.$$$reportNull$$$0(53);
        }
        for (RangeMarkerEx marker : markers) {
            this.fireAfterRemoved(marker);
        }
    }

    void beforeRemove(@NotNull T marker, @NotNull IntervalNode<T> node) {
        if (marker == null) {
            IntervalTreeImpl.$$$reportNull$$$0(54);
        }
        if (node == null) {
            IntervalTreeImpl.$$$reportNull$$$0(55);
        }
        this.assertUnderWriteLock();
        if (this.firingRemove) {
            throw new IncorrectOperationException("must not remove range markers from within beforeRemove() listener");
        }
        this.firingRemove = true;
        try {
            this.fireBeforeRemoved(marker);
        }
        finally {
            this.firingRemove = false;
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected static <T extends RangeMarkerEx> MarkupIterator<T> mergingOverlappingIterator(@NotNull IntervalTreeImpl<T> tree1, @NotNull TextRange tree1Range, @NotNull IntervalTreeImpl<T> tree2, @NotNull TextRange tree2Range, byte tastePreference, @NotNull Comparator<? super T> comparator) {
        if (tree1 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(56);
        }
        if (tree1Range == null) {
            IntervalTreeImpl.$$$reportNull$$$0(57);
        }
        if (tree2 == null) {
            IntervalTreeImpl.$$$reportNull$$$0(58);
        }
        if (tree2Range == null) {
            IntervalTreeImpl.$$$reportNull$$$0(59);
        }
        if (comparator == null) {
            IntervalTreeImpl.$$$reportNull$$$0(60);
        }
        MarkupIterator<T> exact = tree1.overlappingDeliciousIterator(tree1Range, tastePreference);
        MarkupIterator<T> lines = tree2.overlappingDeliciousIterator(tree2Range, tastePreference);
        MarkupIterator<? super T> markupIterator = MarkupIterator.mergeIterators(exact, lines, comparator);
        if (markupIterator == null) {
            IntervalTreeImpl.$$$reportNull$$$0(61);
        }
        return markupIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T findRangeMarkerAfter(@NotNull T marker) {
        if (marker == null) {
            IntervalTreeImpl.$$$reportNull$$$0(62);
        }
        this.l.readLock().lock();
        try {
            boolean foundMarker = false;
            for (IntervalNode<T> node = this.lookupNode(marker); node != null; node = node.next()) {
                List intervals = node.intervals;
                for (int i = 0; i < intervals.size(); ++i) {
                    Supplier interval = intervals.get(i);
                    RangeMarkerEx m = (RangeMarkerEx)interval.get();
                    if (m == null) continue;
                    if (m == marker) {
                        foundMarker = true;
                        continue;
                    }
                    if (!foundMarker) continue;
                    RangeMarkerEx rangeMarkerEx = m;
                    return (T)rangeMarkerEx;
                }
                foundMarker = true;
            }
            T t = null;
            return t;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T findRangeMarkerBefore(@NotNull T marker) {
        if (marker == null) {
            IntervalTreeImpl.$$$reportNull$$$0(63);
        }
        this.l.readLock().lock();
        try {
            boolean foundMarker = false;
            for (IntervalNode<T> node = this.lookupNode(marker); node != null; node = node.previous()) {
                List intervals = node.intervals;
                for (int i = intervals.size() - 1; i >= 0; --i) {
                    Supplier interval = intervals.get(i);
                    RangeMarkerEx m = (RangeMarkerEx)interval.get();
                    if (m == null) continue;
                    if (m == marker) {
                        foundMarker = true;
                        continue;
                    }
                    if (!foundMarker) continue;
                    RangeMarkerEx rangeMarkerEx = m;
                    return (T)rangeMarkerEx;
                }
                foundMarker = true;
            }
            T t = null;
            return t;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    @ApiStatus.Internal
    public String dumpState() {
        StringBuilder b = new StringBuilder("[\n");
        this.processAll(i -> {
            b.append(' ').append(i).append('\n');
            return true;
        });
        return b.append("]").toString();
    }

    @Override
    protected void verifyProperties() {
        super.verifyProperties();
        if (VERIFY) {
            this.verifyTaste((IntervalNode)this.root);
        }
    }

    private byte verifyTaste(@Nullable IntervalNode<T> root) {
        if (root == null) {
            return 0;
        }
        assert (((IntervalNode)root).taste == ((IntervalNode)root).computeTaste()) : "root.taste: " + Integer.toHexString(IntervalNode.access$2600(root)) + "; root.computeTaste():" + Integer.toHexString(IntervalNode.access$2700(root)) + "; intervals: " + root.intervals;
        byte foundInChildren = (byte)(this.verifyTaste((IntervalNode<T>)root.getLeft()) | this.verifyTaste((IntervalNode<T>)root.getRight()));
        assert ((((IntervalNode)root).taste & ((IntervalNode)root).tasteBeneath) == ((IntervalNode)root).taste) : "root.taste: " + Integer.toHexString(IntervalNode.access$2600(root)) + "; root.tasteBeneath:" + Integer.toHexString(IntervalNode.access$2500(root)) + "; intervals: " + root.intervals;
        assert ((((IntervalNode)root).tasteBeneath & ~((IntervalNode)root).taste) == (foundInChildren & ~((IntervalNode)root).taste)) : "root.taste: " + Integer.toHexString(IntervalNode.access$2600(root)) + "; root.tasteBeneath:" + Integer.toHexString(IntervalNode.access$2500(root)) + "; foundInChildren:" + Integer.toHexString(foundInChildren) + "; intervals: " + root.intervals;
        return ((IntervalNode)root).tasteBeneath;
    }

    protected static byte nextAvailableTasteFlag() {
        int bits = occupiedTasteFlags.incrementAndGet();
        if (bits > 8) {
            throw new IncorrectOperationException("No more available flags left: " + occupiedTasteFlags);
        }
        return (byte)(1 << bits);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 18: 
            case 22: 
            case 23: 
            case 27: 
            case 33: 
            case 40: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 18: 
            case 22: 
            case 23: 
            case 27: 
            case 33: 
            case 40: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 25: 
            case 26: 
            case 34: 
            case 35: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 3: 
            case 18: 
            case 22: 
            case 23: 
            case 27: 
            case 33: 
            case 40: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/IntervalTreeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalid";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInterval";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 21: 
            case 36: 
            case 43: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedAway";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allValid";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCounter";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCounter";
                break;
            }
            case 32: 
            case 37: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxPred";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldN";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gced";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree1";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree1Range";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree2";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree2Range";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrInsert";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterval";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "maximumNode";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "swapWithMaxPred";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "mergingOverlappingIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runUnderWriteLock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createGetter";
                break;
            }
            case 3: 
            case 18: 
            case 22: 
            case 23: 
            case 27: 
            case 33: 
            case 40: 
            case 61: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "keepIntervalOnWeakReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processOverlappingWith";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processOverlappingWithOutside";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processContaining";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "overlappingIterator";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "overlappingDeliciousIterator";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "overlaps";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findOrInsert";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteNodes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTasteFlags";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addInterval";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkMax";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "maximumNode";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkBelongsToTheTree";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeInterval";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "deleteNode";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "swapWithMaxPred";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "swapNodes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "correctMax";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "replaceNode";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findMinOverlappingWith";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isDeliciousInterval";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "changeData";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "collectGced";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterRemoved";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemove";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "mergingOverlappingIterator";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findRangeMarkerAfter";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findRangeMarkerBefore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 18: 
            case 22: 
            case 23: 
            case 27: 
            case 33: 
            case 40: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    protected static class IntervalNode<E extends RangeMarkerEx>
    extends RedBlackTree.Node<E>
    implements MutableInterval {
        private volatile long myRange;
        private static final byte ATTACHED_TO_TREE_FLAG = 2;
        protected final List<Supplier<? extends E>> intervals;
        int maxEnd;
        int delta;
        private byte tasteBeneath;
        private byte taste;
        private volatile long cachedDeltaUpToRoot;
        @NotNull
        private final IntervalTreeImpl<E> myTree;
        static final byte VALID_FLAG = 4;
        private static final VarHandleWrapper cachedDeltaHandler = VarHandleWrapper.getFactory().create(IntervalNode.class, "cachedDeltaUpToRoot", Long.TYPE);

        IntervalNode(@NotNull IntervalTreeImpl<E> tree, @NotNull E key, int start, int end) {
            if (tree == null) {
                IntervalNode.$$$reportNull$$$0(0);
            }
            if (key == null) {
                IntervalNode.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.myRange = TextRangeScalarUtil.toScalarRange((int)start, (int)end);
            this.intervals = new SmartList((Object)((IntervalTreeImpl)tree).createGetter(key));
            this.setValid(true);
        }

        protected int getDelta() {
            return this.delta;
        }

        protected int getMaxEnd() {
            return this.maxEnd;
        }

        @Override
        protected IntervalNode<E> getLeft() {
            return (IntervalNode)this.left;
        }

        @Override
        protected IntervalNode<E> getRight() {
            return (IntervalNode)this.right;
        }

        @Override
        protected IntervalNode<E> getParent() {
            return (IntervalNode)this.parent;
        }

        @Override
        protected boolean processAliveKeys(@NotNull Processor<? super E> processor) {
            if (processor == null) {
                IntervalNode.$$$reportNull$$$0(2);
            }
            List<Supplier<E>> intervals = this.intervals;
            for (int i = 0; i < intervals.size(); ++i) {
                Supplier<E> interval = intervals.get(i);
                RangeMarkerEx key = (RangeMarkerEx)interval.get();
                if (key == null || processor.process((Object)key)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean hasAliveKey(boolean purgeAllDead) {
            boolean hasAliveInterval = false;
            List<Supplier<E>> intervals = this.intervals;
            for (int i = intervals.size() - 1; i >= 0; --i) {
                Supplier<E> interval = intervals.get(i);
                if (interval.get() == null) {
                    if (!purgeAllDead) continue;
                    this.myTree.assertUnderWriteLock();
                    this.removeIntervalInternal(i, null);
                    continue;
                }
                hasAliveInterval = true;
                if (!purgeAllDead) break;
            }
            return hasAliveInterval;
        }

        private boolean removeInterval(@NotNull E key) {
            if (key == null) {
                IntervalNode.$$$reportNull$$$0(3);
            }
            ((IntervalTreeImpl)this.myTree).checkBelongsToTheTree(key, true);
            this.myTree.assertUnderWriteLock();
            List<Supplier<E>> intervals = this.intervals;
            for (int i = intervals.size() - 1; i >= 0; --i) {
                Supplier<E> interval = intervals.get(i);
                RangeMarkerEx t = (RangeMarkerEx)interval.get();
                if (t != key) continue;
                this.removeIntervalInternal(i, t);
                if (intervals.isEmpty()) {
                    this.myTree.removeNode(this);
                    return true;
                }
                return false;
            }
            assert (false) : "interval not found: " + key + "; " + intervals;
            return false;
        }

        private boolean isAttachedToTree() {
            return this.isFlagSet((byte)2);
        }

        private void setAttachedToTree(boolean attached) {
            this.setFlag((byte)2, attached);
        }

        @ApiStatus.Internal
        protected void removeIntervalInternal(int i, @Nullable E oldInterval) {
            int oldTaste;
            this.intervals.remove(i);
            if (this.isAttachedToTree()) {
                assert (((IntervalTreeImpl)this.myTree).keySize > 0) : IntervalTreeImpl.access$200(this.myTree);
                ((IntervalTreeImpl)this.myTree).keySize--;
            }
            int n = oldTaste = oldInterval == null ? -1 : (int)this.myTree.getTasteFlags(oldInterval);
            if (oldTaste != 0) {
                this.updateTaste();
            }
            this.updateTasteFromChildrenUp();
        }

        private void updateTasteBeneathFromChildren() {
            this.tasteBeneath = (byte)(this.taste | IntervalTreeImpl.tasteBeneath((IntervalNode)this.getLeft()) | IntervalTreeImpl.tasteBeneath((IntervalNode)this.getRight()));
        }

        private void updateTaste() {
            this.taste = this.computeTaste();
        }

        private void updateTasteFromChildrenUp() {
            for (RedBlackTree.Node n = this; n != null; n = n.getParent()) {
                n.updateTasteBeneathFromChildren();
            }
        }

        private byte computeTaste() {
            byte r = 0;
            List<Supplier<E>> intervals = this.intervals;
            for (int i = 0; i < intervals.size(); ++i) {
                Supplier<E> interval = intervals.get(i);
                RangeMarkerEx e = (RangeMarkerEx)interval.get();
                if (e == null) continue;
                r = (byte)(r | this.myTree.getTasteFlags(e));
            }
            return r;
        }

        @ApiStatus.Internal
        protected void addInterval(@NotNull E interval) {
            if (interval == null) {
                IntervalNode.$$$reportNull$$$0(4);
            }
            this.myTree.assertUnderWriteLock();
            this.intervals.add(((IntervalTreeImpl)this.myTree).createGetter(interval));
            if (this.isAttachedToTree()) {
                ((IntervalTreeImpl)this.myTree).keySize++;
                this.myTree.setNode(interval, this);
            }
        }

        protected void addIntervalsFrom(@NotNull IntervalNode<E> otherNode) {
            if (otherNode == null) {
                IntervalNode.$$$reportNull$$$0(5);
            }
            for (Supplier<E> key : otherNode.intervals) {
                RangeMarkerEx interval = (RangeMarkerEx)key.get();
                if (interval == null) continue;
                this.addInterval(interval);
            }
            this.updateTaste();
            this.updateTasteFromChildrenUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int computeDeltaUpToRoot() {
            block7: while (this.isValid()) {
                int treeModCount = this.myTree.getModCount();
                long packedOffsets = this.cachedDeltaUpToRoot;
                if (IntervalNode.modCount(packedOffsets) == treeModCount) {
                    return IntervalNode.deltaUpToRoot(packedOffsets);
                }
                try {
                    boolean allDeltasAreNull;
                    int deltaUp;
                    block17: {
                        ((IntervalTreeImpl)this.myTree).l.readLock().lock();
                        RedBlackTree.Node node = this;
                        IntervalNode<E> treeRoot = this.myTree.getRoot();
                        if (treeRoot == null) {
                            int n = this.delta;
                            return n;
                        }
                        deltaUp = 0;
                        allDeltasAreNull = true;
                        int height = 0;
                        long path = 0L;
                        while (node != treeRoot) {
                            long nodePackedOffsets = ((IntervalNode)node).cachedDeltaUpToRoot;
                            if (((IntervalNode)node).isValid() && IntervalNode.modCount(nodePackedOffsets) == treeModCount) {
                                deltaUp = IntervalNode.deltaUpToRoot(nodePackedOffsets) - ((IntervalNode)node).delta;
                                allDeltasAreNull = IntervalNode.allDeltasUpAreNull(nodePackedOffsets);
                                break;
                            }
                            RedBlackTree.Node parent = ((IntervalNode)node).getParent();
                            if (parent == null) {
                                int n = deltaUp;
                                return n;
                            }
                            path = path << 1 | (long)(((IntervalNode)parent).getLeft() == node ? 0 : 1);
                            node = parent;
                            ++height;
                        }
                        assert (height < 63) : height;
                        do {
                            int nodeDelta;
                            if (((IntervalNode)node).isValid() && !((IntervalNode)node).tryToSetCachedValues(deltaUp += (nodeDelta = ((IntervalNode)node).delta), allDeltasAreNull &= nodeDelta == 0, treeModCount)) continue block7;
                            if (node == this) break block17;
                            node = (path & 1L) == 0L ? ((IntervalNode)node).getLeft() : ((IntervalNode)node).getRight();
                            path >>= 1;
                        } while (node != null);
                        int n = deltaUp;
                        return n;
                    }
                    assert (deltaUp == 0 || !allDeltasAreNull);
                    int n = deltaUp;
                    return n;
                }
                finally {
                    ((IntervalTreeImpl)this.myTree).l.readLock().unlock();
                    continue;
                }
                break;
            }
            return 0;
        }

        void changeDelta(int change) {
            if (change != 0) {
                this.setCachedValues(0, false, 0);
                this.delta += change;
            }
        }

        void clearDelta() {
            if (this.delta != 0) {
                this.setCachedValues(0, false, 0);
                this.delta = 0;
            }
        }

        @Override
        public void setRange(long scalarRange) {
            this.myRange = scalarRange;
        }

        @Override
        public boolean isValid() {
            return this.isFlagSet((byte)4);
        }

        @Override
        public boolean setValid(boolean value) {
            this.setFlag((byte)4, value);
            return value;
        }

        @Override
        public int intervalStart() {
            return TextRangeScalarUtil.startOffset((long)this.myRange);
        }

        @Override
        public int intervalEnd() {
            return TextRangeScalarUtil.endOffset((long)this.myRange);
        }

        protected long toScalarRange() {
            return this.myRange;
        }

        @NotNull
        protected IntervalTreeImpl<E> getTree() {
            IntervalTreeImpl<E> intervalTreeImpl = this.myTree;
            if (intervalTreeImpl == null) {
                IntervalNode.$$$reportNull$$$0(6);
            }
            return intervalTreeImpl;
        }

        private void setCachedValues(int deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            this.cachedDeltaUpToRoot = IntervalNode.packValues(deltaUpToRoot, allDeltaUpToRootAreNull, modCount);
        }

        protected void attributesChanged() {
            this.myTree.runUnderWriteLock(() -> {
                this.updateTaste();
                this.updateTasteFromChildrenUp();
                return null;
            });
        }

        private static long packValues(long deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            return deltaUpToRoot << 33 | (allDeltaUpToRootAreNull ? 0x100000000L : 0L) | (long)modCount;
        }

        private boolean tryToSetCachedValues(int deltaUpToRoot, boolean allDeltasUpAreNull, int treeModCount) {
            if (this.myTree.getModCount() != treeModCount) {
                return false;
            }
            long newValue = IntervalNode.packValues(deltaUpToRoot, allDeltasUpAreNull, treeModCount);
            long oldValue = this.cachedDeltaUpToRoot;
            return cachedDeltaHandler.compareAndSetLong((Object)this, oldValue, newValue);
        }

        private static boolean allDeltasUpAreNull(long packedOffsets) {
            return (packedOffsets >> 32 & 1L) != 0L;
        }

        private static int modCount(long packedOffsets) {
            return (int)packedOffsets;
        }

        private static int deltaUpToRoot(long packedOffsets) {
            return (int)(packedOffsets >> 33);
        }

        IntervalNode<E> previous() {
            RedBlackTree.Node parent;
            RedBlackTree.Node left = this.getLeft();
            if (left != null) {
                while (((IntervalNode)left).getRight() != null) {
                    left = ((IntervalNode)left).getRight();
                }
                return left;
            }
            RedBlackTree.Node prev = this;
            for (parent = this.getParent(); parent != null && ((IntervalNode)parent).getRight() != prev; parent = ((IntervalNode)parent).getParent()) {
                prev = parent;
            }
            return parent;
        }

        IntervalNode<E> next() {
            RedBlackTree.Node parent;
            RedBlackTree.Node right = this.getRight();
            if (right != null) {
                while (((IntervalNode)right).getLeft() != null) {
                    right = ((IntervalNode)right).getLeft();
                }
                return right;
            }
            RedBlackTree.Node prev = this;
            for (parent = this.getParent(); parent != null && ((IntervalNode)parent).getLeft() != prev; parent = ((IntervalNode)parent).getParent()) {
                prev = parent;
            }
            return parent;
        }

        @NonNls
        public String toString() {
            return "Node " + TextRangeScalarUtil.create((long)this.myRange) + ": " + this.intervals;
        }

        private boolean hasDeliciousIntervalsBeneath(byte tastePreference) {
            return (tastePreference & this.tasteBeneath) == tastePreference;
        }

        private boolean hasDeliciousIntervalsInside(byte tastePreference) {
            return (tastePreference & this.taste) == tastePreference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interval";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processAliveKeys";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeInterval";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addInterval";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addIntervalsFrom";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class WeakReferencedGetter<T>
    extends WeakReference<T>
    implements Supplier<T> {
        private WeakReferencedGetter(@NotNull T referent, @NotNull ReferenceQueue<? super T> q) {
            if (referent == null) {
                WeakReferencedGetter.$$$reportNull$$$0(0);
            }
            if (q == null) {
                WeakReferencedGetter.$$$reportNull$$$0(1);
            }
            super(referent, q);
        }

        @NonNls
        public String toString() {
            return "wRef: " + this.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "q";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$WeakReferencedGetter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IntervalTreeGuide<T extends MutableInterval & RangeMarkerEx>
    implements WalkingState.TreeGuide<IntervalNode<T>> {
        private static final IntervalTreeGuide<?> INSTANCE = new IntervalTreeGuide();

        private IntervalTreeGuide() {
        }

        @NotNull
        private static <T extends RangeMarkerEx> WalkingState.TreeGuide<IntervalNode<T>> getGuide() {
            IntervalTreeGuide<?> intervalTreeGuide = INSTANCE;
            if (intervalTreeGuide == null) {
                IntervalTreeGuide.$$$reportNull$$$0(0);
            }
            return intervalTreeGuide;
        }

        public IntervalNode<T> getNextSibling(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node parent;
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(1);
            }
            if ((parent = element.getParent()) == null) {
                return null;
            }
            return ((IntervalNode)parent).getLeft() == element ? ((IntervalNode)parent).getRight() : null;
        }

        public IntervalNode<T> getPrevSibling(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node parent;
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(2);
            }
            if ((parent = element.getParent()) == null) {
                return null;
            }
            return ((IntervalNode)parent).getRight() == element ? ((IntervalNode)parent).getLeft() : null;
        }

        public IntervalNode<T> getFirstChild(@NotNull IntervalNode<T> element) {
            RedBlackTree.Node left;
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(3);
            }
            return (left = element.getLeft()) == null ? element.getRight() : left;
        }

        public IntervalNode<T> getParent(@NotNull IntervalNode<T> element) {
            if (element == null) {
                IntervalTreeGuide.$$$reportNull$$$0(4);
            }
            return element.getParent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGuide";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getNextSibling";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrevSibling";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFirstChild";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class IntTrinity {
        private final int minStart;
        private final int maxStart;
        private final int maxEnd;

        private IntTrinity(int minStart, int maxStart, int maxEnd) {
            this.minStart = minStart;
            this.maxStart = maxStart;
            this.maxEnd = maxEnd;
        }
    }
}

