/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointerKt;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\n\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0082\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vfs/impl/LightFilePointer;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "url", "", "<init>", "(Ljava/lang/String;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "cachedFile", "isRefreshed", "", "getFile", "getUrl", "getFileName", "getPresentableUrl", "isValid", "refreshFile", "", "equals", "other", "", "hashCode", "", "intellij.platform.core.impl"})
public class LightFilePointer
implements VirtualFilePointer {
    @NotNull
    private final String url;
    @Nullable
    private volatile VirtualFile cachedFile;
    private volatile boolean isRefreshed;

    public LightFilePointer(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    public LightFilePointer(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        this.url = string;
        this.cachedFile = file;
    }

    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.cachedFile;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public String getFileName() {
        String string;
        VirtualFile virtualFile = this.cachedFile;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return string2;
        }
        int index = StringsKt.lastIndexOf$default((CharSequence)this.url, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index >= 0) {
            String string3 = this.url.substring(index + 1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = this.url;
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        Object object = this.getFile();
        if (object == null || (object = object.getPresentableUrl()) == null) {
            object = LightFilePointerKt.access$toPresentableUrl(this.url);
        }
        return object;
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    private final void refreshFile() {
        VirtualFile virtualFile = this.cachedFile;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            if (it.isValid()) {
                return;
            }
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        VirtualFile virtualFile2 = virtualFileManager2.findFileByUrl(this.url);
        if (virtualFile2 == null && !this.isRefreshed) {
            this.isRefreshed = true;
            Application app = ApplicationManager.getApplication();
            if (app.isDispatchThread() || !app.isReadAccessAllowed()) {
                virtualFile2 = virtualFileManager2.refreshAndFindFileByUrl(this.url);
            } else {
                Future future = app.executeOnPooledThread(() -> LightFilePointer.refreshFile$lambda$1(virtualFileManager2, this));
                Intrinsics.checkNotNull((Object)future);
            }
        }
        this.cachedFile = virtualFile2 != null && virtualFile2.isValid() ? virtualFile2 : null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LightFilePointer ? Intrinsics.areEqual((Object)this.url, (Object)((LightFilePointer)other).url) : false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    private static final void refreshFile$lambda$1(VirtualFileManager $virtualFileManager, LightFilePointer this$0) {
        $virtualFileManager.refreshAndFindFileByUrl(this$0.url);
    }
}

