/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.impl.builder;

import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.element.SyntaxTokenTypes;
import com.intellij.platform.syntax.impl.builder.ErrorMarker;
import com.intellij.platform.syntax.impl.builder.ProductionMarker;
import com.intellij.platform.syntax.impl.builder.SyntaxTreeBuilderImpl;
import com.intellij.platform.syntax.parser.SyntaxTreeBuilder;
import com.intellij.platform.syntax.parser.WhitespacesAndCommentsBinder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\u0002H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0002H\u0016J%\u0010&\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00022\u000b\u0010(\u001a\u00070\u001f\u00a2\u0006\u0002\b)H\u0016J\u0015\u0010*\u001a\u00020\u001b2\u000b\u0010+\u001a\u00070\u001f\u00a2\u0006\u0002\b)H\u0016J\u001d\u0010,\u001a\u00020\u001b2\u000b\u0010+\u001a\u00070\u001f\u00a2\u0006\u0002\b)2\u0006\u0010'\u001a\u00020\u0002H\u0016J\u000e\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\nJ\u001c\u0010/\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000101H\u0016J\n\u00105\u001a\u00020\u001fH\u0096\u0080\u0004J\u0010\u00106\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0018\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0015H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u00103\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00069"}, d2={"Lcom/intellij/platform/syntax/impl/builder/CompositeMarker;", "Lcom/intellij/platform/syntax/impl/builder/ProductionMarker;", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder$Marker;", "markerId", "", "builder", "Lcom/intellij/platform/syntax/impl/builder/SyntaxTreeBuilderImpl;", "<init>", "(ILcom/intellij/platform/syntax/impl/builder/SyntaxTreeBuilderImpl;)V", "type", "Lcom/intellij/platform/syntax/SyntaxElementType;", "getType", "()Lcom/intellij/platform/syntax/SyntaxElementType;", "setType", "(Lcom/intellij/platform/syntax/SyntaxElementType;)V", "endIndex", "getEndIndex", "()I", "setEndIndex", "(I)V", "isErrorMarker", "", "text", "", "getText", "()Ljava/lang/CharSequence;", "dispose", "", "getEndOffset", "getEndTokenIndex", "getErrorMessage", "", "getNodeType", "precede", "drop", "rollbackTo", "done", "collapse", "doneBefore", "before", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "error", "message", "errorBefore", "remapTokenType", "newTokenType", "setCustomEdgeTokenBinders", "left", "Lcom/intellij/platform/syntax/parser/WhitespacesAndCommentsBinder;", "right", "isDone", "()Z", "toString", "getLexemeIndex", "setLexemeIndex", "value", "intellij.platform.syntax"})
public final class CompositeMarker
extends ProductionMarker
implements SyntaxTreeBuilder.Marker {
    public SyntaxElementType type;
    private int endIndex = -1;

    public CompositeMarker(int markerId, @NotNull SyntaxTreeBuilderImpl builder) {
        super(markerId, builder);
    }

    @NotNull
    public final SyntaxElementType getType() {
        SyntaxElementType syntaxElementType = this.type;
        if (syntaxElementType != null) {
            return syntaxElementType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        return null;
    }

    public final void setType(@NotNull SyntaxElementType syntaxElementType) {
        this.type = syntaxElementType;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final void setEndIndex(int n) {
        this.endIndex = n;
    }

    @Override
    public boolean isErrorMarker() {
        return false;
    }

    @Nullable
    public final CharSequence getText() {
        int endOffset;
        int startOffset;
        if (!this.isDone()) {
            return null;
        }
        CharSequence originalText = this.getBuilder().getText();
        CharSequence text = originalText.subSequence(startOffset = this.getStartOffset() - this.getBuilder().getStartOffset(), endOffset = this.getEndOffset() - this.getBuilder().getStartOffset());
        if (!(text.length() == endOffset - startOffset)) {
            throw new IllegalStateException("Check failed.");
        }
        return text;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getBuilder().getMyOptionalData$intellij_platform_syntax().clean(this.getMarkerId());
        this.endIndex = -1;
    }

    @Override
    public int getEndOffset() {
        return this.getBuilder().lexStart(this.endIndex) + this.getBuilder().getStartOffset();
    }

    @Override
    public int getEndTokenIndex() {
        return this.endIndex;
    }

    @Override
    @Nullable
    public String getErrorMessage() {
        return this.getNodeType() == SyntaxTokenTypes.getERROR_ELEMENT() ? this.getBuilder().getMyOptionalData$intellij_platform_syntax().getDoneError(this.getMarkerId()) : null;
    }

    @Override
    @NotNull
    public SyntaxElementType getNodeType() {
        return this.getType();
    }

    @Override
    @NotNull
    public SyntaxTreeBuilder.Marker precede() {
        return this.getBuilder().precede$intellij_platform_syntax(this);
    }

    @Override
    public void drop() {
        this.getBuilder().getMyProduction$intellij_platform_syntax().dropMarker(this);
    }

    @Override
    public void rollbackTo() {
        this.getBuilder().rollbackTo$intellij_platform_syntax(this);
    }

    @Override
    public void done(@NotNull SyntaxElementType type) {
        if (type == SyntaxTokenTypes.getERROR_ELEMENT()) {
            this.getBuilder().getLogger().warn("Error elements with empty message are discouraged. Please use builder.error() instead", new RuntimeException());
        }
        this.setType(type);
        this.getBuilder().processDone$intellij_platform_syntax(this, null, null);
    }

    @Override
    public void collapse(@NotNull SyntaxElementType type) {
        this.done(type);
        this.getBuilder().getMyOptionalData$intellij_platform_syntax().markCollapsed(this.getMarkerId());
    }

    @Override
    public void doneBefore(@NotNull SyntaxElementType type, @NotNull SyntaxTreeBuilder.Marker before) {
        if (type == SyntaxTokenTypes.getERROR_ELEMENT()) {
            this.getBuilder().getLogger().warn("Error elements with empty message are discouraged. Please use builder.errorBefore() instead", new RuntimeException());
        }
        this.setType(type);
        SyntaxTreeBuilderImpl syntaxTreeBuilderImpl = this.getBuilder();
        Intrinsics.checkNotNull((Object)before, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.impl.builder.CompositeMarker");
        syntaxTreeBuilderImpl.processDone$intellij_platform_syntax(this, null, (CompositeMarker)before);
    }

    @Override
    public void doneBefore(@NotNull SyntaxElementType type, @NotNull SyntaxTreeBuilder.Marker before, @NotNull String errorMessage) {
        Intrinsics.checkNotNull((Object)before, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.impl.builder.CompositeMarker");
        CompositeMarker marker = (CompositeMarker)before;
        ErrorMarker errorNode = this.getBuilder().getPool$intellij_platform_syntax().allocateErrorNode();
        errorNode.setErrorMessage(errorMessage);
        errorNode.setStartIndex(marker.getStartTokenIndex());
        this.getBuilder().getMyProduction$intellij_platform_syntax().addBefore(errorNode, marker);
        this.doneBefore(type, before);
    }

    @Override
    public void error(@NotNull String message) {
        this.setType(SyntaxTokenTypes.getERROR_ELEMENT());
        this.getBuilder().processDone$intellij_platform_syntax(this, message, null);
    }

    @Override
    public void errorBefore(@NotNull String message, @NotNull SyntaxTreeBuilder.Marker before) {
        this.setType(SyntaxTokenTypes.getERROR_ELEMENT());
        SyntaxTreeBuilderImpl syntaxTreeBuilderImpl = this.getBuilder();
        Intrinsics.checkNotNull((Object)before, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.impl.builder.CompositeMarker");
        syntaxTreeBuilderImpl.processDone$intellij_platform_syntax(this, message, (CompositeMarker)before);
    }

    public final void remapTokenType(@NotNull SyntaxElementType newTokenType) {
        if (!this.isDone()) {
            this.getBuilder().getLogger().error("Can't remap token type for non-done marker");
        }
        this.setType(newTokenType);
    }

    @Override
    public void setCustomEdgeTokenBinders(@Nullable WhitespacesAndCommentsBinder left, @Nullable WhitespacesAndCommentsBinder right) {
        if (left != null) {
            this.getBuilder().getMyOptionalData$intellij_platform_syntax().assignBinder(this.getMarkerId(), left, false);
        }
        if (right != null) {
            this.getBuilder().getMyOptionalData$intellij_platform_syntax().assignBinder(this.getMarkerId(), right, true);
        }
    }

    public final boolean isDone() {
        return this.endIndex != -1;
    }

    @NotNull
    public String toString() {
        if (this.getStartTokenIndex() < 0) {
            return "<dropped>";
        }
        boolean isDone = this.isDone();
        CharSequence originalText = this.getBuilder().getText();
        int startOffset = this.getStartOffset() - this.getBuilder().getStartOffset();
        int endOffset = isDone ? this.getEndOffset() - this.getBuilder().getStartOffset() : this.getBuilder().getCurrentOffset();
        CharSequence text = originalText.subSequence(startOffset, endOffset);
        return isDone ? ((Object)text).toString() : "" + text + '\u2026';
    }

    @Override
    public int getLexemeIndex(boolean done) {
        return done ? this.endIndex : this.getStartIndex();
    }

    @Override
    public void setLexemeIndex(int value, boolean done) {
        if (done) {
            this.endIndex = value;
        } else {
            this.setStartIndex(value);
        }
    }
}

