/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.TransferredWriteActionService;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PsiManagerImpl
extends PsiManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PsiManagerImpl.class);
    private final Project myProject;
    private final NotNullLazyValue<? extends FileIndexFacade> myFileIndex;
    private final PsiModificationTracker myModificationTracker;
    private final FileManagerEx myFileManager;
    private final List<PsiTreeChangePreprocessor> myTreeChangePreprocessors;
    private final List<PsiTreeChangePreprocessor> myTreeChangePreprocessorsBackgroundable;
    private final List<PsiTreeChangeListener> myTreeChangeListeners;
    private final List<PsiTreeChangeListener> myTreeChangeListenersBackgroundable;
    private boolean myTreeChangeEventIsFiring;
    private VirtualFileFilter myAssertOnFileLoadingFilter;
    private final AtomicInteger myBatchFilesProcessingModeCount;
    @Topic.ProjectLevel
    public static final Topic<AnyPsiChangeListener> ANY_PSI_CHANGE_TOPIC = new Topic(AnyPsiChangeListener.class, Topic.BroadcastDirection.TO_PARENT);

    public PsiManagerImpl(@NotNull Project project) {
        if (project == null) {
            PsiManagerImpl.$$$reportNull$$$0(0);
        }
        this.myTreeChangePreprocessors = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTreeChangePreprocessorsBackgroundable = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTreeChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTreeChangeListenersBackgroundable = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
        this.myBatchFilesProcessingModeCount = new AtomicInteger(0);
        PsiBuilderFactory.getInstance();
        this.myProject = project;
        this.myFileIndex = NotNullLazyValue.createValue(() -> FileIndexFacade.getInstance((Project)project));
        this.myModificationTracker = PsiModificationTracker.getInstance((Project)project);
        this.myFileManager = new FileManagerImpl(this, this.myFileIndex);
        this.myTreeChangePreprocessors.add((PsiTreeChangePreprocessor)this.myModificationTracker);
    }

    @NonInjectable
    @ApiStatus.Internal
    public PsiManagerImpl(@NotNull Project project, FileManagerEx fileManager) {
        if (project == null) {
            PsiManagerImpl.$$$reportNull$$$0(1);
        }
        this.myTreeChangePreprocessors = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTreeChangePreprocessorsBackgroundable = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTreeChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTreeChangeListenersBackgroundable = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
        this.myBatchFilesProcessingModeCount = new AtomicInteger(0);
        PsiBuilderFactory.getInstance();
        this.myProject = project;
        this.myFileIndex = NotNullLazyValue.createValue(() -> FileIndexFacade.getInstance((Project)project));
        this.myModificationTracker = PsiModificationTracker.getInstance((Project)project);
        this.myFileManager = fileManager;
        this.myTreeChangePreprocessors.add((PsiTreeChangePreprocessor)this.myModificationTracker);
    }

    public void dispose() {
        this.myFileManager.dispose();
    }

    public boolean isDisposed() {
        return this.myProject.isDisposed();
    }

    public void dropResolveCaches() {
        this.myFileManager.processQueue();
        this.beforeChange(true);
    }

    public void dropPsiCaches() {
        if (!EDT.isCurrentThreadEdt() && !ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("PsiManager#dropPsiCaches must be called in EDT or in write action");
        }
        this.dropResolveCaches();
        ApplicationManager.getApplication().runWriteAction(() -> this.myFileManager.firePropertyChangedForUnloadedPsi());
    }

    public boolean isInProject(@NotNull PsiElement element) {
        if (element == null) {
            PsiManagerImpl.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs;
            for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)element).getDirectories()) {
                if (this.isInProject((PsiElement)dir)) continue;
                return false;
            }
            return true;
        }
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile = null;
        if (file != null) {
            virtualFile = file.getViewProvider().getVirtualFile();
        } else if (element instanceof PsiFileSystemItem) {
            virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        }
        if (file != null && file.isPhysical() && virtualFile.getFileSystem() instanceof NonPhysicalFileSystem) {
            return true;
        }
        return virtualFile != null && ((FileIndexFacade)this.myFileIndex.getValue()).isInContent(virtualFile);
    }

    @Nullable
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            PsiManagerImpl.$$$reportNull$$$0(3);
        }
        return this.myFileManager.findCachedViewProvider(vFile);
    }

    @Override
    @TestOnly
    public void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter, @NotNull Disposable parentDisposable) {
        if (filter == null) {
            PsiManagerImpl.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            PsiManagerImpl.$$$reportNull$$$0(5);
        }
        this.myAssertOnFileLoadingFilter = filter;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
        });
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file) {
        if (file == null) {
            PsiManagerImpl.$$$reportNull$$$0(6);
        }
        return this.myAssertOnFileLoadingFilter.accept(file);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PsiManagerImpl.$$$reportNull$$$0(7);
        }
        return project;
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        FileManagerEx fileManagerEx = this.myFileManager;
        if (fileManagerEx == null) {
            PsiManagerImpl.$$$reportNull$$$0(8);
        }
        return fileManagerEx;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public FileManagerEx getFileManagerEx() {
        FileManagerEx fileManagerEx = this.myFileManager;
        if (fileManagerEx == null) {
            PsiManagerImpl.$$$reportNull$$$0(9);
        }
        return fileManagerEx;
    }

    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        ProgressIndicatorProvider.checkCanceled();
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        return element1.equals((Object)element2) || element1.isEquivalentTo(element2) || element2.isEquivalentTo(element1);
    }

    @RequiresReadLock
    public PsiFile findFile(@NotNull VirtualFile file) {
        if (file == null) {
            PsiManagerImpl.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.softAssertReadAccess();
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findFile(file);
    }

    @ApiStatus.Experimental
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile file, @NotNull CodeInsightContext context) {
        if (file == null) {
            PsiManagerImpl.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PsiManagerImpl.$$$reportNull$$$0(12);
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findFile(file, context);
    }

    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            PsiManagerImpl.$$$reportNull$$$0(13);
        }
        ProgressIndicatorProvider.checkCanceled();
        FileViewProvider fileViewProvider = this.myFileManager.findViewProvider(file);
        if (fileViewProvider == null) {
            PsiManagerImpl.$$$reportNull$$$0(14);
        }
        return fileViewProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file, @NotNull CodeInsightContext context) {
        if (file == null) {
            PsiManagerImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PsiManagerImpl.$$$reportNull$$$0(16);
        }
        ProgressIndicatorProvider.checkCanceled();
        FileViewProvider fileViewProvider = this.myFileManager.findViewProvider(file, context);
        if (fileViewProvider == null) {
            PsiManagerImpl.$$$reportNull$$$0(17);
        }
        return fileViewProvider;
    }

    public PsiDirectory findDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            PsiManagerImpl.$$$reportNull$$$0(18);
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findDirectory(file);
    }

    public void reloadFromDisk(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiManagerImpl.$$$reportNull$$$0(19);
        }
        this.myFileManager.reloadFromDisk(psiFile);
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            PsiManagerImpl.$$$reportNull$$$0(20);
        }
        this.myTreeChangeListeners.add(listener);
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PsiManagerImpl.$$$reportNull$$$0(21);
        }
        if (parentDisposable == null) {
            PsiManagerImpl.$$$reportNull$$$0(22);
        }
        this.addPsiTreeChangeListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> this.removePsiTreeChangeListener(listener));
    }

    @ApiStatus.Experimental
    public void addPsiTreeChangeListenerBackgroundable(@NotNull PsiTreeChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PsiManagerImpl.$$$reportNull$$$0(23);
        }
        if (parentDisposable == null) {
            PsiManagerImpl.$$$reportNull$$$0(24);
        }
        this.myTreeChangeListenersBackgroundable.add(listener);
        Disposer.register((Disposable)parentDisposable, () -> this.myTreeChangeListenersBackgroundable.remove(listener));
    }

    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            PsiManagerImpl.$$$reportNull$$$0(25);
        }
        this.myTreeChangeListeners.remove(listener);
    }

    @NonNls
    private static String logPsi(@Nullable PsiElement element) {
        return element == null ? "null" : element.getClass().getName();
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(26);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildAddition: event = " + (Object)((Object)event));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(27);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildRemoval: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(28);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildReplacement: oldChild = " + PsiManagerImpl.logPsi(event.getOldChild()));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildrenChange(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(29);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildrenChange: parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildMovement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(30);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildMovement: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", oldParent = " + PsiManagerImpl.logPsi(event.getOldParent()) + ", newParent = " + PsiManagerImpl.logPsi(event.getNewParent()));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforePropertyChange(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(31);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforePropertyChange: element = " + PsiManagerImpl.logPsi(event.getElement()) + ", propertyName = " + event.getPropertyName() + ", oldValue = " + PsiManagerImpl.arrayToString(event.getOldValue()));
        }
        this.fireEvent(event);
    }

    private static Object arrayToString(Object value) {
        return value instanceof Object[] ? Arrays.deepToString((Object[])value) : value;
    }

    @Override
    public void childAdded(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(32);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childAdded: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    @Override
    public void childRemoved(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(33);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childRemoved: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    @Override
    public void childReplaced(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(34);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childReplaced: oldChild = " + PsiManagerImpl.logPsi(event.getOldChild()) + ", newChild = " + PsiManagerImpl.logPsi(event.getNewChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    @Override
    public void childMoved(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(35);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childMoved: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", oldParent = " + PsiManagerImpl.logPsi(event.getOldParent()) + ", newParent = " + PsiManagerImpl.logPsi(event.getNewParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    @Override
    public void childrenChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(36);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childrenChanged: parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    @Override
    public void propertyChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(37);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("propertyChanged: element = " + PsiManagerImpl.logPsi(event.getElement()) + ", propertyName = " + event.getPropertyName() + ", oldValue = " + PsiManagerImpl.arrayToString(event.getOldValue()) + ", newValue = " + PsiManagerImpl.arrayToString(event.getNewValue()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    @Override
    @ApiStatus.Internal
    public void addTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor, @NotNull Disposable parentDisposable) {
        if (preprocessor == null) {
            PsiManagerImpl.$$$reportNull$$$0(38);
        }
        if (parentDisposable == null) {
            PsiManagerImpl.$$$reportNull$$$0(39);
        }
        this.myTreeChangePreprocessors.add(preprocessor);
        Disposer.register((Disposable)parentDisposable, () -> this.myTreeChangePreprocessors.remove(preprocessor));
    }

    @Override
    @Deprecated
    public void addTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        if (preprocessor == null) {
            PsiManagerImpl.$$$reportNull$$$0(40);
        }
        this.myTreeChangePreprocessors.add(preprocessor);
    }

    @Override
    @Deprecated
    public void removeTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        if (preprocessor == null) {
            PsiManagerImpl.$$$reportNull$$$0(41);
        }
        this.myTreeChangePreprocessors.remove(preprocessor);
    }

    @Override
    @ApiStatus.Internal
    public void addTreeChangePreprocessorBackgroundable(@NotNull PsiTreeChangePreprocessor preprocessor, @NotNull Disposable parentDisposable) {
        if (preprocessor == null) {
            PsiManagerImpl.$$$reportNull$$$0(42);
        }
        if (parentDisposable == null) {
            PsiManagerImpl.$$$reportNull$$$0(43);
        }
        this.myTreeChangePreprocessorsBackgroundable.add(preprocessor);
        Disposer.register((Disposable)parentDisposable, () -> this.myTreeChangePreprocessorsBackgroundable.remove(preprocessor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(44);
        }
        boolean isRealTreeChange = event.getCode() != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && event.getCode() != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE;
        PsiFile file = event.getFile();
        if (file == null || file.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (isRealTreeChange) {
            LOG.assertTrue(!this.myTreeChangeEventIsFiring, (Object)"Changes to PSI are not allowed inside event processing");
            this.myTreeChangeEventIsFiring = true;
        }
        try {
            for (PsiTreeChangePreprocessor preprocessor : this.myTreeChangePreprocessorsBackgroundable) {
                preprocessor.treeChanged(event);
            }
            if (!this.myTreeChangePreprocessors.isEmpty()) {
                PsiManagerImpl.runWriteActionOnEdtRegardlessOfCurrentThread(() -> {
                    for (PsiTreeChangePreprocessor preprocessor : this.myTreeChangePreprocessors) {
                        preprocessor.treeChanged(event);
                    }
                });
            }
            for (PsiTreeChangePreprocessor preprocessor : PsiTreeChangePreprocessor.EP.getExtensions((AreaInstance)this.myProject)) {
                try {
                    preprocessor.treeChanged(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            for (PsiTreeChangeListener listener : this.myTreeChangeListenersBackgroundable) {
                PsiManagerImpl.notifyPsiTreeChangeListener(event, listener);
            }
            List listeners = PsiTreeChangeListener.EP.getExtensions((AreaInstance)this.myProject);
            if (!this.myTreeChangeListeners.isEmpty() && !listeners.isEmpty()) {
                PsiManagerImpl.runWriteActionOnEdtRegardlessOfCurrentThread(() -> {
                    for (PsiTreeChangeListener listener : this.myTreeChangeListeners) {
                        PsiManagerImpl.notifyPsiTreeChangeListener(event, listener);
                    }
                    for (PsiTreeChangeListener listener : PsiTreeChangeListener.EP.getExtensions((AreaInstance)this.myProject)) {
                        PsiManagerImpl.notifyPsiTreeChangeListener(event, listener);
                    }
                });
            }
        }
        finally {
            if (isRealTreeChange) {
                this.myTreeChangeEventIsFiring = false;
            }
        }
    }

    @RequiresWriteLock
    @ApiStatus.Internal
    public static void runWriteActionOnEdtRegardlessOfCurrentThread(Runnable runnable) {
        Runnable action2;
        ThreadingAssertions.assertWriteAccess();
        if (EDT.isCurrentThreadEdt()) {
            action2.run();
        } else {
            Application application = ApplicationManager.getApplication();
            TransferredWriteActionService service = (TransferredWriteActionService)application.getService(TransferredWriteActionService.class);
            service.runOnEdtWithTransferredWriteActionAndWait(action2);
        }
    }

    private static void notifyPsiTreeChangeListener(@NotNull PsiTreeChangeEventImpl event, PsiTreeChangeListener listener) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(45);
        }
        try {
            switch (event.getCode()) {
                case BEFORE_CHILD_ADDITION: {
                    listener.beforeChildAddition((PsiTreeChangeEvent)event);
                    break;
                }
                case BEFORE_CHILD_REMOVAL: {
                    listener.beforeChildRemoval((PsiTreeChangeEvent)event);
                    break;
                }
                case BEFORE_CHILD_REPLACEMENT: {
                    listener.beforeChildReplacement((PsiTreeChangeEvent)event);
                    break;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    listener.beforeChildMovement((PsiTreeChangeEvent)event);
                    break;
                }
                case BEFORE_CHILDREN_CHANGE: {
                    listener.beforeChildrenChange((PsiTreeChangeEvent)event);
                    break;
                }
                case BEFORE_PROPERTY_CHANGE: {
                    listener.beforePropertyChange((PsiTreeChangeEvent)event);
                    break;
                }
                case CHILD_ADDED: {
                    listener.childAdded((PsiTreeChangeEvent)event);
                    break;
                }
                case CHILD_REMOVED: {
                    listener.childRemoved((PsiTreeChangeEvent)event);
                    break;
                }
                case CHILD_REPLACED: {
                    listener.childReplaced((PsiTreeChangeEvent)event);
                    break;
                }
                case CHILD_MOVED: {
                    listener.childMoved((PsiTreeChangeEvent)event);
                    break;
                }
                case CHILDREN_CHANGED: {
                    listener.childrenChanged((PsiTreeChangeEvent)event);
                    break;
                }
                case PROPERTY_CHANGED: {
                    listener.propertyChanged((PsiTreeChangeEvent)event);
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                LOG.warn(e);
            }
            LOG.error(e);
        }
    }

    @Override
    public void beforeChange(boolean isPhysical) {
        ((AnyPsiChangeListener)this.myProject.getMessageBus().syncPublisher(ANY_PSI_CHANGE_TOPIC)).beforePsiChanged(isPhysical);
    }

    @Override
    public void afterChange(boolean isPhysical) {
        ((AnyPsiChangeListener)this.myProject.getMessageBus().syncPublisher(ANY_PSI_CHANGE_TOPIC)).afterPsiChanged(isPhysical);
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = this.myModificationTracker;
        if (psiModificationTracker == null) {
            PsiManagerImpl.$$$reportNull$$$0(46);
        }
        return psiModificationTracker;
    }

    public void startBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.incrementAndGet();
    }

    public void finishBatchFilesProcessingMode() {
        int after = this.myBatchFilesProcessingModeCount.decrementAndGet();
        LOG.assertTrue(after >= 0);
    }

    public <T> T runInBatchFilesMode(@NotNull Computable<T> runnable) {
        if (runnable == null) {
            PsiManagerImpl.$$$reportNull$$$0(47);
        }
        this.startBatchFilesProcessingMode();
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            this.finishBatchFilesProcessingMode();
        }
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return this.myBatchFilesProcessingModeCount.get() > 0;
    }

    @Override
    @TestOnly
    public void cleanupForNextTest() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileManager.cleanupForNextTest();
        this.dropPsiCaches();
    }

    @Override
    public void dropResolveCacheRegularly(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PsiManagerImpl.$$$reportNull$$$0(48);
        }
        if ((indicator = ProgressWrapper.unwrap(indicator)) instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate(new AbstractProgressIndicatorExBase(){
                private final AtomicLong lastClearedTimeStamp = new AtomicLong();

                @Override
                public void setFraction(double fraction) {
                    long last;
                    long current = System.currentTimeMillis();
                    if (current - (last = this.lastClearedTimeStamp.get()) >= 500L && this.lastClearedTimeStamp.compareAndSet(last, current)) {
                        PsiManagerImpl.this.dropResolveCaches();
                    }
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: 
            case 22: 
            case 24: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiManagerImpl";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessor";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManagerEx";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewProvider";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAssertOnFileLoadingFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAssertOnFileLoading";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 46: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addPsiTreeChangeListener";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addPsiTreeChangeListenerBackgroundable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removePsiTreeChangeListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildAddition";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildRemoval";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildReplacement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildrenChange";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildMovement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "childAdded";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "childRemoved";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "childReplaced";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "childMoved";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "childrenChanged";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addTreeChangePreprocessor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeTreeChangePreprocessor";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addTreeChangePreprocessorBackgroundable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "notifyPsiTreeChangeListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "runInBatchFilesMode";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "dropResolveCacheRegularly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

