/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbModeListenerBackgroundable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiModificationTrackerImpl
implements PsiModificationTracker,
PsiTreeChangePreprocessor {
    private final SimpleModificationTracker myModificationCount;
    private final SimpleModificationTracker myAllLanguagesTracker;
    private final Map<Language, SimpleModificationTracker> myLanguageTrackers;
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(@NotNull Project project) {
        if (project == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(0);
        }
        this.myModificationCount = new SimpleModificationTracker();
        this.myAllLanguagesTracker = new SimpleModificationTracker();
        this.myLanguageTrackers = ConcurrentFactoryMap.createWeakMap(language -> new SimpleModificationTracker());
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbModeListenerBackgroundable.TOPIC, (Object)new DumbModeListenerBackgroundable(){

            public void enteredDumbMode() {
                PsiModificationTrackerImpl.this.doIncCounter();
            }

            public void exitDumbMode() {
                PsiModificationTrackerImpl.this.doIncCounter();
            }
        });
    }

    private void doIncCounter() {
        ApplicationManager.getApplication().runWriteAction(() -> this.incCountersInner());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void incCounter() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incCountersInner();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void incOutOfCodeBlockModificationCounter() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incCountersInner();
    }

    private void fireEvent() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myPublisher.modificationCountChanged();
    }

    private void incCountersInner() {
        this.myModificationCount.incModificationCount();
        this.fireEvent();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(1);
        }
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        this.incLanguageCounters(event);
        this.incCountersInner();
    }

    public static boolean canAffectPsi(@NotNull PsiTreeChangeEventImpl event) {
        PsiTreeChangeEventImpl.PsiEventType code;
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(2);
        }
        return (code = event.getCode()) != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE && (code != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED || !Strings.areSameInstance((String)event.getPropertyName(), (String)"writable"));
    }

    private void incLanguageCounters(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(3);
        }
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        String propertyName = event.getPropertyName();
        if (code == PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && (Strings.areSameInstance((String)propertyName, (String)"propUnloadedPsi") || Strings.areSameInstance((String)propertyName, (String)"roots") || Strings.areSameInstance((String)propertyName, (String)"propFileTypes")) || code == PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED && event.getChild() instanceof PsiDirectory) {
            this.myAllLanguagesTracker.incModificationCount();
            return;
        }
        PsiElement[] elements = new PsiElement[]{event.getFile(), event.getParent(), event.getOldParent(), event.getNewParent(), event.getElement(), event.getChild(), event.getOldChild(), event.getNewChild()};
        this.incLanguageModificationCount(Language.ANY);
        for (PsiElement o : elements) {
            if (o == null || o instanceof PsiDirectory) continue;
            if (o instanceof PsiFile) {
                for (Language language : ((PsiFile)o).getViewProvider().getLanguages()) {
                    this.incLanguageModificationCount(language);
                }
                continue;
            }
            try {
                Language language;
                IElementType type = PsiUtilCore.getElementType((PsiElement)o);
                language = type != null ? type.getLanguage() : o.getLanguage();
                this.incLanguageModificationCount(language);
            }
            catch (PsiInvalidElementAccessException e) {
                Logger.getInstance(this.getClass()).warn((Throwable)e);
            }
        }
    }

    public long getModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    @NotNull
    public ModificationTracker getJavaStructureModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationCount;
        if (simpleModificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(4);
        }
        return simpleModificationTracker;
    }

    @ApiStatus.Experimental
    public void incLanguageModificationCount(@Nullable Language language) {
        if (language == null) {
            return;
        }
        this.myLanguageTrackers.get(language).incModificationCount();
    }

    @NotNull
    public ModificationTracker forLanguage(@NotNull Language language) {
        if (language == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(5);
        }
        SimpleModificationTracker languageTracker = this.myLanguageTrackers.get(language);
        ModificationTracker modificationTracker = () -> languageTracker.getModificationCount() + this.myAllLanguagesTracker.getModificationCount();
        if (modificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(6);
        }
        return modificationTracker;
    }

    @NotNull
    public ModificationTracker forLanguages(@NotNull Predicate<? super Language> condition) {
        if (condition == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(7);
        }
        ModificationTracker modificationTracker = () -> {
            long result = this.myAllLanguagesTracker.getModificationCount();
            for (Language l : this.myLanguageTrackers.keySet()) {
                if (!condition.test(l)) continue;
                result += this.myLanguageTrackers.get(l).getModificationCount();
            }
            return result;
        };
        if (modificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(8);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaStructureModificationTracker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "treeChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canAffectPsi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "incLanguageCounters";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forLanguages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

