/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedImplUtil {
    private static final Logger LOG = Logger.getInstance(SharedImplUtil.class);
    private static final boolean CHECK_FOR_READ_ACTION = DebugUtil.DO_EXPENSIVE_CHECKS || ApplicationManager.getApplication().isInternal();

    private SharedImplUtil() {
    }

    public static PsiElement getParent(@NotNull ASTNode thisElement) {
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(0);
        }
        if (CHECK_FOR_READ_ACTION && thisElement instanceof TreeElement) {
            ((TreeElement)thisElement).assertReadAccessAllowed();
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeParent());
    }

    public static PsiElement getFirstChild(@NotNull ASTNode element) {
        if (element == null) {
            SharedImplUtil.$$$reportNull$$$0(1);
        }
        return SourceTreeToPsiMap.treeElementToPsi(element.getFirstChildNode());
    }

    @Nullable
    public static PsiElement getLastChild(@NotNull ASTNode element) {
        if (element == null) {
            SharedImplUtil.$$$reportNull$$$0(2);
        }
        return SourceTreeToPsiMap.treeElementToPsi(element.getLastChildNode());
    }

    public static PsiElement getNextSibling(@NotNull ASTNode thisElement) {
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(3);
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeNext());
    }

    public static PsiElement getPrevSibling(@NotNull ASTNode thisElement) {
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(4);
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreePrev());
    }

    public static PsiFile getContainingFile(@NotNull ASTNode thisElement) {
        FileASTNode node;
        PsiElement psi;
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = psi = (node = SharedImplUtil.findFileElement(thisElement)) == null ? null : node.getPsi();
        if (psi == null || psi instanceof PsiFile) {
            return (PsiFile)psi;
        }
        throw new AssertionError((Object)("Invalid PSI " + psi + " of " + psi.getClass() + " for AST " + node + " of " + node.getClass()));
    }

    public static boolean isValid(@NotNull ASTNode thisElement) {
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(thisElement instanceof PsiElement);
        PsiFile file = SharedImplUtil.getContainingFile(thisElement);
        return file != null && file.isValid();
    }

    public static boolean isWritable(@NotNull ASTNode thisElement) {
        PsiFile file;
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(7);
        }
        return (file = SharedImplUtil.getContainingFile(thisElement)) == null || file.isWritable();
    }

    public static FileASTNode findFileElement(@NotNull ASTNode element) {
        if (element == null) {
            SharedImplUtil.$$$reportNull$$$0(8);
        }
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            element = parent;
        }
        if (CHECK_FOR_READ_ACTION && element instanceof TreeElement) {
            ((TreeElement)element).assertReadAccessAllowed();
        }
        if (element instanceof FileASTNode) {
            return (FileASTNode)element;
        }
        return null;
    }

    @NotNull
    public static CharTable findCharTableByTree(@NotNull ASTNode tree) {
        if (tree == null) {
            SharedImplUtil.$$$reportNull$$$0(9);
        }
        for (ASTNode o = tree; o != null; o = o.getTreeParent()) {
            CharTable charTable = (CharTable)o.getUserData(CharTable.CHAR_TABLE_KEY);
            if (charTable != null) {
                CharTable charTable2 = charTable;
                if (charTable2 == null) {
                    SharedImplUtil.$$$reportNull$$$0(10);
                }
                return charTable2;
            }
            if (!(o instanceof FileASTNode)) continue;
            CharTable charTable3 = ((FileASTNode)o).getCharTable();
            if (charTable3 == null) {
                SharedImplUtil.$$$reportNull$$$0(11);
            }
            return charTable3;
        }
        throw new AssertionError((Object)("CharTable not found in: " + tree));
    }

    public static PsiElement addRange(@NotNull PsiElement thisElement, @NotNull PsiElement first, @NotNull PsiElement last, @Nullable ASTNode anchor, @Nullable Boolean before) throws IncorrectOperationException {
        ASTNode element;
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(12);
        }
        if (first == null) {
            SharedImplUtil.$$$reportNull$$$0(13);
        }
        if (last == null) {
            SharedImplUtil.$$$reportNull$$$0(14);
        }
        CheckUtil.checkWritable(thisElement);
        CharTable table = SharedImplUtil.findCharTableByTree(SourceTreeToPsiMap.psiElementToTree(thisElement));
        TreeElement copyFirst = null;
        TreeElement copyLast = null;
        ASTNode next = SourceTreeToPsiMap.psiElementToTree(last).getTreeNext();
        CompositeElement parent = null;
        for (element = SourceTreeToPsiMap.psiElementToTree(first); element != next; element = element.getTreeNext()) {
            TreeElement elementCopy = ChangeUtil.copyElement((TreeElement)element, table);
            if (element == first.getNode()) {
                copyFirst = elementCopy;
            }
            if (element == last.getNode()) {
                copyLast = elementCopy;
            }
            if (parent == null) {
                parent = elementCopy.getTreeParent();
                continue;
            }
            if (elementCopy.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.setNodeGenerated(elementCopy, true);
            }
            parent.addChild(elementCopy, null);
        }
        if (copyFirst == null) {
            return null;
        }
        copyFirst = ((CompositeElement)SourceTreeToPsiMap.psiElementToTree(thisElement)).addInternal(copyFirst, copyLast, anchor, before);
        for (element = copyFirst; element != null; element = element.getTreeNext()) {
            if ((element = ChangeUtil.decodeInformation((TreeElement)element)).getTreePrev() != null) continue;
            copyFirst = element;
        }
        return SourceTreeToPsiMap.treeElementToPsi(copyFirst);
    }

    public static PsiManager getManagerByTree(@NotNull ASTNode node) {
        if (node == null) {
            SharedImplUtil.$$$reportNull$$$0(15);
        }
        if (node instanceof FileElement) {
            return node.getPsi().getManager();
        }
        return node.getTreeParent().getPsi().getManager();
    }

    @NotNull
    public static @NotNull ASTNode @NotNull [] getChildrenOfType(@NotNull ASTNode node, @NotNull IElementType elementType) {
        int count;
        if (node == null) {
            SharedImplUtil.$$$reportNull$$$0(16);
        }
        if (elementType == null) {
            SharedImplUtil.$$$reportNull$$$0(17);
        }
        if ((count = SharedImplUtil.countChildrenOfType(node, elementType)) == 0) {
            if (ASTNode.EMPTY_ARRAY == null) {
                SharedImplUtil.$$$reportNull$$$0(18);
            }
            return ASTNode.EMPTY_ARRAY;
        }
        ASTNode[] result = new ASTNode[count];
        count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            result[count++] = child;
        }
        if (result == null) {
            SharedImplUtil.$$$reportNull$$$0(19);
        }
        return result;
    }

    private static int countChildrenOfType(@NotNull ASTNode node, @NotNull IElementType elementType) {
        if (node == null) {
            SharedImplUtil.$$$reportNull$$$0(20);
        }
        if (elementType == null) {
            SharedImplUtil.$$$reportNull$$$0(21);
        }
        int count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            ++count;
        }
        return count;
    }

    public static void acceptChildren(@NotNull PsiElementVisitor visitor, @NotNull ASTNode root) {
        if (visitor == null) {
            SharedImplUtil.$$$reportNull$$$0(22);
        }
        if (root == null) {
            SharedImplUtil.$$$reportNull$$$0(23);
        }
        for (ASTNode childNode = root.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            Object psi = childNode instanceof PsiElement ? (PsiElement)childNode : SourceTreeToPsiMap.treeToPsiNotNull(childNode);
            psi.accept(visitor);
        }
    }

    public static PsiElement doReplace(@NotNull PsiElement psiElement, @NotNull TreeElement treeElement, @NotNull PsiElement newElement) {
        CompositeElement treeParent;
        if (psiElement == null) {
            SharedImplUtil.$$$reportNull$$$0(24);
        }
        if (treeElement == null) {
            SharedImplUtil.$$$reportNull$$$0(25);
        }
        if (newElement == null) {
            SharedImplUtil.$$$reportNull$$$0(26);
        }
        LOG.assertTrue((treeParent = treeElement.getTreeParent()) != null);
        CheckUtil.checkWritable(psiElement);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        treeParent.replaceChildInternal(treeElement, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisElement";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/SharedImplUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/SharedImplUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findCharTableByTree";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChild";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLastChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCharTableByTree";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getManagerByTree";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "countChildrenOfType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doReplace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

