/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.SequentialTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequentialModalProgressTask
extends Task.Modal {
    private static final Logger LOG = Logger.getInstance(SequentialModalProgressTask.class);
    private static final long DEFAULT_MIN_ITERATION_MIN_TIME = 500L;
    private long myMinIterationTime;
    private ProgressIndicator myIndicator;
    private SequentialTask myTask;

    public SequentialModalProgressTask(@Nullable Project project, @NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(0);
        }
        this(project, title, true);
    }

    public SequentialModalProgressTask(@Nullable Project project, @NlsContexts.DialogTitle @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(1);
        }
        super(project, title, canBeCancelled);
        this.myMinIterationTime = 500L;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(2);
        }
        try {
            this.doRun(indicator);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception occurred during processing sequential task '" + this.getTitle() + "'", (Throwable)e);
        }
    }

    public void doRun(@NotNull ProgressIndicator indicator) {
        SequentialTask task;
        if (indicator == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(3);
        }
        if ((task = this.myTask) == null) {
            return;
        }
        this.myIndicator = indicator;
        indicator.setIndeterminate(false);
        this.prepare(task);
        while (!task.isDone()) {
            if (indicator.isCanceled()) {
                task.stop();
                break;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                long start = System.currentTimeMillis();
                try {
                    while (!task.isDone() && System.currentTimeMillis() - start < this.myMinIterationTime) {
                        task.iteration(indicator);
                    }
                }
                catch (RuntimeException e) {
                    task.stop();
                    throw e;
                }
            });
        }
    }

    public void setMinIterationTime(long minIterationTime) {
        this.myMinIterationTime = minIterationTime;
    }

    public void setTask(@Nullable SequentialTask task) {
        this.myTask = task;
    }

    public ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    protected void prepare(@NotNull SequentialTask task) {
        if (task == null) {
            SequentialModalProgressTask.$$$reportNull$$$0(4);
        }
        task.prepare();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/SequentialModalProgressTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

