/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/java/decompiler/ShowDecompiledClassAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getPsiElement", "Lcom/intellij/psi/PsiElement;", "getOriginalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElement", "intellij.java.decompiler"})
public final class ShowDecompiledClassAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement2 = psiElement = this.getPsiElement(e);
        boolean visible = (psiElement2 != null ? psiElement2.getContainingFile() : null) instanceof PsiClassOwner;
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && this.getOriginalFile(psiElement) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null && (file = this.getOriginalFile(this.getPsiElement(e))) != null) {
            PsiNavigationSupport.getInstance().createNavigatable(project, file, -1).navigate(true);
        }
    }

    private final PsiElement getPsiElement(AnActionEvent e) {
        PsiElement element;
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
            v2 = psiFile != null ? psiFile.findElementAt(editor.getCaretModel().getOffset()) : null;
        } else {
            v2 = element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        }
        if (element == null || !element.isValid()) {
            return null;
        }
        return element;
    }

    private final VirtualFile getOriginalFile(PsiElement psiElement) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        PsiClass psiClass2 = psiClass;
        VirtualFile file = psiClass2 != null && (psiClass2 = psiClass2.getOriginalElement()) != null && (psiClass2 = psiClass2.getContainingFile()) != null ? psiClass2.getVirtualFile() : null;
        return file != null && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaClassFileType.INSTANCE) ? file : null;
    }
}

