/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate.autowire;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SuperClassSpringComponentStub;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0003\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0000\u001a\b\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00102\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0016H\u0000\u001a\u001c\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u00a8\u0006\u001d"}, d2={"beanLocation", "", "bean", "Lcom/intellij/spring/model/SpringBeanPointer;", "isCollection", "", "effectiveBeanType", "Lcom/intellij/psi/PsiType;", "beanInjectionCandidate", "beanPointer", "createCollectionType", "context", "Lcom/intellij/psi/PsiElement;", "elementType", "getCollectionType", "getBaseClassesAndInterfaces", "", "", "Lcom/intellij/spring/model/jam/stereotype/SuperClassSpringComponentStub;", "aClass", "Lcom/intellij/psi/PsiClass;", "springBean", "Lcom/intellij/spring/model/CommonSpringBean;", "isPermittedAutowireBeanType", "commonSpringBean", "checkAutowireCandidate", "uClass", "Lorg/jetbrains/uast/UClass;", "candidate", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nautowireBeanUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 autowireBeanUtils.kt\ncom/intellij/spring/model/actions/generate/autowire/AutowireBeanUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,117:1\n1642#2,10:118\n1915#2:128\n1916#2:130\n1652#2:131\n1586#2:132\n1661#2,3:133\n1586#2:136\n1661#2,3:137\n1#3:129\n176#4:140\n*S KotlinDebug\n*F\n+ 1 autowireBeanUtils.kt\ncom/intellij/spring/model/actions/generate/autowire/AutowireBeanUtilsKt\n*L\n46#1:118,10\n46#1:128\n46#1:130\n46#1:131\n94#1:132\n94#1:133,3\n98#1:136\n98#1:137,3\n46#1:129\n111#1:140\n*E\n"})
public final class AutowireBeanUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nls
    private static final String beanLocation(SpringBeanPointer<?> bean, boolean isCollection) {
        String string;
        if (isCollection) {
            string = SpringBundle.message("spring.injection.variants.collection", new Object[0]);
        } else if (bean.getSpringBean() instanceof SuperClassSpringComponentStub) {
            string = SpringBundle.message("spring.injection.variants.primary", new Object[0]);
        } else {
            Collection collection = bean.getSpringBean().getSpringQualifiers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSpringQualifiers(...)");
            Collection springQualifiers = collection;
            if (springQualifiers.isEmpty()) {
                string = null;
            } else {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object[] objectArray = new Object[1];
                Iterable iterable = springQualifiers;
                int n = 0;
                Object[] objectArray2 = objectArray;
                String string2 = "spring.injection.variants.qualifier";
                boolean $i$f$mapNotNull = false;
                void var6_9 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    SpringQualifier it = (SpringQualifier)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getQualifierValue() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                objectArray2[n] = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                string = SpringBundle.message(string2, objectArray);
            }
        }
        return string;
    }

    @Nullable
    public static final PsiType effectiveBeanType(@NotNull SpringBeanPointer<?> beanInjectionCandidate, @NotNull SpringBeanPointer<?> beanPointer) {
        Intrinsics.checkNotNullParameter(beanInjectionCandidate, (String)"beanInjectionCandidate");
        Intrinsics.checkNotNullParameter(beanPointer, (String)"beanPointer");
        PsiClass psiClass = beanInjectionCandidate.getBeanClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass injectionClass = psiClass;
        PsiType psiType = beanInjectionCandidate.getSpringBean().getBeanType();
        if (psiType == null) {
            return null;
        }
        PsiType injectionType = psiType;
        if (injectionClass.hasTypeParameters()) {
            PsiType psiType2 = beanPointer.getSpringBean().getBeanType();
            if (psiType2 == null) {
                return null;
            }
            PsiType beanType = psiType2;
            Ref.ObjectRef effectiveBeanType2 = new Ref.ObjectRef();
            effectiveBeanType2.element = beanType;
            InheritanceUtil.processSuperTypes((PsiType)beanType, (boolean)true, (Processor)((Processor)new Processor<PsiType>(injectionType, (Ref.ObjectRef<PsiType>)effectiveBeanType2){
                final /* synthetic */ PsiType $injectionType;
                final /* synthetic */ Ref.ObjectRef<PsiType> $effectiveBeanType;
                {
                    this.$injectionType = $injectionType;
                    this.$effectiveBeanType = $effectiveBeanType;
                }

                public boolean process(PsiType t) {
                    PsiType $this$asSafely$iv = t;
                    boolean $i$f$asSafely = false;
                    PsiType psiType = $this$asSafely$iv;
                    if (!(psiType instanceof PsiClassType)) {
                        psiType = null;
                    }
                    PsiClassType psiClassType = (PsiClassType)psiType;
                    if (psiClassType == null) {
                        return false;
                    }
                    PsiClassType psiClassType2 = psiClassType;
                    if (Intrinsics.areEqual((Object)psiClassType2.rawType(), (Object)this.$injectionType)) {
                        this.$effectiveBeanType.element = psiClassType2;
                        return false;
                    }
                    return true;
                }
            }));
            return (PsiType)effectiveBeanType2.element;
        }
        Collection collection = beanInjectionCandidate.getEffectiveBeanTypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEffectiveBeanTypes(...)");
        return (PsiType)CollectionsKt.firstOrNull((Iterable)collection);
    }

    @NotNull
    public static final PsiType createCollectionType(@NotNull PsiElement context, @NotNull PsiType elementType) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        PsiType psiType = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeFromText(AutowireBeanUtilsKt.getCollectionType() + "<" + elementType.getCanonicalText() + ">", context);
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"createTypeFromText(...)");
        return psiType;
    }

    private static final String getCollectionType() {
        return "java.util.Collection";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<SpringBeanPointer<?>> getBaseClassesAndInterfaces(@NotNull SpringBeanPointer<?> beanPointer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(beanPointer, (String)"beanPointer");
        CommonSpringBean commonSpringBean = beanPointer.getSpringBean();
        Intrinsics.checkNotNullExpressionValue((Object)commonSpringBean, (String)"getSpringBean(...)");
        CommonSpringBean bean = commonSpringBean;
        if (bean instanceof SpringRepository) {
            return CollectionsKt.emptyList();
        }
        PsiClass psiClass = beanPointer.getBeanClass();
        BeanService beanService = BeanService.getInstance();
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        List baseClassModels = CollectionsKt.toMutableList((Collection)AutowireBeanUtilsKt.getBaseClassesAndInterfaces(psiClass, bean));
        CommonSpringBean classModel = (CommonSpringBean)new SuperClassSpringComponentStub(psiClass, bean);
        if (!Intrinsics.areEqual((Object)classModel.getBeanName(), (Object)bean.getBeanName())) {
            baseClassModels.add(classModel);
        }
        Iterable iterable = baseClassModels;
        Intrinsics.checkNotNull((Object)beanService);
        BeanService beanService2 = beanService;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            CommonSpringBean commonSpringBean2 = (CommonSpringBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(beanService2.createSpringBeanPointer((CommonSpringBean)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SuperClassSpringComponentStub> getBaseClassesAndInterfaces(PsiClass aClass, CommonSpringBean springBean) {
        void $this$mapTo$iv$iv;
        List list = SpringCommonUtils.getAllSupersExceptBaseClasses((PsiClass)aClass);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSupersExceptBaseClasses(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void psiClass;
            PsiClass psiClass2 = (PsiClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SuperClassSpringComponentStub((PsiClass)psiClass, springBean));
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isPermittedAutowireBeanType(@NotNull CommonSpringBean commonSpringBean) {
        Intrinsics.checkNotNullParameter((Object)commonSpringBean, (String)"commonSpringBean");
        CommonSpringBean springBean = commonSpringBean instanceof SuperClassSpringComponentStub ? ((SuperClassSpringComponentStub)commonSpringBean).getOriginalBean() : commonSpringBean;
        return !(springBean instanceof SpringController) && !(springBean instanceof SpringConfiguration);
    }

    public static final boolean checkAutowireCandidate(@NotNull UClass uClass, @NotNull SpringBeanPointer<?> candidate) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        CommonSpringBean commonSpringBean = candidate.getSpringBean();
        Intrinsics.checkNotNullExpressionValue((Object)commonSpringBean, (String)"getSpringBean(...)");
        CommonSpringBean springBean = commonSpringBean;
        if (!AutowireBeanUtilsKt.isPermittedAutowireBeanType(springBean)) {
            return false;
        }
        PsiElement $this$toUElementOfType$iv = (PsiElement)candidate.getBeanClass();
        boolean $i$f$toUElementOfType = false;
        UClass uClass2 = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
        if (uClass2 == null) {
            return false;
        }
        UClass uBeanClass = uClass2;
        if (UastVisibility.PACKAGE_LOCAL == uBeanClass.getVisibility()) {
            UFile uFile = UastUtils.getContainingUFile((UElement)((UElement)uBeanClass));
            UFile uFile2 = UastUtils.getContainingUFile((UElement)((UElement)uClass));
            return Intrinsics.areEqual((Object)(uFile != null ? uFile.getPackageName() : null), (Object)(uFile2 != null ? uFile2.getPackageName() : null));
        }
        return true;
    }

    public static final /* synthetic */ String access$beanLocation(SpringBeanPointer bean, boolean isCollection) {
        return AutowireBeanUtilsKt.beanLocation(bean, isCollection);
    }
}

