/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionUtil;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;

public final class SpringAutowiredFieldsWarningInspection
extends SpringUastInspectionBase {
    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(1);
        }
        PsiClass javaPsiClass = aClass.getJavaPsi();
        PsiElement sourcePsi = aClass.getSourcePsi();
        if (sourcePsi == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile sourcePsiFile = sourcePsi.getContainingFile();
        if (!ProjectRootsUtil.isInTestSource((PsiFile)sourcePsiFile)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
            if (!SpringCommonUtils.isSpringConfigured((Module)module)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (!SpringCommonUtils.isStereotypeComponentOrMeta((PsiClass)javaPsiClass)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (!SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_4_3)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            Collection<String> annotations = SpringAutowireUtil.getAutowiredAnnotations(module);
            Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> autowiredFields = SpringAutowiredFieldsWarningInspection.getAutowiredFields(javaPsiClass, annotations);
            if (!autowiredFields.isEmpty()) {
                SpringJavaClassInfo.MappedBeanInfo mappedBeanInfo = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)javaPsiClass).resolve();
                for (JamSpringBeanPointer pointer : mappedBeanInfo.getStereotypeMappedBeans()) {
                    if (!(pointer.getSpringBean() instanceof ContextJavaBean)) continue;
                    return ProblemDescriptor.EMPTY_ARRAY;
                }
            }
            LocalQuickFix allFieldsFix = null;
            if (autowiredFields.size() > 1) {
                allFieldsFix = SpringAutowiredFieldsWarningInspection.getFieldsAutowiredFix(javaPsiClass, autowiredFields, annotations);
            }
            ProblemsHolder holder = new ProblemsHolder(manager, sourcePsiFile, isOnTheFly);
            for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : autowiredFields) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fieldFx = SpringAutowiredFieldsWarningInspection.getFieldsAutowiredFix(javaPsiClass, Collections.singleton(pair), annotations);
                if (allFieldsFix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                    localQuickFixArray2[0] = fieldFx;
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[1] = allFieldsFix;
                } else {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = fieldFx;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                PsiAnnotation psiAnnotation = (PsiAnnotation)((SmartPsiElementPointer)pair.getSecond()).getElement();
                PsiElement annotationSource = SpringUastInspectionUtil.INSTANCE.convertToSourcePsi((PsiElement)psiAnnotation);
                if (annotationSource == null) continue;
                holder.registerProblem(annotationSource, SpringBundle.message("field.injection.is.not.recommended", new Object[0]), JamCommonUtil.isPlainJavaFile((PsiElement)sourcePsiFile) ? fixes : LocalQuickFix.EMPTY_ARRAY);
            }
            return holder.getResultsArray();
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> getAutowiredFields(@NotNull PsiClass aClass, @NotNull Collection<String> annotations) {
        if (aClass == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(2);
        }
        if (annotations == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(3);
        }
        HashSet<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs = new HashSet<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>>();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)aClass.getProject());
        for (PsiField psiField : aClass.getFields()) {
            for (String autowiredAnno : annotations) {
                PsiAnnotation annotation;
                if (autowiredAnno.equals("javax.annotation.Resource") || autowiredAnno.equals("jakarta.annotation.Resource") || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (String[])new String[]{autowiredAnno})) == null) continue;
                smartPointerManager.createSmartPsiElementPointer((PsiElement)psiField);
                pairs.add((Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>)Pair.create((Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)psiField), (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)annotation)));
            }
        }
        return pairs;
    }

    private static LocalQuickFix getFieldsAutowiredFix(PsiClass aClass, Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> fields, Collection<String> annotations) {
        PsiMethod constructor = SpringAutowiredFieldsWarningInspection.findAutowiredConstructor(aClass, annotations);
        return constructor != null ? new AddParameterQuickFix(constructor, fields) : new CreateAutowiredConstructorQuickFix(aClass, fields);
    }

    @Nullable
    private static PsiMethod findAutowiredConstructor(@NotNull PsiClass aClass, @NotNull Collection<String> annotations) {
        PsiMethod[] constructors;
        if (aClass == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(4);
        }
        if (annotations == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(5);
        }
        if ((constructors = aClass.getConstructors()).length == 1) {
            return constructors[0] instanceof LightElement ? null : constructors[0];
        }
        for (PsiMethod method : constructors) {
            if (method instanceof LightElement || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, annotations, (int)0)) continue;
            return method;
        }
        return null;
    }

    private static void addAutowiredAnnotationIfNeeded(@Nullable PsiClass psiClass, @NotNull PsiMethod constructor, @NotNull String fqnAnno) {
        if (constructor == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(6);
        }
        if (fqnAnno == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(7);
        }
        if (psiClass == null || psiClass.getConstructors().length == 1) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)constructor.getProject()).getElementFactory();
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText("@" + fqnAnno, null);
        PsiModifierList modifierList = constructor.getModifierList();
        PsiElement element = modifierList.getFirstChild();
        if (element != null) {
            modifierList.addBefore((PsiElement)psiAnnotation, element);
        } else {
            modifierList.add((PsiElement)psiAnnotation);
        }
    }

    @NotNull
    private static String getAutowiredAnnotation(@NotNull SmartPsiElementPointer<PsiAnnotation> anno) {
        String qualifiedName;
        PsiAnnotation annotation;
        if (anno == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(8);
        }
        if ((annotation = (PsiAnnotation)anno.getElement()) != null && annotation.isValid() && StringUtil.isNotEmpty((String)(qualifiedName = annotation.getQualifiedName()))) {
            String string = qualifiedName;
            if (string == null) {
                SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(9);
            }
            return string;
        }
        return "org.springframework.beans.factory.annotation.Autowired";
    }

    private static void addParameters(Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates, PsiMethod constructor) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)constructor.getProject()).getElementFactory();
        Map qualifierAnnotationClassNames = FactoryMap.create(module -> JamAnnotationTypeUtil.getInstance((Project)module.getProject()).getQualifierAnnotationNamesWithChildren(module));
        for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : myParameterCandidates) {
            PsiClass containingClass;
            PsiModifierList fieldModifierList;
            PsiField field = (PsiField)((SmartPsiElementPointer)pair.first).getElement();
            PsiAnnotation annotation = (PsiAnnotation)((SmartPsiElementPointer)pair.second).getElement();
            if (field == null || annotation == null || !field.isValid() || !annotation.isValid()) continue;
            String name = field.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return;
            }
            PsiParameter parameter = elementFactory.createParameter(name, field.getType());
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList != null) {
                for (PsiAnnotation qualifierAnno : SpringAutowiredFieldsWarningInspection.getQualifierAnnotations(field, qualifierAnnotationClassNames)) {
                    modifierList.add((PsiElement)elementFactory.createAnnotationFromText(qualifierAnno.getText(), (PsiElement)modifierList));
                    qualifierAnno.delete();
                }
            }
            constructor.getParameterList().add((PsiElement)parameter);
            PsiCodeBlock body = constructor.getBody();
            if (body != null) {
                body.add((PsiElement)elementFactory.createStatementFromText("this." + name + " = " + name + ";", (PsiElement)constructor));
            }
            if ((fieldModifierList = field.getModifierList()) != null && !fieldModifierList.hasModifierProperty("final") && (containingClass = constructor.getContainingClass()) != null && containingClass.getConstructors().length == 1) {
                fieldModifierList.setModifierProperty("final", true);
            }
            annotation.delete();
        }
    }

    private static PsiAnnotation[] getQualifierAnnotations(@NotNull PsiField first, Map<Module, List<String>> qualifierAnnotationClassNames) {
        Module module;
        if (first == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(10);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)first)) == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        List<String> annotations = qualifierAnnotationClassNames.get(module);
        List vs = ContainerUtil.mapNotNull(annotations, s -> AnnotationUtil.findAnnotation((PsiModifierListOwner)first, (String[])new String[]{s}));
        return vs.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    @NotNull
    private static String getConstructorName(@Nullable PsiMethod psiMethod, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        if (psiMethod != null) {
            sb.append(psiMethod.getName());
            sb.append("(");
            sb.append(SpringAutowiredFieldsWarningInspection.getConstructorParameters(psiMethod.getParameterList().getParameters()));
            sb.append(SpringAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates));
            sb.append(")");
        }
        String string = sb.toString();
        if (string == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static String getConstructorParameters(PsiParameter[] parameters) {
        StringBuilder sb = new StringBuilder();
        int maxParamsLength = 53;
        for (PsiParameter parameter : parameters) {
            String presentableText = parameter.getType().getPresentableText();
            if (sb.length() + presentableText.length() >= maxParamsLength) {
                sb.append("...,");
                break;
            }
            sb.append(presentableText);
            sb.append(",");
        }
        return sb.toString();
    }

    @NotNull
    private static String getConstructorName(@Nullable String name, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(13);
        }
        String string = name + "(" + SpringAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates) + ")";
        if (string == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static String addNewParameters(@NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringAutowiredFieldsWarningInspection.$$$reportNull$$$0(15);
        }
        StringBuilder sb = new StringBuilder();
        int maxNewParamsLength = 53;
        int current = 0;
        for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : parameterCandidates) {
            PsiField psiField = (PsiField)((SmartPsiElementPointer)pair.first).getElement();
            if (psiField != null) {
                String newParam = "<b>" + psiField.getType().getPresentableText() + "</b>";
                if (sb.length() + newParam.length() < maxNewParamsLength || current == parameterCandidates.size() - 1 || current == 0) {
                    if (current > 0) {
                        sb.append(",");
                    }
                    sb.append(newParam);
                } else {
                    sb.append(" and ");
                    sb.append(parameterCandidates.size() - current);
                    sb.append(" more parameters");
                    break;
                }
            }
            current = (byte)(current + 1);
        }
        return sb.toString();
    }

    private static Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> getParameterCandidatesForPreview(Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates, PsiFile target) {
        HashSet<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> result2 = new HashSet<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>>();
        for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> candidate : parameterCandidates) {
            PsiField field = (PsiField)((SmartPsiElementPointer)candidate.first).getElement();
            if (field == null) {
                return null;
            }
            PsiAnnotation annotation = (PsiAnnotation)((SmartPsiElementPointer)candidate.second).getElement();
            if (annotation == null) {
                return null;
            }
            PsiField targetField = (PsiField)PsiTreeUtil.findSameElementInCopy((PsiElement)field, (PsiFile)target);
            PsiAnnotation targetAnnotation = (PsiAnnotation)PsiTreeUtil.findSameElementInCopy((PsiElement)annotation, (PsiFile)target);
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)targetField.getProject());
            result2.add((Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>)Pair.create((Object)manager.createSmartPsiElementPointer((PsiElement)targetField), (Object)manager.createSmartPsiElementPointer((PsiElement)targetAnnotation)));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnAnno";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringAutowiredFieldsWarningInspection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringAutowiredFieldsWarningInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowiredAnnotation";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredFields";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAutowiredConstructor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredAnnotationIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredAnnotation";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAnnotations";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addNewParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12, 14 -> new IllegalStateException(string);
        };
    }

    private static class AddParameterQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiMethod> myConstructor;
        private final Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates;

        AddParameterQuickFix(@NotNull PsiMethod constructor, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs) {
            if (constructor == null) {
                AddParameterQuickFix.$$$reportNull$$$0(0);
            }
            if (pairs == null) {
                AddParameterQuickFix.$$$reportNull$$$0(1);
            }
            this.myConstructor = SmartPointerManager.getInstance((Project)constructor.getProject()).createSmartPsiElementPointer((PsiElement)constructor);
            this.myParameterCandidates = pairs;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SpringBundle.message("field.injection.add.parameters", SpringAutowiredFieldsWarningInspection.getConstructorName((PsiMethod)this.myConstructor.getElement(), this.myParameterCandidates));
            if (string == null) {
                AddParameterQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod constructor;
            if (project == null) {
                AddParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddParameterQuickFix.$$$reportNull$$$0(4);
            }
            if ((constructor = (PsiMethod)this.myConstructor.getElement()) == null) {
                return;
            }
            if (!this.myParameterCandidates.isEmpty()) {
                SpringAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, constructor);
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("field.injection.add.parameter.family.warning", new Object[0]);
            if (string == null) {
                AddParameterQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            PsiMethod psiMethod;
            if (target == null) {
                AddParameterQuickFix.$$$reportNull$$$0(6);
            }
            if ((psiMethod = (PsiMethod)this.myConstructor.getElement()) == null) {
                return null;
            }
            Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> candidatesForPreview = SpringAutowiredFieldsWarningInspection.getParameterCandidatesForPreview(this.myParameterCandidates, target);
            if (candidatesForPreview == null) {
                return null;
            }
            return new AddParameterQuickFix((PsiMethod)PsiTreeUtil.findSameElementInCopy((PsiElement)psiMethod, (PsiFile)target), candidatesForPreview);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringAutowiredFieldsWarningInspection$AddParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class CreateAutowiredConstructorQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiClass> myClass;
        private final Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates;
        private final String message;

        CreateAutowiredConstructorQuickFix(PsiClass containingClass, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs) {
            if (pairs == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(0);
            }
            this.myClass = SmartPointerManager.getInstance((Project)containingClass.getProject()).createSmartPsiElementPointer((PsiElement)containingClass);
            this.myParameterCandidates = pairs;
            this.message = SpringAutowiredFieldsWarningInspection.getConstructorName(containingClass.getName(), this.myParameterCandidates);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SpringBundle.message("field.injection.create.constructor.injection", this.message);
            if (string == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass containingClass;
            if (project == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(3);
            }
            if ((containingClass = (PsiClass)this.myClass.getElement()) == null) {
                return;
            }
            String name = containingClass.getName();
            if (name == null) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod constructor = elementFactory.createConstructor();
            constructor.setName(name);
            PsiMethod addedConstructor = (PsiMethod)containingClass.add((PsiElement)constructor);
            PsiUtil.setModifierProperty((PsiModifierListOwner)addedConstructor, (String)"public", (boolean)true);
            SpringAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, addedConstructor);
            SpringAutowiredFieldsWarningInspection.addAutowiredAnnotationIfNeeded(containingClass, addedConstructor, SpringAutowiredFieldsWarningInspection.getAutowiredAnnotation((SmartPsiElementPointer<PsiAnnotation>)((SmartPsiElementPointer)this.myParameterCandidates.iterator().next().second)));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("field.injection.create.constructor.family.warning", new Object[0]);
            if (string == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            PsiClass psiClass;
            if (target == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(5);
            }
            if ((psiClass = (PsiClass)this.myClass.getElement()) == null) {
                return null;
            }
            Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> candidatesForPreview = SpringAutowiredFieldsWarningInspection.getParameterCandidatesForPreview(this.myParameterCandidates, target);
            if (candidatesForPreview == null) {
                return null;
            }
            return new CreateAutowiredConstructorQuickFix((PsiClass)PsiTreeUtil.findSameElementInCopy((PsiElement)psiClass, (PsiFile)target), candidatesForPreview);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4 -> new IllegalStateException(string);
            };
        }
    }
}

