/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypes;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public final class SpringTestingTransactionalInspection
extends SpringUastInspectionBase {
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (aClass == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(1);
        }
        if ((sourcePsi = aClass.getSourcePsi()) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
        if (module == null || !SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass.getJavaPsi())) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        for (UMethod method : aClass.getMethods()) {
            UAnnotation annotation;
            UAnnotation testBeforeTransactionAnnotations = method.findAnnotation("org.springframework.test.context.transaction.BeforeTransaction");
            UAnnotation testAfterTransactionAnnotations = method.findAnnotation("org.springframework.test.context.transaction.AfterTransaction");
            UAnnotation uAnnotation = annotation = testBeforeTransactionAnnotations != null ? testBeforeTransactionAnnotations : testAfterTransactionAnnotations;
            if (annotation == null) continue;
            SpringTestingTransactionalInspection.checkLifecycleTransactionMethod(holder, method, annotation);
        }
        return holder.getResultsArray();
    }

    private static void checkLifecycleTransactionMethod(@NotNull ProblemsHolder holder, @NotNull UMethod method, @NotNull UAnnotation annotation) {
        PsiElement annotationSourcePsi;
        if (holder == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(2);
        }
        if (method == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(3);
        }
        if (annotation == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(4);
        }
        if ((annotationSourcePsi = annotation.getSourcePsi()) == null) {
            return;
        }
        if (!method.getUastParameters().isEmpty()) {
            holder.registerProblem(annotationSourcePsi, SpringBundle.message("spring.testing.transactional.wrong.number.of.arguments.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
        if (!PsiTypes.voidType().equals((Object)method.getReturnType())) {
            holder.registerProblem(annotationSourcePsi, SpringBundle.message("spring.testing.transactional.void.method.return.type.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLifecycleTransactionMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

