/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.runtime;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.runtime.SpringRuntimeResourcePointer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"BEAN_RESOURCE_PREFIX", "", "CONFIGURATION_PROPERTIES_BEAN", "CLASS_NAME_START_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "cleanClassName", "className", "extractClassName", "resourcePath", "getBeanContainingClass", "Lcom/intellij/psi/PsiClass;", "element", "Lcom/intellij/psi/PsiElement;", "getRuntimeResourcePointer", "Lcom/intellij/spring/runtime/SpringRuntimeResourcePointer;", "intellij.spring.core"})
public final class SpringRuntimeBeanResolverImplKt {
    @NotNull
    private static final String BEAN_RESOURCE_PREFIX = "/WEB-INF/classes/";
    @NotNull
    private static final String CONFIGURATION_PROPERTIES_BEAN = "CONFIGURATION_PROPERTIES";
    private static final Pattern CLASS_NAME_START_PATTERN = Pattern.compile("\\.[A-Z]");

    private static final String cleanClassName(String className) {
        String name = StringsKt.substringBefore$default((String)className, (String)"$$", null, (int)2, null);
        name = StringsKt.substringBefore$default((String)name, (char)'#', null, (int)2, null);
        name = StringsKt.substringBefore$default((String)name, (char)'@', null, (int)2, null);
        return name;
    }

    private static final String extractClassName(String resourcePath) {
        String path = StringsKt.substringAfter$default((String)resourcePath, (String)BEAN_RESOURCE_PREFIX, null, (int)2, null);
        String string = StringUtil.trimEnd((String)path, (String)".class", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        path = string;
        CharSequence charSequence = path;
        Regex regex = new Regex("[\\\\/]");
        String string2 = ".";
        path = regex.replace(charSequence, string2);
        return path;
    }

    private static final PsiClass getBeanContainingClass(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        if (element instanceof PsiClassOwner) {
            PsiClass[] psiClassArray = ((PsiClassOwner)element).getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
            return (PsiClass)ArraysKt.firstOrNull((Object[])psiClassArray);
        }
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    private static final SpringRuntimeResourcePointer getRuntimeResourcePointer(PsiElement element) {
        return new SpringRuntimeResourcePointer(element){
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
            }

            public PsiElement getPsiElement() {
                return this.$element;
            }
        };
    }

    public static final /* synthetic */ Pattern access$getCLASS_NAME_START_PATTERN$p() {
        return CLASS_NAME_START_PATTERN;
    }

    public static final /* synthetic */ PsiClass access$getBeanContainingClass(PsiElement element) {
        return SpringRuntimeBeanResolverImplKt.getBeanContainingClass(element);
    }

    public static final /* synthetic */ SpringRuntimeResourcePointer access$getRuntimeResourcePointer(PsiElement element) {
        return SpringRuntimeBeanResolverImplKt.getRuntimeResourcePointer(element);
    }

    public static final /* synthetic */ String access$extractClassName(String resourcePath) {
        return SpringRuntimeBeanResolverImplKt.extractClassName(resourcePath);
    }

    public static final /* synthetic */ String access$cleanClassName(String className) {
        return SpringRuntimeBeanResolverImplKt.cleanClassName(className);
    }
}

