/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemotePermissionRequirements;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.actions.ActionFilterProvider;
import com.jetbrains.rd.actions.ActionFilterResult;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsDataKt;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rdserver.actions.AccessActionFilterProviderKt;
import com.jetbrains.rdserver.actions.BackendDelegatingActionIdsProvider;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.permissions.PermissionInteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/actions/AccessActionFilterProvider;", "Lcom/jetbrains/rd/actions/ActionFilterProvider;", "<init>", "()V", "filterAction", "Lcom/jetbrains/rd/actions/ActionFilterResult;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "actionId", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAccessRequirements", "Lcom/jetbrains/rd/actions/AccessRequirements;", "getExplicitRequirements", "notifyForbidden", "", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nAccessActionFilterProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessActionFilterProvider.kt\ncom/jetbrains/rdserver/actions/AccessActionFilterProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,92:1\n37#2,2:93\n*S KotlinDebug\n*F\n+ 1 AccessActionFilterProvider.kt\ncom/jetbrains/rdserver/actions/AccessActionFilterProvider\n*L\n63#1:93,2\n*E\n"})
public final class AccessActionFilterProvider
implements ActionFilterProvider {
    @NotNull
    public ActionFilterResult filterAction(@NotNull ClientAppSession session, @NotNull String actionId, @NotNull AnAction action) {
        AccessRequirements requirements;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (Registry.Companion.is("ide.permissions.api.enabled")) {
            return ActionFilterResult.OK;
        }
        ClientPermissionManager permissionManager = ClientPermissionManager.Companion.getInstance(session);
        if (!AccessActionFilterProviderKt.access$areSatisfied(permissionManager, session, requirements = this.getAccessRequirements(session, actionId, action))) {
            return ActionFilterResult.FORBIDDEN;
        }
        return ActionFilterResult.OK;
    }

    @NotNull
    public AccessRequirements getAccessRequirements(@NotNull ClientAppSession session, @NotNull String actionId, @NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        AccessRequirements explicitRequirements = this.getExplicitRequirements(action);
        if (explicitRequirements != null) {
            return explicitRequirements;
        }
        boolean isBlackListed = false;
        if (session.isRemote()) {
            for (BackendDelegatingActionIdsProvider provider : BackendDelegatingActionIdsProvider.Companion.getEP_NAME().getExtensionList()) {
                AccessRequirements accessRequirements = provider.getAccessRequirements(actionId, session);
                if (accessRequirements != null) {
                    AccessRequirements requirements = accessRequirements;
                    boolean bl = false;
                    return requirements;
                }
                if (isBlackListed) continue;
                isBlackListed = provider.isBlackListed(actionId, session);
            }
        }
        if (isBlackListed || ActionManager.getInstance().getId(action) == null) {
            return (AccessRequirements)AccessRequirements.Listed.Companion.getEMPTY();
        }
        return (AccessRequirements)PermissionsDataKt.getFullAccessRequirements();
    }

    private final AccessRequirements getExplicitRequirements(AnAction action) {
        if (!(action instanceof ActionRemotePermissionRequirements)) {
            return null;
        }
        List accessLevels = new ArrayList();
        if (action instanceof ActionRemotePermissionRequirements.RunAccess) {
            accessLevels.add(RunAccessLevel.FullAccess);
        }
        if (action instanceof ActionRemotePermissionRequirements.WriteAccess) {
            accessLevels.add(FileAccessLevel.FullAccess);
        } else if (action instanceof ActionRemotePermissionRequirements.ReadAccess) {
            accessLevels.add(FileAccessLevel.Readonly);
        }
        Collection $this$toTypedArray$iv = accessLevels;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AccessLevelMarker[] accessLevelMarkerArray = thisCollection$iv.toArray(new AccessLevelMarker[0]);
        return (AccessRequirements)AccessRequirements.Companion.of(Arrays.copyOf(accessLevelMarkerArray, accessLevelMarkerArray.length));
    }

    public void notifyForbidden(@NotNull ClientAppSession session, @NotNull String actionId, @NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        PermissionInteractionManager.Companion.notifyNotPermitted((ClientSession)session, action, this.getAccessRequirements(session, actionId, action));
    }
}

