/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.ActionTimestampSetModel;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.actions.ActionTimestampKey;
import com.jetbrains.rdserver.actions.TransparentTimestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\b\u0002\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050\t\"\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ-\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\f\b\u0000\u0010\f*\u0006\u0012\u0002\b\u00030\u00052\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u0002H\f\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0003J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0015R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "", "timestamps", "", "", "Lcom/jetbrains/rdserver/actions/ActionTimestamp;", "<init>", "(Ljava/util/Map;)V", "timestamp", "", "([Lcom/jetbrains/rdserver/actions/ActionTimestamp;)V", "getTimestamp", "T", "key", "Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "(Lcom/jetbrains/rdserver/actions/ActionTimestampKey;)Lcom/jetbrains/rdserver/actions/ActionTimestamp;", "dataId", "getAllTimestamps", "merge", "other", "createModel", "Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nActionTimestampSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionTimestampSet.kt\ncom/jetbrains/rdserver/actions/ActionTimestampSet\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,65:1\n11705#2:66\n12052#2,3:67\n777#3:70\n873#3,2:71\n1586#3:73\n1661#3,3:74\n13#4:77\n*S KotlinDebug\n*F\n+ 1 ActionTimestampSet.kt\ncom/jetbrains/rdserver/actions/ActionTimestampSet\n*L\n9#1:66\n9#1:67,3\n57#1:70\n57#1:71,2\n57#1:73\n57#1:74,3\n13#1:77\n*E\n"})
public final class ActionTimestampSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, ActionTimestamp<?>> timestamps;
    @NotNull
    private static final ActionTimestampSet EMPTY = new ActionTimestampSet(new ActionTimestamp[0]);
    @NotNull
    private static final Logger LOG;

    private ActionTimestampSet(Map<String, ? extends ActionTimestamp<?>> timestamps) {
        this.timestamps = timestamps;
    }

    /*
     * WARNING - void declaration
     */
    public ActionTimestampSet(ActionTimestamp<?> ... timestamp) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(timestamp, (String)"timestamp");
        ActionTimestamp<?>[] actionTimestampArray = timestamp;
        ActionTimestampSet actionTimestampSet = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getKey().getName(), (Object)it));
        }
        actionTimestampSet(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    @Nullable
    public final <T extends ActionTimestamp<?>> T getTimestamp(@NotNull ActionTimestampKey<T, ?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.timestamps.get(key.getName());
    }

    @Nullable
    public final ActionTimestamp<?> getTimestamp(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return this.timestamps.get(dataId);
    }

    @NotNull
    public final Map<String, ActionTimestamp<?>> getAllTimestamps() {
        return this.timestamps;
    }

    @NotNull
    public final ActionTimestampSet merge(@NotNull ActionTimestampSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)EMPTY)) {
            return other;
        }
        if (Intrinsics.areEqual((Object)other, (Object)EMPTY)) {
            return this;
        }
        HashMap result = new HashMap(other.timestamps);
        for (Map.Entry<String, ActionTimestamp<?>> entry : this.timestamps.entrySet()) {
            String name = entry.getKey();
            ActionTimestamp<?> timestamp = entry.getValue();
            ActionTimestamp<?> otherTimestamp = other.timestamps.get(name);
            if (otherTimestamp != null && !Intrinsics.areEqual(timestamp.getModel(), otherTimestamp.getModel())) {
                LOG.error("Timestamp data mismatched. Name:\"" + timestamp.getKey() + "\", Data: \"" + timestamp.getModel() + "\" vs \"" + otherTimestamp.getModel());
            }
            ((Map)result).put(name, timestamp);
        }
        return new ActionTimestampSet(result);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ActionTimestampSetModel createModel() {
        void $this$mapTo$iv$iv;
        ActionTimestamp it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.timestamps.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ActionTimestamp)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof TransparentTimestamp))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ActionTimestamp)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getModel());
        }
        List models2 = (List)destination$iv$iv;
        return new ActionTimestampSetModel(models2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ActionTimestampSet.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/actions/ActionTimestampSet$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "getEMPTY", "()Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionTimestampSet getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

