/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.connection.certificate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.protocol.channel.certificate.RemoteTrustManager;
import com.jetbrains.rdserver.startup.SecureClientData;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012#\u0010\u0004\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012J%\u0010\u0013\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0004\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdserver/connection/certificate/ServerTrustManager;", "Lcom/intellij/platform/split/connection/protocol/channel/certificate/RemoteTrustManager;", "acceptAnySession", "", "checkSessionAccepted", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "sessionId", "<init>", "(ZLkotlin/jvm/functions/Function1;)V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "checkHandshakeTrusted", "certificates", "", "checkClientCertificates", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nServerTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerTrustManager.kt\ncom/jetbrains/rdserver/connection/certificate/ServerTrustManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,51:1\n60#2,5:52\n23#2:57\n*S KotlinDebug\n*F\n+ 1 ServerTrustManager.kt\ncom/jetbrains/rdserver/connection/certificate/ServerTrustManager\n*L\n30#1:52,5\n16#1:57\n*E\n"})
public final class ServerTrustManager
extends RemoteTrustManager {
    @NotNull
    public static final Companion Companion;
    private final boolean acceptAnySession;
    @NotNull
    private final Function1<String, Boolean> checkSessionAccepted;
    @NotNull
    private static final Logger logger;

    public ServerTrustManager(boolean acceptAnySession, @NotNull Function1<? super String, Boolean> checkSessionAccepted) {
        Intrinsics.checkNotNullParameter(checkSessionAccepted, (String)"checkSessionAccepted");
        this.acceptAnySession = acceptAnySession;
        this.checkSessionAccepted = checkSessionAccepted;
    }

    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        this.checkTrusted(ArraysKt.toList((Object[])chain));
    }

    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new UnsupportedOperationException("Server trust check on a server side is not possible. Please make sure the manager instance is used on a server side.");
    }

    public void checkHandshakeTrusted(@NotNull List<? extends X509Certificate> certificates) {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Check handshake trusted", t$iv);
        }
        SecureClientData secureClientData = new SecureClientData(certificates);
        this.checkClientCertificates(secureClientData.getConnectionSessionId(), this.acceptAnySession);
    }

    private final void checkClientCertificates(String sessionId, boolean acceptAnySession) {
        if (acceptAnySession) {
            logger.info("Accepting session (id: " + sessionId + ") because this wire accepts any session");
            return;
        }
        if (!((Boolean)this.checkSessionAccepted.invoke((Object)sessionId)).booleanValue()) {
            throw new IllegalStateException(("Session (id: " + sessionId + ") was declined").toString());
        }
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ServerTrustManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/connection/certificate/ServerTrustManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

