/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterExtension;
import com.jetbrains.rd.ide.model.HighlighterIdList;
import com.jetbrains.rd.ide.model.HighlighterList;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rdserver.daemon.BackendHighlighterExtensionsProvider;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributorKt;
import com.jetbrains.rdserver.daemon.BackendMarkupSuppressor;
import com.jetbrains.rdserver.daemon.BackendRangeMarkerModelCreator;
import com.jetbrains.rdserver.daemon.BackendRangeMarkerStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0000\u00a2\u0006\u0002\b'J\u0014\u0010(\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\b\u0010)\u001a\u00020#H\u0002J\u0006\u0010*\u001a\u00020#J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202J%\u00103\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H407\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u0004\u0018\u0001022\u0006\u0010:\u001a\u00020;J\u0015\u0010<\u001a\u0004\u0018\u00010;2\u0006\u00101\u001a\u000202\u00a2\u0006\u0002\u0010=R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006>"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "document", "Lcom/intellij/openapi/editor/Document;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "suppressor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupSuppressor;", "protocolMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "storage", "Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerStorage;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;Lcom/jetbrains/rdserver/daemon/BackendMarkupSuppressor;Lcom/jetbrains/rd/ide/model/RdMarkupModel;Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerStorage;)V", "getAppSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getProjectSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getSuppressor", "()Lcom/jetbrains/rdserver/daemon/BackendMarkupSuppressor;", "getProtocolMarkupModel", "()Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "getStorage", "()Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerStorage;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addOrUpdateRangeMarkers", "", "rangeMarkers", "", "Lcom/intellij/openapi/editor/RangeMarker;", "addOrUpdateRangeMarkers$intellij_platform_backend_split", "removeRangeMarkers", "flushRangeMarkers", "recoverMarkupState", "documentVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "getDocumentVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "createElement", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "rangeMarker", "Lcom/intellij/openapi/editor/ex/RangeMarkerEx;", "getExtension", "T", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "getRangeMarker", "id", "", "getRangeMarkerId", "(Lcom/intellij/openapi/editor/ex/RangeMarkerEx;)Ljava/lang/Long;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendMarkupModelContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendMarkupModelContributor.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupModelContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,198:1\n1915#2,2:199\n1915#2,2:201\n1642#2,10:203\n1915#2:213\n1916#2:215\n1652#2:216\n1#3:214\n1#3:223\n10574#4:217\n11007#4,5:218\n*S KotlinDebug\n*F\n+ 1 BackendMarkupModelContributor.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupModelContributor\n*L\n43#1:199,2\n95#1:201,2\n101#1:203,10\n101#1:213\n101#1:215\n101#1:216\n101#1:214\n128#1:217\n128#1:218,5\n*E\n"})
public class BackendMarkupModelContributor {
    @NotNull
    private final ClientAppSession appSession;
    @Nullable
    private final ClientProjectSession projectSession;
    @NotNull
    private final Document document;
    @NotNull
    private final DocumentSynchronizer documentSynchronizer;
    @NotNull
    private final BackendMarkupSuppressor suppressor;
    @NotNull
    private final RdMarkupModel protocolMarkupModel;
    @NotNull
    private final BackendRangeMarkerStorage storage;

    public BackendMarkupModelContributor(@NotNull ClientAppSession appSession, @Nullable ClientProjectSession projectSession, @NotNull Document document, @NotNull DocumentSynchronizer documentSynchronizer, @NotNull BackendMarkupSuppressor suppressor, @NotNull RdMarkupModel protocolMarkupModel, @NotNull BackendRangeMarkerStorage storage) {
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        Intrinsics.checkNotNullParameter((Object)protocolMarkupModel, (String)"protocolMarkupModel");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.appSession = appSession;
        this.projectSession = projectSession;
        this.document = document;
        this.documentSynchronizer = documentSynchronizer;
        this.suppressor = suppressor;
        this.protocolMarkupModel = protocolMarkupModel;
        this.storage = storage;
        this.suppressor.onRelease((Function0<Unit>)((Function0)() -> BackendMarkupModelContributor._init_$lambda$0(this)));
    }

    @NotNull
    public final ClientAppSession getAppSession() {
        return this.appSession;
    }

    @Nullable
    public final ClientProjectSession getProjectSession() {
        return this.projectSession;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final BackendMarkupSuppressor getSuppressor() {
        return this.suppressor;
    }

    @NotNull
    public final RdMarkupModel getProtocolMarkupModel() {
        return this.protocolMarkupModel;
    }

    @NotNull
    public final BackendRangeMarkerStorage getStorage() {
        return this.storage;
    }

    @Nullable
    public final Project getProject() {
        ClientProjectSession clientProjectSession = this.projectSession;
        return clientProjectSession != null ? clientProjectSession.getProject() : null;
    }

    public final void addOrUpdateRangeMarkers$intellij_platform_backend_split(@NotNull Iterable<? extends RangeMarker> rangeMarkers) {
        Intrinsics.checkNotNullParameter(rangeMarkers, (String)"rangeMarkers");
        if (this.suppressor.shouldSuppress()) {
            Iterable<? extends RangeMarker> $this$forEach$iv = rangeMarkers;
            boolean $i$f$forEach = false;
            Iterator<? extends RangeMarker> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                RangeMarker element$iv;
                RangeMarker rangeMarker = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)rangeMarker, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
                if (!this.storage.contains((RangeMarkerEx)rangeMarker)) {
                    this.storage.queueAdd((RangeMarkerEx)rangeMarker);
                    continue;
                }
                this.storage.queueUpdate((RangeMarkerEx)rangeMarker);
            }
            return;
        }
        List toAdd = new ArrayList();
        List toUpdate = new ArrayList();
        List toRemove = new ArrayList();
        for (RangeMarker rangeMarker : rangeMarkers) {
            if (!rangeMarker.isValid()) continue;
            Intrinsics.checkNotNull((Object)rangeMarker, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
            boolean contains = this.storage.contains((RangeMarkerEx)rangeMarker);
            if (!contains) {
                this.storage.add((RangeMarkerEx)rangeMarker);
                HighlighterElement model2 = this.createElement((RangeMarkerEx)rangeMarker);
                if (model2 == null) {
                    this.storage.remove((RangeMarkerEx)rangeMarker);
                    continue;
                }
                toAdd.add(model2);
                continue;
            }
            HighlighterElement model2 = this.createElement((RangeMarkerEx)rangeMarker);
            if (model2 != null) {
                toUpdate.add(model2);
                continue;
            }
            UtilKt.addIfNotNull((List)toRemove, (Object)this.storage.remove((RangeMarkerEx)rangeMarker));
        }
        if (!((Collection)toAdd).isEmpty()) {
            this.protocolMarkupModel.getHighlightersAdded().fire((Object)new HighlighterList(toAdd));
        }
        if (!((Collection)toUpdate).isEmpty()) {
            this.protocolMarkupModel.getHighlightersUpdated().fire((Object)new HighlighterList(toUpdate));
        }
        if (!((Collection)toRemove).isEmpty()) {
            this.protocolMarkupModel.getHighlightersRemoved().fire((Object)new HighlighterIdList(toRemove));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeRangeMarkers(@NotNull Iterable<? extends RangeMarker> rangeMarkers) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(rangeMarkers, (String)"rangeMarkers");
        if (this.suppressor.shouldSuppress()) {
            Iterable<? extends RangeMarker> $this$forEach$iv = rangeMarkers;
            boolean $i$f$forEach = false;
            Iterator<? extends RangeMarker> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                RangeMarker element$iv;
                RangeMarker it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
                this.storage.queueRemove((RangeMarkerEx)it);
            }
            return;
        }
        Iterable<? extends RangeMarker> $this$mapNotNull$iv = rangeMarkers;
        boolean $i$f$mapNotNull = false;
        Iterable<? extends RangeMarker> element$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RangeMarker it = (RangeMarker)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
            if (this.storage.remove((RangeMarkerEx)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        if (!((Collection)toRemove).isEmpty()) {
            this.protocolMarkupModel.getHighlightersRemoved().fire((Object)new HighlighterIdList(toRemove));
        }
    }

    private final void flushRangeMarkers() {
        this.removeRangeMarkers((Iterable<? extends RangeMarker>)this.storage.flushPendingToRemove());
        this.addOrUpdateRangeMarkers$intellij_platform_backend_split((Iterable<? extends RangeMarker>)this.storage.flushPendingToAdd());
        this.addOrUpdateRangeMarkers$intellij_platform_backend_split((Iterable<? extends RangeMarker>)this.storage.flushPendingToUpdate());
    }

    public final void recoverMarkupState() {
        List<RangeMarkerEx> allRangeMarkers = this.storage.getAllRegistered();
        BackendMarkupModelContributorKt.performBulkOperation$default(this, allRangeMarkers, 0, arg_0 -> BackendMarkupModelContributor.recoverMarkupState$lambda$0(this, arg_0), 2, null);
        BackendMarkupModelContributorKt.performBulkOperation$default(this, allRangeMarkers, 0, arg_0 -> BackendMarkupModelContributor.recoverMarkupState$lambda$1(this, arg_0), 2, null);
    }

    @NotNull
    public final RdDocumentVersion getDocumentVersion() {
        AbstractDocumentVersion abstractDocumentVersion = this.documentSynchronizer.getVersion();
        Intrinsics.checkNotNull((Object)abstractDocumentVersion, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentVersion");
        return (RdDocumentVersion)abstractDocumentVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final HighlighterElement createElement(@NotNull RangeMarkerEx rangeMarker) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        BackendRangeMarkerModelCreator creator = (BackendRangeMarkerModelCreator)BackendRangeMarkerModelCreator.Companion.getEP_NAME().findFirstSafe(arg_0 -> BackendMarkupModelContributor.createElement$lambda$1(arg_0 -> BackendMarkupModelContributor.createElement$lambda$0(rangeMarker, this, arg_0), arg_0));
        BackendRangeMarkerModelCreator backendRangeMarkerModelCreator = creator;
        if (backendRangeMarkerModelCreator == null || (backendRangeMarkerModelCreator = backendRangeMarkerModelCreator.createModel(rangeMarker, this)) == null) {
            return null;
        }
        BackendRangeMarkerModelCreator model2 = backendRangeMarkerModelCreator;
        Object[] $this$flatMap$iv = BackendHighlighterExtensionsProvider.Companion.getEP_NAME().getExtensions();
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable;
            block4: {
                List<HighlighterExtension> list;
                BackendHighlighterExtensionsProvider it = (BackendHighlighterExtensionsProvider)element$iv$iv;
                boolean bl = false;
                try {
                    list = it.getExtensions(this.appSession, rangeMarker, this, (HighlighterModel)model2);
                }
                catch (Throwable t) {
                    BackendMarkupModelContributorKt.access$getLogger$p().error(t);
                    iterable = CollectionsKt.emptyList();
                    break block4;
                }
                iterable = list;
            }
            Iterable list$iv$iv = iterable;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List extensions = (List)destination$iv$iv;
        return new HighlighterElement((HighlighterModel)model2, extensions);
    }

    @Nullable
    public final <T extends MarkupModelExtension> T getExtension(@NotNull Key<T> key) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Iterable iterable = this.protocolMarkupModel.getExtensions();
            for (Object t : iterable) {
                MarkupModelExtension it = (MarkupModelExtension)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)key.toString())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_7 = v0;
        return (T)(var2_7 instanceof MarkupModelExtension ? (MarkupModelExtension)var2_7 : null);
    }

    @Nullable
    public final RangeMarkerEx getRangeMarker(long id) {
        return this.storage.get(id);
    }

    @Nullable
    public final Long getRangeMarkerId(@NotNull RangeMarkerEx rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        return this.storage.get(rangeMarker);
    }

    private static final void lambda$0$0(BackendMarkupModelContributor this$0) {
        this$0.flushRangeMarkers();
    }

    private static final Unit _init_$lambda$0(BackendMarkupModelContributor this$0) {
        WriteIntentReadAction.run(() -> BackendMarkupModelContributor.lambda$0$0(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit recoverMarkupState$lambda$0(BackendMarkupModelContributor this$0, RangeMarkerEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.removeRangeMarkers(CollectionsKt.listOf((Object)it));
        return Unit.INSTANCE;
    }

    private static final Unit recoverMarkupState$lambda$1(BackendMarkupModelContributor this$0, RangeMarkerEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addOrUpdateRangeMarkers$intellij_platform_backend_split(CollectionsKt.listOf((Object)it));
        return Unit.INSTANCE;
    }

    private static final boolean createElement$lambda$0(RangeMarkerEx $rangeMarker, BackendMarkupModelContributor this$0, BackendRangeMarkerModelCreator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.accept($rangeMarker, this$0);
    }

    private static final boolean createElement$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

