/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupHost;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a@\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u0012H\u0000\u001a>\u0010\u0013\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f2\b\b\u0002\u0010\u0014\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getRangeMarker", "Lcom/intellij/openapi/editor/ex/RangeMarkerEx;", "editor", "Lcom/intellij/openapi/editor/Editor;", "id", "", "CHUNK_SIZE", "", "performInBulkIfPossible", "", "T", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "elements", "", "chuckSize", "action", "Lkotlin/Function1;", "performBulkOperation", "chunkSize", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendMarkupModelContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendMarkupModelContributor.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupModelContributorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,198:1\n1#2:199\n1915#3,2:200\n1915#3,2:205\n39#4,3:202\n43#4:207\n13#5:208\n*S KotlinDebug\n*F\n+ 1 BackendMarkupModelContributor.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupModelContributorKt\n*L\n172#1:200,2\n187#1:205,2\n182#1:202,3\n182#1:207\n23#1:208\n*E\n"})
public final class BackendMarkupModelContributorKt {
    @NotNull
    private static final Logger logger;
    public static final int CHUNK_SIZE = 200;

    @Nullable
    public static final RangeMarkerEx getRangeMarker(@NotNull Editor editor, long id) {
        Object object;
        block5: {
            block4: {
                ClientAppSession clientAppSession;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                object = ClientSessionsUtil.getCurrentSessionOrNull((Application)ApplicationKt.getApplication());
                if (object == null) break block4;
                ClientAppSession it = clientAppSession = object;
                boolean bl = false;
                object = BackendEditorHost.Companion.synchronizerForSession(editor, it) != null ? clientAppSession : null;
                if (object != null) break block5;
            }
            return null;
        }
        ClientAppSession session = object;
        BackendMarkupHost markupHost = BackendMarkupHost.Companion.getInstance(session);
        BackendEditorMarkupModelContributor backendEditorMarkupModelContributor = markupHost.getContributor(editor);
        if (backendEditorMarkupModelContributor == null || (backendEditorMarkupModelContributor = backendEditorMarkupModelContributor.getRangeMarker(id)) == null) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            BackendMarkupModelContributor backendMarkupModelContributor = markupHost.getContributor(document, editor.getProject());
            backendEditorMarkupModelContributor = backendMarkupModelContributor != null ? backendMarkupModelContributor.getRangeMarker(id) : null;
        }
        return backendEditorMarkupModelContributor;
    }

    public static final <T> void performInBulkIfPossible(@Nullable BackendMarkupModelContributor $this$performInBulkIfPossible, @NotNull Iterable<? extends T> elements, int chuckSize, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if ($this$performInBulkIfPossible != null) {
            BackendMarkupModelContributorKt.performBulkOperation($this$performInBulkIfPossible, elements, chuckSize, action);
        } else {
            Iterable<T> $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                action.invoke(element$iv);
            }
        }
    }

    public static /* synthetic */ void performInBulkIfPossible$default(BackendMarkupModelContributor backendMarkupModelContributor, Iterable iterable, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 200;
        }
        BackendMarkupModelContributorKt.performInBulkIfPossible(backendMarkupModelContributor, iterable, n, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> void performBulkOperation(@NotNull BackendMarkupModelContributor $this$performBulkOperation, @NotNull Iterable<? extends T> elements, int chunkSize, @NotNull Function1<? super T, Unit> action) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$performBulkOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean bl2 = bl = chunkSize > 0 || chunkSize == -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lt = def$iv.getLifetime();
            boolean bl3 = false;
            SequentialLifetimes lifetimes = new SequentialLifetimes(lt);
            if (chunkSize == -1) {
                $this$performBulkOperation.getSuppressor().suppress((Lifetime)lifetimes.next(), "performBulkAddOperation");
                Iterable<T> $this$forEach$iv = elements;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    action.invoke(element$iv);
                }
            } else {
                Iterator<T> iterator = elements.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int counter = n++;
                    T element = iterator.next();
                    if (counter % chunkSize == 0) {
                        $this$performBulkOperation.getSuppressor().suppress((Lifetime)lifetimes.next(), "performBulkAddOperation");
                    }
                    action.invoke(element);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    public static /* synthetic */ void performBulkOperation$default(BackendMarkupModelContributor backendMarkupModelContributor, Iterable iterable, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 200;
        }
        BackendMarkupModelContributorKt.performBulkOperation(backendMarkupModelContributor, iterable, n, function1);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendMarkupModelContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendMarkupModelContributorKt.logger = logger;
    }
}

