/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.folding;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.ide.model.CodeFoldingEventsModel;
import com.jetbrains.rd.ide.model.FoldRegionStateChangeEvent;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendProtocolMarkupModelExtensionHandler;
import com.jetbrains.rdserver.daemon.folding.BackendFoldingModelBinder;
import com.jetbrains.rdserver.daemon.folding.BackendFoldingModelBinderKt;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdserver/daemon/folding/BackendFoldingModelBinder;", "Lcom/jetbrains/rdserver/daemon/BackendProtocolMarkupModelExtensionHandler;", "<init>", "()V", "consume", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "extensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "applyFoldRegionStateChange", "Lcom/jetbrains/rdserver/daemon/BackendEditorMarkupModelContributor;", "change", "Lcom/jetbrains/rd/ide/model/FoldRegionStateChangeEvent;", "bind", "codeFoldingEventsModel", "Lcom/jetbrains/rd/ide/model/CodeFoldingEventsModel;", "foldingModelEx", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendFoldingModelBinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendFoldingModelBinder.kt\ncom/jetbrains/rdserver/daemon/folding/BackendFoldingModelBinder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n67#2,4:119\n13#2:123\n*S KotlinDebug\n*F\n+ 1 BackendFoldingModelBinder.kt\ncom/jetbrains/rdserver/daemon/folding/BackendFoldingModelBinder\n*L\n55#1:119,4\n26#1:123\n*E\n"})
public final class BackendFoldingModelBinder
implements BackendProtocolMarkupModelExtensionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void consume(@NotNull Lifetime lifetime, @NotNull List<? extends MarkupModelExtension> extensions, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (!(contributor instanceof BackendEditorMarkupModelContributor)) {
            return;
        }
        CodeFoldingEventsModel codeFoldingEventsModel = (CodeFoldingEventsModel)contributor.getExtension(BackendFoldingModelBinderKt.access$getCODE_FOLDING_EVENTS_MODEL_EXTENSION_KEY$p());
        if (codeFoldingEventsModel == null) {
            return;
        }
        CodeFoldingEventsModel eventsModel = codeFoldingEventsModel;
        Editor editor = ((BackendEditorMarkupModelContributor)contributor).getEditor();
        BackendEditorMarkupModelContributor backendEditorMarkupModelContributor = (BackendEditorMarkupModelContributor)contributor;
        FoldingModel foldingModel = editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.FoldingModelEx");
        this.bind(backendEditorMarkupModelContributor, lifetime, eventsModel, (FoldingModelEx)foldingModel);
        eventsModel.getFoldRegionsStatesChanged().advise(lifetime, arg_0 -> BackendFoldingModelBinder.consume$lambda$0(editor, this, contributor, arg_0));
    }

    private final void applyFoldRegionStateChange(BackendEditorMarkupModelContributor contributor, FoldRegionStateChangeEvent change) {
        RangeMarkerEx rangeMarkerEx = contributor.getRangeMarker(change.getBackendId());
        FoldRegion foldRegion = rangeMarkerEx instanceof FoldRegion ? (FoldRegion)rangeMarkerEx : null;
        if (foldRegion == null) {
            BackendFoldingModelBinder $this$applyFoldRegionStateChange_u24lambda_u240 = this;
            boolean bl = false;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("RangeMarkerEx with id " + change.getBackendId() + " was not found");
            }
            return;
        }
        FoldRegion foldRegion2 = foldRegion;
        if (!foldRegion2.isValid() || foldRegion2.isExpanded() == change.isExpanded()) {
            return;
        }
        foldRegion2.setExpanded(change.isExpanded());
    }

    public final void bind(@NotNull BackendEditorMarkupModelContributor $this$bind, @NotNull Lifetime lifetime, @NotNull CodeFoldingEventsModel codeFoldingEventsModel, @NotNull FoldingModelEx foldingModelEx) {
        Intrinsics.checkNotNullParameter((Object)$this$bind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)codeFoldingEventsModel, (String)"codeFoldingEventsModel");
        Intrinsics.checkNotNullParameter((Object)foldingModelEx, (String)"foldingModelEx");
        FoldingListener listener2 = new FoldingListener($this$bind, codeFoldingEventsModel){
            private final Set<RangeMarker> toAddOrUpdate;
            private final Set<RangeMarker> toRemove;
            final /* synthetic */ BackendEditorMarkupModelContributor $this_bind;
            final /* synthetic */ CodeFoldingEventsModel $codeFoldingEventsModel;
            {
                this.$this_bind = $receiver;
                this.$codeFoldingEventsModel = $codeFoldingEventsModel;
                this.toAddOrUpdate = new LinkedHashSet<E>();
                this.toRemove = new LinkedHashSet<E>();
            }

            public void onFoldRegionStateChange(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                LocalChangeKt.ignoreOnReentrancy((UpdateFlag)BackendFoldingModelBinderKt.access$getFoldingStateChangeFromFrontend$p(), () -> bind.listener.1.onFoldRegionStateChange$lambda$0(this, region));
            }

            public void beforeFoldRegionRemoved(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                LocalChangeKt.ignoreOnReentrancy((UpdateFlag)BackendFoldingModelBinderKt.access$getFoldingStateChangeFromFrontend$p(), () -> bind.listener.1.beforeFoldRegionRemoved$lambda$1(this, region));
            }

            public void onCustomFoldRegionPropertiesChange(CustomFoldRegion region, int flags) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                LocalChangeKt.ignoreOnReentrancy((UpdateFlag)BackendFoldingModelBinderKt.access$getFoldingStateChangeFromFrontend$p(), () -> bind.listener.1.onCustomFoldRegionPropertiesChange$lambda$2(flags, this, region));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFoldProcessingEnd() {
                try {
                    this.$this_bind.removeRangeMarkers((Iterable<? extends RangeMarker>)this.toRemove);
                    this.$this_bind.addOrUpdateRangeMarkers$intellij_platform_backend_split((Iterable<? extends RangeMarker>)this.toAddOrUpdate);
                }
                finally {
                    this.toRemove.clear();
                    this.toAddOrUpdate.clear();
                }
            }

            public void onFoldInitializationStatusChanged(boolean initInProgress) {
                this.$codeFoldingEventsModel.getFoldInitializationInProgress().set((Object)initInProgress);
            }

            private static final Unit onFoldRegionStateChange$lambda$0(bind.listener.1 this$0, FoldRegion $region) {
                this$0.toAddOrUpdate.add((RangeMarker)$region);
                return Unit.INSTANCE;
            }

            private static final Unit beforeFoldRegionRemoved$lambda$1(bind.listener.1 this$0, FoldRegion $region) {
                this$0.toAddOrUpdate.remove($region);
                this$0.toRemove.add((RangeMarker)$region);
                return Unit.INSTANCE;
            }

            private static final Unit onCustomFoldRegionPropertiesChange$lambda$2(int $flags, bind.listener.1 this$0, CustomFoldRegion $region) {
                boolean gutterMarkChanged;
                boolean bl = gutterMarkChanged = ($flags & 4) != 0;
                if (gutterMarkChanged) {
                    this$0.toAddOrUpdate.add((RangeMarker)$region);
                }
                return Unit.INSTANCE;
            }
        };
        FoldRegion[] foldRegionArray = foldingModelEx.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        $this$bind.addOrUpdateRangeMarkers$intellij_platform_backend_split(ArraysKt.asIterable((Object[])foldRegionArray));
        foldingModelEx.addListener(listener2, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    private static final void consume$lambda$0$0$0(List $it, BackendFoldingModelBinder this$0, BackendMarkupModelContributor $contributor) {
        for (FoldRegionStateChangeEvent change : $it) {
            this$0.applyFoldRegionStateChange((BackendEditorMarkupModelContributor)$contributor, change);
        }
    }

    private static final Unit consume$lambda$0$0(Editor $editor, List $it, BackendFoldingModelBinder this$0, BackendMarkupModelContributor $contributor) {
        $editor.getFoldingModel().runBatchFoldingOperation(() -> BackendFoldingModelBinder.consume$lambda$0$0$0($it, this$0, $contributor), true, false);
        return Unit.INSTANCE;
    }

    private static final Unit consume$lambda$0(Editor $editor, BackendFoldingModelBinder this$0, BackendMarkupModelContributor $contributor, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LocalChangeKt.ignoreOnReentrancy((UpdateFlag)BackendFoldingModelBinderKt.access$getFoldingStateChangeFromFrontend$p(), () -> BackendFoldingModelBinder.consume$lambda$0$0($editor, it, this$0, $contributor));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendFoldingModelBinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/daemon/folding/BackendFoldingModelBinder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

