/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.renderedDocs;

import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.ide.model.highlighterRegistration.HighlighterProperties;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.DocRenderFoldingModel;
import com.jetbrains.rd.ide.model.DocRenderHighlighterModel;
import com.jetbrains.rd.ide.model.GutterMarkRendererModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdserver.daemon.BackendHighlighterRegistrationsHost;
import com.jetbrains.rdserver.daemon.BackendHighlighterRegistrationsHostKt;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendRangeMarkerModelCreator;
import com.jetbrains.rdserver.daemon.BackendRangeMarkerStorage;
import com.jetbrains.rdserver.daemon.highlighters.gutterMarks.GutterMarkProtocolHighlighterModelCreatorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/daemon/renderedDocs/BackendDocRenderModelCreator;", "Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerModelCreator;", "<init>", "()V", "accept", "", "rangeMarker", "Lcom/intellij/openapi/editor/ex/RangeMarkerEx;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "createModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendDocRenderModelCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDocRenderModelCreator.kt\ncom/jetbrains/rdserver/daemon/renderedDocs/BackendDocRenderModelCreator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n*S KotlinDebug\n*F\n+ 1 BackendDocRenderModelCreator.kt\ncom/jetbrains/rdserver/daemon/renderedDocs/BackendDocRenderModelCreator\n*L\n77#1:80\n*E\n"})
public final class BackendDocRenderModelCreator
implements BackendRangeMarkerModelCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HighlighterProperties PROPERTIES = BackendHighlighterRegistrationsHost.Companion.createDefaultProperties$default(BackendHighlighterRegistrationsHost.Companion, "IJ.RENDER_DOC", false, false, 6, null);
    @NotNull
    private static final Logger LOG;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean accept(@NotNull RangeMarkerEx rangeMarker, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (rangeMarker instanceof CustomFoldRegion) {
            if (((CustomFoldRegion)rangeMarker).getRenderer() instanceof DocRenderer) return true;
        }
        if (!(rangeMarker instanceof RangeHighlighterEx)) return false;
        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)rangeMarker;
        if (rangeHighlighterEx == null) {
            return false;
        }
        if (!DocRenderItemManager.Companion.getInstance().isRenderedDocHighlighter((RangeHighlighter)rangeHighlighterEx)) return false;
        return true;
    }

    @Override
    @NotNull
    public HighlighterModel createModel(@NotNull RangeMarkerEx rangeMarker, @NotNull BackendMarkupModelContributor contributor) {
        HighlighterModel highlighterModel;
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (rangeMarker instanceof RangeHighlighterEx) {
            GutterIconRenderer gutterIconRenderer = ((RangeHighlighterEx)rangeMarker).getGutterIconRenderer();
            GutterMarkRendererModel gutterIconRenderer2 = gutterIconRenderer != null ? GutterMarkProtocolHighlighterModelCreatorKt.toModel(gutterIconRenderer, contributor.getAppSession()) : null;
            RangeHighlighterEx $this$createModel_u24lambda_u240 = (RangeHighlighterEx)rangeMarker;
            boolean bl = false;
            TextAttributesKey textAttributesKey = $this$createModel_u24lambda_u240.getTextAttributesKey();
            highlighterModel = (HighlighterModel)new DocRenderHighlighterModel(gutterIconRenderer2, $this$createModel_u24lambda_u240.getLayer(), $this$createModel_u24lambda_u240.getTargetArea() == HighlighterTargetArea.EXACT_RANGE, (AbstractDocumentVersion)contributor.getDocumentVersion(), $this$createModel_u24lambda_u240.isGreedyToLeft(), $this$createModel_u24lambda_u240.isGreedyToRight(), $this$createModel_u24lambda_u240.isThinErrorStripeMark(), null, textAttributesKey != null ? BackendHighlighterRegistrationsHostKt.toModel$default(textAttributesKey, false, 1, null) : null, $this$createModel_u24lambda_u240.getId(), PROPERTIES, $this$createModel_u24lambda_u240.getStartOffset(), $this$createModel_u24lambda_u240.getEndOffset());
        } else {
            CustomFoldRegion folding = (CustomFoldRegion)rangeMarker;
            CustomFoldRegionRenderer customFoldRegionRenderer = folding.getRenderer();
            Intrinsics.checkNotNull((Object)customFoldRegionRenderer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.documentation.render.DocRenderer");
            DocRenderer renderer = (DocRenderer)customFoldRegionRenderer;
            BackendRangeMarkerStorage backendRangeMarkerStorage = contributor.getStorage();
            RangeHighlighter rangeHighlighter = renderer.getItem().getHighlighter();
            Intrinsics.checkNotNull((Object)rangeHighlighter, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
            if (!backendRangeMarkerStorage.contains((RangeMarkerEx)rangeHighlighter)) {
                LOG.error("highlighter should already be registered for " + folding + " in " + renderer.getItem().getEditor());
            }
            String string = renderer.getItem().getTextToRender();
            RangeHighlighter rangeHighlighter2 = renderer.getItem().getHighlighter();
            Intrinsics.checkNotNull((Object)rangeHighlighter2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeHighlighterEx");
            GutterIconRenderer gutterIconRenderer = folding.getGutterIconRenderer();
            highlighterModel = (HighlighterModel)new DocRenderFoldingModel(string, ((RangeHighlighterEx)rangeHighlighter2).getId(), gutterIconRenderer != null ? GutterMarkProtocolHighlighterModelCreatorKt.toModel(gutterIconRenderer, contributor.getAppSession()) : null, 0, true, (AbstractDocumentVersion)contributor.getDocumentVersion(), folding.isGreedyToLeft(), folding.isGreedyToRight(), false, null, null, rangeMarker.getId(), PROPERTIES, folding.getStartOffset(), folding.getEndOffset());
        }
        return highlighterModel;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendDocRenderModelCreator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/daemon/renderedDocs/BackendDocRenderModelCreator$Companion;", "", "<init>", "()V", "PROPERTIES", "Lcom/jetbrains/ide/model/highlighterRegistration/HighlighterProperties;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

