/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.codeWithMe.model.BreakpointConditionInfo;
import com.jetbrains.codeWithMe.model.SourcePositionModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.SourcePositionBase;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.platform.codeWithMe.debugger.DebuggerDocumentExtensionsKt;
import com.jetbrains.rdserver.debugger.BackendBreakpointHost;
import com.jetbrains.rdserver.debugger.BackendDebuggerDocumentProvider;
import com.jetbrains.rdserver.document.BackendDocumentProvider;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHostKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/debugger/BackendBreakpointConditionDocumentProvider;", "Lcom/jetbrains/rdserver/document/BackendDocumentProvider;", "<init>", "()V", "accept", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendBreakpointConditionDocumentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendBreakpointConditionDocumentProvider.kt\ncom/jetbrains/rdserver/debugger/BackendBreakpointConditionDocumentProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n13#2:57\n*S KotlinDebug\n*F\n+ 1 BackendBreakpointConditionDocumentProvider.kt\ncom/jetbrains/rdserver/debugger/BackendBreakpointConditionDocumentProvider\n*L\n54#1:57\n*E\n"})
public final class BackendBreakpointConditionDocumentProvider
implements BackendDocumentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    public boolean accept(@NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        return DebuggerDocumentExtensionsKt.getBreakpointConditionInfo((RdDocumentModel)documentModel) != null;
    }

    @Override
    @Nullable
    public Document document(@NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel) {
        XSourcePositionImpl xSourcePositionImpl;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        BreakpointConditionInfo breakpointConditionInfo = DebuggerDocumentExtensionsKt.getBreakpointConditionInfo((RdDocumentModel)documentModel);
        Intrinsics.checkNotNull((Object)breakpointConditionInfo);
        BreakpointConditionInfo conditionInfo = breakpointConditionInfo;
        ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)session, (RdProjectId)conditionInfo.getProjectId());
        Intrinsics.checkNotNull((Object)clientProjectSession);
        ClientProjectSession projectSession = clientProjectSession;
        SourcePositionBase sourcePositionBase = conditionInfo.getSourcePosition();
        if (sourcePositionBase != null) {
            SourcePositionBase it = sourcePositionBase;
            boolean bl = false;
            SourcePositionModel cfr_ignored_0 = (SourcePositionModel)it;
            VirtualFile contextFile = BackendVirtualFileSystemHostKt.fromModel(((SourcePositionModel)it).getFileId(), session);
            xSourcePositionImpl = XSourcePositionImpl.createByOffset((VirtualFile)contextFile, (int)it.getOffset());
        } else {
            xSourcePositionImpl = null;
        }
        XSourcePositionImpl sourcePosition = xSourcePositionImpl;
        String breakpointId = conditionInfo.getBreakpointId();
        XBreakpoint xBreakpoint = BackendBreakpointHost.Companion.getInstance(projectSession).getBreakpointById(breakpointId);
        if (xBreakpoint == null) {
            BackendBreakpointConditionDocumentProvider $this$document_u24lambda_u241 = this;
            boolean bl = false;
            logger.error("Can't find breakpoint with id `" + breakpointId + "`, failed to create backend document for breakpoint condition");
            return null;
        }
        XBreakpoint breakpoint = xBreakpoint;
        XBreakpointType xBreakpointType = breakpoint.getType();
        Intrinsics.checkNotNull((Object)xBreakpointType, (String)"null cannot be cast to non-null type com.intellij.xdebugger.breakpoints.XBreakpointType<com.intellij.xdebugger.breakpoints.XBreakpoint<*>, *>");
        XBreakpointType breakpointType = xBreakpointType;
        XDebuggerEditorsProvider xDebuggerEditorsProvider = breakpointType.getEditorsProvider(breakpoint, projectSession.getProject());
        if (xDebuggerEditorsProvider == null) {
            BackendBreakpointConditionDocumentProvider $this$document_u24lambda_u242 = this;
            boolean bl = false;
            logger.error("Editors provider for breakpoint " + breakpoint + " is null, failed to create backend document for breakpoint condition");
            return null;
        }
        XDebuggerEditorsProvider editorsProvider = xDebuggerEditorsProvider;
        return editorsProvider.createDocument(projectSession.getProject(), BackendDebuggerDocumentProvider.Companion.createBackendExpression(conditionInfo.getInitialExpression(), documentId), (XSourcePosition)sourcePosition, EvaluationMode.EXPRESSION);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendBreakpointConditionDocumentProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendBreakpointConditionDocumentProvider.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/debugger/BackendBreakpointConditionDocumentProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

